/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.document.impl;

import io.proleap.cobol.Cobol85PreprocessorParser;
import io.proleap.cobol.preprocessor.sub.document.impl.CobolReplacementMapping;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.BufferedTokenStream;

public class CobolDocumentContext {
    private CobolReplacementMapping[] currentReplaceableReplacements;
    private StringBuffer outputBuffer = new StringBuffer();

    public String read() {
        return this.outputBuffer.toString();
    }

    public void replaceReplaceablesByReplacements(BufferedTokenStream tokens) {
        if (this.currentReplaceableReplacements != null) {
            Arrays.sort(this.currentReplaceableReplacements);
            for (CobolReplacementMapping replaceableReplacement : this.currentReplaceableReplacements) {
                String currentOutput = this.outputBuffer.toString();
                String replacedOutput = replaceableReplacement.replace(currentOutput, tokens);
                this.outputBuffer = new StringBuffer();
                this.outputBuffer.append(replacedOutput);
            }
        }
    }

    public void storeReplaceablesAndReplacements(List<Cobol85PreprocessorParser.ReplaceClauseContext> replaceClauses) {
        if (replaceClauses == null) {
            this.currentReplaceableReplacements = null;
        } else {
            int length = replaceClauses.size();
            this.currentReplaceableReplacements = new CobolReplacementMapping[length];
            int i = 0;
            for (Cobol85PreprocessorParser.ReplaceClauseContext replaceClause : replaceClauses) {
                CobolReplacementMapping replaceableReplacement = new CobolReplacementMapping();
                replaceableReplacement.replaceable = replaceClause.replaceable();
                replaceableReplacement.replacement = replaceClause.replacement();
                this.currentReplaceableReplacements[i] = replaceableReplacement;
                ++i;
            }
        }
    }

    public void write(String text) {
        this.outputBuffer.append(text);
    }
}

