/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.document.impl;

import io.proleap.cobol.Cobol85PreprocessorLexer;
import io.proleap.cobol.Cobol85PreprocessorParser;
import io.proleap.cobol.asg.params.CobolParserParams;
import io.proleap.cobol.asg.runner.ThrowingErrorListener;
import io.proleap.cobol.preprocessor.CobolPreprocessor;
import io.proleap.cobol.preprocessor.sub.document.CobolDocumentParser;
import io.proleap.cobol.preprocessor.sub.document.CobolDocumentParserListener;
import io.proleap.cobol.preprocessor.sub.document.impl.CobolDocumentParserListenerImpl;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class CobolDocumentParserImpl
implements CobolDocumentParser {
    protected final String[] triggers = new String[]{"cbl", "copy", "exec sql", "exec sqlims", "exec cics", "process", "replace", "eject", "skip1", "skip2", "skip3", "title"};

    protected boolean containsTrigger(String code, String[] triggers) {
        String codeLowerCase = code.toLowerCase();
        boolean result = false;
        for (String trigger : triggers) {
            boolean containsTrigger = codeLowerCase.contains(trigger);
            if (!containsTrigger) continue;
            result = true;
            break;
        }
        return result;
    }

    protected CobolDocumentParserListener createDocumentParserListener(CobolPreprocessor.CobolSourceFormatEnum format, CobolParserParams params, CommonTokenStream tokens) {
        return new CobolDocumentParserListenerImpl(format, params, (BufferedTokenStream)tokens);
    }

    @Override
    public String processLines(String code, CobolPreprocessor.CobolSourceFormatEnum format, CobolParserParams params) {
        boolean requiresProcessorExecution = this.containsTrigger(code, this.triggers);
        String result = requiresProcessorExecution ? this.processWithParser(code, format, params) : code;
        return result;
    }

    protected String processWithParser(String code, CobolPreprocessor.CobolSourceFormatEnum format, CobolParserParams params) {
        Cobol85PreprocessorLexer lexer = new Cobol85PreprocessorLexer((CharStream)CharStreams.fromString((String)code));
        if (!params.getIgnoreSyntaxErrors()) {
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)new ThrowingErrorListener());
        }
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Cobol85PreprocessorParser parser = new Cobol85PreprocessorParser((TokenStream)tokens);
        if (!params.getIgnoreSyntaxErrors()) {
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)new ThrowingErrorListener());
        }
        Cobol85PreprocessorParser.StartRuleContext startRule = parser.startRule();
        CobolDocumentParserListener listener = this.createDocumentParserListener(format, params, tokens);
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, (ParseTree)startRule);
        String result = listener.context().read();
        return result;
    }
}

