/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.document.impl;

import io.proleap.cobol.Cobol85PreprocessorBaseListener;
import io.proleap.cobol.Cobol85PreprocessorParser;
import io.proleap.cobol.asg.params.CobolParserParams;
import io.proleap.cobol.preprocessor.CobolPreprocessor;
import io.proleap.cobol.preprocessor.impl.CobolPreprocessorImpl;
import io.proleap.cobol.preprocessor.sub.CobolLine;
import io.proleap.cobol.preprocessor.sub.copybook.CobolWordCopyBookFinder;
import io.proleap.cobol.preprocessor.sub.copybook.FilenameCopyBookFinder;
import io.proleap.cobol.preprocessor.sub.copybook.LiteralCopyBookFinder;
import io.proleap.cobol.preprocessor.sub.copybook.impl.CobolWordCopyBookFinderImpl;
import io.proleap.cobol.preprocessor.sub.copybook.impl.FilenameCopyBookFinderImpl;
import io.proleap.cobol.preprocessor.sub.copybook.impl.LiteralCopyBookFinderImpl;
import io.proleap.cobol.preprocessor.sub.document.CobolDocumentParserListener;
import io.proleap.cobol.preprocessor.sub.document.impl.CobolDocumentContext;
import io.proleap.cobol.preprocessor.sub.util.TokenUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import java.util.Stack;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CobolDocumentParserListenerImpl
extends Cobol85PreprocessorBaseListener
implements CobolDocumentParserListener {
    private static final Logger LOG = LogManager.getLogger(CobolDocumentParserListenerImpl.class);
    private final Stack<CobolDocumentContext> contexts = new Stack();
    private final CobolPreprocessor.CobolSourceFormatEnum format;
    private final CobolParserParams params;
    private final BufferedTokenStream tokens;

    public CobolDocumentParserListenerImpl(CobolPreprocessor.CobolSourceFormatEnum format, CobolParserParams params, BufferedTokenStream tokens) {
        this.params = params;
        this.tokens = tokens;
        this.format = format;
        this.contexts.push(new CobolDocumentContext());
    }

    protected String buildLines(String text, String linePrefix) {
        StringBuffer sb = new StringBuffer(text.length());
        Scanner scanner = new Scanner(text);
        boolean firstLine = true;
        while (scanner.hasNextLine()) {
            if (!firstLine) {
                sb.append("\n");
            }
            String line = scanner.nextLine();
            String trimmedLine = line.trim();
            String prefixedLine = linePrefix + " " + trimmedLine;
            String suffixedLine = prefixedLine.replaceAll("(?i)(end-exec)", "$1 }");
            sb.append(suffixedLine);
            firstLine = false;
        }
        scanner.close();
        return sb.toString();
    }

    @Override
    public CobolDocumentContext context() {
        return this.contexts.peek();
    }

    protected CobolWordCopyBookFinder createCobolWordCopyBookFinder() {
        return new CobolWordCopyBookFinderImpl();
    }

    protected FilenameCopyBookFinder createFilenameCopyBookFinder() {
        return new FilenameCopyBookFinderImpl();
    }

    protected LiteralCopyBookFinder createLiteralCopyBookFinder() {
        return new LiteralCopyBookFinderImpl();
    }

    @Override
    public void enterCompilerOptions(Cobol85PreprocessorParser.CompilerOptionsContext ctx) {
        this.push();
    }

    @Override
    public void enterCopyStatement(Cobol85PreprocessorParser.CopyStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterEjectStatement(Cobol85PreprocessorParser.EjectStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterExecCicsStatement(Cobol85PreprocessorParser.ExecCicsStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterExecSqlImsStatement(Cobol85PreprocessorParser.ExecSqlImsStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterExecSqlStatement(Cobol85PreprocessorParser.ExecSqlStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterReplaceArea(Cobol85PreprocessorParser.ReplaceAreaContext ctx) {
        this.push();
    }

    @Override
    public void enterReplaceByStatement(Cobol85PreprocessorParser.ReplaceByStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterReplaceOffStatement(Cobol85PreprocessorParser.ReplaceOffStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterSkipStatement(Cobol85PreprocessorParser.SkipStatementContext ctx) {
        this.push();
    }

    @Override
    public void enterTitleStatement(Cobol85PreprocessorParser.TitleStatementContext ctx) {
        this.push();
    }

    @Override
    public void exitCompilerOptions(Cobol85PreprocessorParser.CompilerOptionsContext ctx) {
        this.pop();
    }

    @Override
    public void exitCopyStatement(Cobol85PreprocessorParser.CopyStatementContext ctx) {
        this.pop();
        this.push();
        for (Cobol85PreprocessorParser.ReplacingPhraseContext replacingPhrase : ctx.replacingPhrase()) {
            this.context().storeReplaceablesAndReplacements(replacingPhrase.replaceClause());
        }
        Cobol85PreprocessorParser.CopySourceContext copySource = ctx.copySource();
        String copyBookContent = this.getCopyBookContent(copySource, this.format, this.params);
        if (copyBookContent != null) {
            this.context().write(copyBookContent + "\n");
            this.context().replaceReplaceablesByReplacements(this.tokens);
        }
        String content = this.context().read();
        this.pop();
        this.context().write(content);
    }

    @Override
    public void exitEjectStatement(Cobol85PreprocessorParser.EjectStatementContext ctx) {
        this.pop();
    }

    @Override
    public void exitExecCicsStatement(Cobol85PreprocessorParser.ExecCicsStatementContext ctx) {
        this.pop();
        this.push();
        String text = TokenUtils.getTextIncludingHiddenTokens((ParseTree)ctx, this.tokens);
        String linePrefix = CobolLine.createBlankSequenceArea(this.format) + "*>EXECCICS";
        String lines = this.buildLines(text, linePrefix);
        this.context().write(lines);
        String content = this.context().read();
        this.pop();
        this.context().write(content);
    }

    @Override
    public void exitExecSqlImsStatement(Cobol85PreprocessorParser.ExecSqlImsStatementContext ctx) {
        this.pop();
        this.push();
        String text = TokenUtils.getTextIncludingHiddenTokens((ParseTree)ctx, this.tokens);
        String linePrefix = CobolLine.createBlankSequenceArea(this.format) + "*>EXECSQLIMS";
        String lines = this.buildLines(text, linePrefix);
        this.context().write(lines);
        String content = this.context().read();
        this.pop();
        this.context().write(content);
    }

    @Override
    public void exitExecSqlStatement(Cobol85PreprocessorParser.ExecSqlStatementContext ctx) {
        this.pop();
        this.push();
        String text = TokenUtils.getTextIncludingHiddenTokens((ParseTree)ctx, this.tokens);
        String linePrefix = CobolLine.createBlankSequenceArea(this.format) + "*>EXECSQL";
        String lines = this.buildLines(text, linePrefix);
        this.context().write(lines);
        String content = this.context().read();
        this.pop();
        this.context().write(content);
    }

    @Override
    public void exitReplaceArea(Cobol85PreprocessorParser.ReplaceAreaContext ctx) {
        List<Cobol85PreprocessorParser.ReplaceClauseContext> replaceClauses = ctx.replaceByStatement().replaceClause();
        this.context().storeReplaceablesAndReplacements(replaceClauses);
        this.context().replaceReplaceablesByReplacements(this.tokens);
        String content = this.context().read();
        this.pop();
        this.context().write(content);
    }

    @Override
    public void exitReplaceByStatement(Cobol85PreprocessorParser.ReplaceByStatementContext ctx) {
        this.pop();
    }

    @Override
    public void exitReplaceOffStatement(Cobol85PreprocessorParser.ReplaceOffStatementContext ctx) {
        this.pop();
    }

    @Override
    public void exitSkipStatement(Cobol85PreprocessorParser.SkipStatementContext ctx) {
        this.pop();
    }

    @Override
    public void exitTitleStatement(Cobol85PreprocessorParser.TitleStatementContext ctx) {
        this.pop();
    }

    protected File findCopyBook(Cobol85PreprocessorParser.CopySourceContext copySource, CobolParserParams params) {
        File result;
        if (copySource.cobolWord() != null) {
            result = this.createCobolWordCopyBookFinder().findCopyBook(params, copySource.cobolWord());
        } else if (copySource.literal() != null) {
            result = this.createLiteralCopyBookFinder().findCopyBook(params, copySource.literal());
        } else if (copySource.filename() != null) {
            result = this.createFilenameCopyBookFinder().findCopyBook(params, copySource.filename());
        } else {
            LOG.warn("unknown copy book reference type {}", (Object)copySource);
            result = null;
        }
        return result;
    }

    protected String getCopyBookContent(Cobol85PreprocessorParser.CopySourceContext copySource, CobolPreprocessor.CobolSourceFormatEnum format, CobolParserParams params) {
        String result;
        File copyBook = this.findCopyBook(copySource, params);
        if (copyBook == null) {
            LOG.warn("Could not find copy book {} in directory of COBOL input file or copy books param object.", (Object)copySource.getText());
            result = null;
        } else {
            try {
                result = new CobolPreprocessorImpl().process(copyBook, format, params);
            }
            catch (IOException e) {
                result = null;
                LOG.warn(e.getMessage());
            }
        }
        return result;
    }

    protected CobolDocumentContext pop() {
        return this.contexts.pop();
    }

    protected CobolDocumentContext push() {
        return this.contexts.push(new CobolDocumentContext());
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        int tokPos = node.getSourceInterval().a;
        this.context().write(TokenUtils.getHiddenTokensToLeft(tokPos, this.tokens));
        if (!TokenUtils.isEOF(node)) {
            String text = node.getText();
            this.context().write(text);
        }
    }
}

