/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.line.rewriter.impl;

import io.proleap.cobol.asg.params.CobolDialect;
import io.proleap.cobol.preprocessor.sub.CobolLine;
import io.proleap.cobol.preprocessor.sub.CobolLineTypeEnum;
import io.proleap.cobol.preprocessor.sub.line.rewriter.CobolCommentEntriesMarker;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CobolCommentEntriesMarkerImpl
implements CobolCommentEntriesMarker {
    protected final Pattern commentEntryTriggerLinePattern;
    protected boolean foundCommentEntryTriggerInPreviousLine = false;
    protected boolean isInCommentEntry = false;
    protected final String[] triggersEnd = new String[]{"PROGRAM-ID.", "AUTHOR.", "INSTALLATION.", "DATE-WRITTEN.", "DATE-COMPILED.", "SECURITY.", "ENVIRONMENT", "DATA.", "PROCEDURE."};
    protected final String[] triggersStart = new String[]{"AUTHOR.", "INSTALLATION.", "DATE-WRITTEN.", "DATE-COMPILED.", "SECURITY.", "REMARKS."};

    public CobolCommentEntriesMarkerImpl() {
        String commentEntryTriggerLineFormat = new String("([ \\t]*)(" + String.join((CharSequence)"|", this.triggersStart) + ")(.+)");
        this.commentEntryTriggerLinePattern = Pattern.compile(commentEntryTriggerLineFormat, 2);
    }

    protected CobolLine buildMultiLineCommentEntryLine(CobolLine line) {
        return CobolLine.copyCobolLineWithIndicatorArea("*>CE ", line);
    }

    protected CobolLine escapeCommentEntry(CobolLine line) {
        CobolLine result;
        Matcher matcher = this.commentEntryTriggerLinePattern.matcher(line.getContentArea());
        if (matcher.matches()) {
            String whitespace = matcher.group(1);
            String trigger = matcher.group(2);
            String commentEntry = matcher.group(3);
            String newContentArea = whitespace + trigger + " " + "*>CE" + commentEntry;
            result = CobolLine.copyCobolLineWithContentArea(newContentArea, line);
        } else {
            result = line;
        }
        return result;
    }

    protected boolean isInCommentEntry(CobolLine line, boolean isContentAreaAEmpty, boolean isInOsvsCommentEntry) {
        boolean result = CobolLineTypeEnum.COMMENT.equals((Object)line.getType()) || isContentAreaAEmpty || isInOsvsCommentEntry;
        return result;
    }

    protected boolean isInOsvsCommentEntry(CobolLine line) {
        boolean result = CobolDialect.OSVS.equals((Object)line.getDialect()) && !this.startsWithTrigger(line, this.triggersEnd);
        return result;
    }

    @Override
    public CobolLine processLine(CobolLine line) {
        CobolLine result = line.getFormat().isCommentEntryMultiLine() ? this.processMultiLineCommentEntry(line) : this.processSingleLineCommentEntry(line);
        return result;
    }

    @Override
    public List<CobolLine> processLines(List<CobolLine> lines) {
        ArrayList<CobolLine> result = new ArrayList<CobolLine>();
        for (CobolLine line : lines) {
            CobolLine processedLine = this.processLine(line);
            result.add(processedLine);
        }
        return result;
    }

    protected CobolLine processMultiLineCommentEntry(CobolLine line) {
        CobolLine result;
        boolean foundCommentEntryTriggerInCurrentLine = this.startsWithTrigger(line, this.triggersStart);
        if (foundCommentEntryTriggerInCurrentLine) {
            result = this.escapeCommentEntry(line);
        } else if (this.foundCommentEntryTriggerInPreviousLine || this.isInCommentEntry) {
            boolean isContentAreaAEmpty = line.getContentAreaA().trim().isEmpty();
            boolean isInOsvsCommentEntry = this.isInOsvsCommentEntry(line);
            this.isInCommentEntry = this.isInCommentEntry(line, isContentAreaAEmpty, isInOsvsCommentEntry);
            result = this.isInCommentEntry ? this.buildMultiLineCommentEntryLine(line) : line;
        } else {
            result = line;
        }
        this.foundCommentEntryTriggerInPreviousLine = foundCommentEntryTriggerInCurrentLine;
        return result;
    }

    protected CobolLine processSingleLineCommentEntry(CobolLine line) {
        boolean foundCommentEntryTriggerInCurrentLine = this.startsWithTrigger(line, this.triggersStart);
        CobolLine result = foundCommentEntryTriggerInCurrentLine ? this.escapeCommentEntry(line) : line;
        return result;
    }

    protected boolean startsWithTrigger(CobolLine line, String[] triggers) {
        String contentAreaUpperCase = new String(line.getContentArea()).toUpperCase();
        boolean result = false;
        for (String trigger : triggers) {
            boolean containsTrigger = contentAreaUpperCase.trim().startsWith(trigger);
            if (!containsTrigger) continue;
            result = true;
            break;
        }
        return result;
    }
}

