/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.line.rewriter.impl;

import io.proleap.cobol.preprocessor.sub.CobolLine;
import io.proleap.cobol.preprocessor.sub.line.rewriter.CobolInlineCommentEntriesNormalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CobolInlineCommentEntriesNormalizerImpl
implements CobolInlineCommentEntriesNormalizer {
    protected static final String denormalizedCommentEntryRegex = "\\*>[^ ]";
    protected final Pattern denormalizedCommentEntryPattern = Pattern.compile("\\*>[^ ]");

    @Override
    public CobolLine processLine(CobolLine line) {
        CobolLine result;
        Matcher matcher = this.denormalizedCommentEntryPattern.matcher(line.getContentArea());
        if (!matcher.find()) {
            result = line;
        } else {
            String newContentArea = line.getContentArea().replace("*>", "*> ");
            result = CobolLine.copyCobolLineWithContentArea(newContentArea, line);
        }
        return result;
    }

    @Override
    public List<CobolLine> processLines(List<CobolLine> lines) {
        ArrayList<CobolLine> result = new ArrayList<CobolLine>();
        for (CobolLine line : lines) {
            CobolLine processedLine = this.processLine(line);
            result.add(processedLine);
        }
        return result;
    }
}

