/*
 * Decompiled with CFR 0.152.
 */
package io.proleap.cobol.preprocessor.sub.line.rewriter.impl;

import io.proleap.cobol.preprocessor.sub.CobolLine;
import io.proleap.cobol.preprocessor.sub.CobolLineTypeEnum;
import io.proleap.cobol.preprocessor.sub.line.rewriter.CobolLineIndicatorProcessor;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.util.Strings;

public class CobolLineIndicatorProcessorImpl
implements CobolLineIndicatorProcessor {
    protected static final String EMPTY_STRING = "";

    protected String conditionalRightTrimContentArea(CobolLine line) {
        String result = !this.isNextLineContinuation(line) ? this.rightTrimContentArea(line.getContentArea()) : (!this.isEndingWithOpenLiteral(line) ? this.rightTrimContentArea(line.getContentArea()) : line.getContentArea());
        return result;
    }

    protected boolean isEndingWithOpenLiteral(CobolLine line) {
        String contentArea = line.getContentAreaOriginal();
        String contentAreaWithoutStringLiterals = this.removeStringLiterals(contentArea);
        return contentAreaWithoutStringLiterals.contains("\"") || contentAreaWithoutStringLiterals.contains("'");
    }

    protected boolean isNextLineContinuation(CobolLine line) {
        return line.getSuccessor() == null ? false : CobolLineTypeEnum.CONTINUATION.equals((Object)line.getSuccessor().getType());
    }

    @Override
    public CobolLine processLine(CobolLine line) {
        CobolLine result;
        String conditionalRightTrimmedContentArea = this.conditionalRightTrimContentArea(line);
        switch (line.getType()) {
            case DEBUG: {
                result = CobolLine.copyCobolLineWithIndicatorAndContentArea(" ", conditionalRightTrimmedContentArea, line);
                break;
            }
            case CONTINUATION: {
                if (Strings.isBlank((String)conditionalRightTrimmedContentArea)) {
                    result = CobolLine.copyCobolLineWithIndicatorAndContentArea(" ", EMPTY_STRING, line);
                    break;
                }
                if (line.getPredecessor() != null && (line.getPredecessor().getContentAreaOriginal().endsWith("\"") || line.getPredecessor().getContentAreaOriginal().endsWith("'"))) {
                    String trimmedContentArea = this.trimLeadingWhitespace(conditionalRightTrimmedContentArea);
                    if (trimmedContentArea.startsWith("\"") || trimmedContentArea.startsWith("'")) {
                        result = CobolLine.copyCobolLineWithIndicatorAndContentArea(" ", this.trimLeadingChar(trimmedContentArea), line);
                        break;
                    }
                    result = CobolLine.copyCobolLineWithIndicatorAndContentArea(" ", this.trimLeadingWhitespace(conditionalRightTrimmedContentArea), line);
                    break;
                }
                if (line.getPredecessor() != null && this.isEndingWithOpenLiteral(line.getPredecessor())) {
                    String trimmedContentArea = this.trimLeadingWhitespace(conditionalRightTrimmedContentArea);
                    if (trimmedContentArea.startsWith("\"") || trimmedContentArea.startsWith("'")) {
                        result = CobolLine.copyCobolLineWithIndicatorAndContentArea(" ", this.trimLeadingChar(trimmedContentArea), line);
                        break;
                    }
                    result = CobolLine.copyCobolLineWithIndicatorAndContentArea(" ", conditionalRightTrimmedContentArea, line);
                    break;
                }
                if (line.getPredecessor() != null && (line.getPredecessor().getContentArea().endsWith("\"") || line.getPredecessor().getContentArea().endsWith("'"))) {
                    result = CobolLine.copyCobolLineWithIndicatorAndContentArea(" ", " " + this.trimLeadingWhitespace(conditionalRightTrimmedContentArea), line);
                    break;
                }
                result = CobolLine.copyCobolLineWithIndicatorAndContentArea(" ", this.trimLeadingWhitespace(conditionalRightTrimmedContentArea), line);
                break;
            }
            case COMMENT: {
                result = CobolLine.copyCobolLineWithIndicatorAndContentArea("*> ", conditionalRightTrimmedContentArea, line);
                break;
            }
            case COMPILER_DIRECTIVE: {
                result = CobolLine.copyCobolLineWithIndicatorAndContentArea(" ", EMPTY_STRING, line);
                break;
            }
            default: {
                result = CobolLine.copyCobolLineWithIndicatorAndContentArea(" ", conditionalRightTrimmedContentArea, line);
            }
        }
        return result;
    }

    @Override
    public List<CobolLine> processLines(List<CobolLine> lines) {
        ArrayList<CobolLine> result = new ArrayList<CobolLine>();
        for (CobolLine line : lines) {
            CobolLine processedLine = this.processLine(line);
            result.add(processedLine);
        }
        return result;
    }

    protected String removeStringLiterals(String contentArea) {
        String doubleQuoteLiteralPattern = "\"([^\"]|\"\"|'')*\"";
        String singleQuoteLiteralPattern = "'([^']|''|\"\")*'";
        return contentArea.replaceAll("\"([^\"]|\"\"|'')*\"", EMPTY_STRING).replaceAll("'([^']|''|\"\")*'", EMPTY_STRING);
    }

    protected String repairTrailingComma(String contentArea) {
        char lastCharAtTrimmedLineArea;
        String result = contentArea.isEmpty() ? contentArea : ((lastCharAtTrimmedLineArea = contentArea.charAt(contentArea.length() - 1)) == ',' || lastCharAtTrimmedLineArea == ';' ? contentArea + " " : contentArea);
        return result;
    }

    protected String rightTrimContentArea(String contentarea) {
        String contentAreaWithTrimmedTrailingWhitespace = this.trimTrailingWhitespace(contentarea);
        return this.repairTrailingComma(contentAreaWithTrimmedTrailingWhitespace);
    }

    protected String trimLeadingChar(String contentArea) {
        return contentArea.substring(1);
    }

    protected String trimLeadingWhitespace(String contentarea) {
        return contentarea.replaceAll("^\\s+", EMPTY_STRING);
    }

    protected String trimTrailingWhitespace(String contentArea) {
        return contentArea.replaceAll("\\s+$", EMPTY_STRING);
    }
}

