/*
 * Decompiled with CFR 0.152.
 */
package net.imagej;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.imagej.Data;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.event.DataCreatedEvent;
import net.imagej.event.DataDeletedEvent;
import net.imagej.interval.AbstractCalibratedRealInterval;
import net.imglib2.RealInterval;
import org.scijava.Context;
import org.scijava.NullContextException;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.plugin.Parameter;

public abstract class AbstractData
extends AbstractCalibratedRealInterval<CalibratedAxis>
implements Data,
Comparable<Data>,
Externalizable {
    @Parameter
    private Context context;
    private String name;
    private int refs = 0;
    @Parameter(required=false)
    private EventService eventService;
    private static final String BOGUS_NAME = "NULL 42 PI E 8 GAMMA PHI WOOHOO!";

    public AbstractData(RealInterval interval) {
        super(interval);
    }

    public AbstractData(Context context, RealInterval interval) {
        super(interval);
        if (context != null) {
            this.setContext(context);
        }
    }

    protected void register() {
        this.publish((SciJavaEvent)new DataCreatedEvent(this));
    }

    protected void delete() {
        this.publish((SciJavaEvent)new DataDeletedEvent(this));
    }

    public String toString() {
        String n = this.getName();
        return n == null ? "<unnamed data>" : n;
    }

    @Override
    public void incrementReferences() {
        ++this.refs;
        if (this.refs == 1) {
            this.register();
        }
    }

    @Override
    public void decrementReferences() {
        if (this.refs == 0) {
            throw new IllegalStateException("decrementing reference count when it is already 0");
        }
        --this.refs;
        if (this.refs == 0) {
            this.delete();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(Data data) {
        return this.getName().compareTo(data.getName());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.name == null) {
            out.writeUTF(BOGUS_NAME);
        } else {
            out.writeUTF(this.name);
        }
        int numAxes = this.numDimensions();
        out.writeInt(numAxes);
        for (int i = 0; i < numAxes; ++i) {
            CalibratedAxis axis = (CalibratedAxis)this.axis(i);
            out.writeUTF(axis.type().getLabel());
            out.writeDouble(this.averageScale(i));
            if (axis.unit() == null) {
                out.writeUTF(BOGUS_NAME);
                continue;
            }
            out.writeUTF(axis.unit());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        if (this.name.equals(BOGUS_NAME)) {
            this.name = null;
        }
        int numAxes = in.readInt();
        for (int i = 0; i < numAxes; ++i) {
            AxisType type = Axes.get(in.readUTF());
            double cal = in.readDouble();
            String unitString = in.readUTF();
            String unit = unitString.equals(BOGUS_NAME) ? null : unitString;
            DefaultLinearAxis axis = new DefaultLinearAxis(type, unit, cal);
            this.setAxis(axis, i);
        }
    }

    public Context context() {
        if (this.context == null) {
            throw new NullContextException();
        }
        return this.context;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        context.inject((Object)this);
    }

    protected void publish(SciJavaEvent event) {
        if (this.eventService != null) {
            this.eventService.publish(event);
        }
    }
}

