/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.convert;

import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imagej.convert.ConciseConverter;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.util.Util;
import org.scijava.Context;
import org.scijava.convert.Converter;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public class ImageConverters {
    private ImageConverters() {
    }

    private static <T> void validateImageType(RandomAccessibleInterval<T> rai) {
        Object t = Util.getTypeFromInterval(rai);
        if (!(t instanceof Type)) {
            throw new IllegalArgumentException("Image type '" + t.getClass().getName() + " ' is not a Type");
        }
    }

    private static <T> Img<T> rai2img(RandomAccessibleInterval<T> rai) {
        ImageConverters.validateImageType(rai);
        return ImgPlus.wrapToImg(rai);
    }

    private static <T> ImgPlus<T> img2ip(Img<T> img) {
        return new ImgPlus<T>(img);
    }

    private static <T extends Type<T>> Dataset ip2ds(ImgPlus<T> imgPlus, Context ctx) {
        ImageConverters.validateImageType(imgPlus);
        return ((DatasetService)ctx.service(DatasetService.class)).create(imgPlus);
    }

    private static DatasetView ds2dv(Dataset dataset) {
        ImageDisplayService imageDisplayService = (ImageDisplayService)dataset.context().service(ImageDisplayService.class);
        return imageDisplayService.createDatasetView(dataset);
    }

    private static ImageDisplay dv2disp(DatasetView datasetView) {
        ImageDisplayService imageDisplayService = (ImageDisplayService)datasetView.context().service(ImageDisplayService.class);
        return imageDisplayService.createImageDisplay(datasetView);
    }

    private static DatasetView disp2dv(ImageDisplay imageDisplay) {
        ImageDisplayService imageDisplayService = (ImageDisplayService)imageDisplay.context().service(ImageDisplayService.class);
        return imageDisplayService.getActiveDatasetView(imageDisplay);
    }

    private static Dataset dv2ds(DatasetView datasetView) {
        return datasetView.getData();
    }

    private static ImgPlus<?> ds2ip(Dataset dataset) {
        return dataset.getImgPlus();
    }

    private static <T> Img<T> ip2img(ImgPlus<T> imgPlus) {
        return imgPlus.getImg();
    }

    @Plugin(type=Converter.class)
    public static class ImageDisplayToDatasetViewConverter
    extends ConciseConverter<ImageDisplay, DatasetView> {
        public ImageDisplayToDatasetViewConverter() {
            super(ImageDisplay.class, DatasetView.class, x$0 -> ImageConverters.disp2dv(x$0));
        }
    }

    @Plugin(type=Converter.class)
    public static class ImageDisplayToDatasetConverter
    extends ConciseConverter<ImageDisplay, Dataset> {
        public ImageDisplayToDatasetConverter() {
            super(ImageDisplay.class, Dataset.class, src -> ImageConverters.dv2ds(ImageConverters.disp2dv(src)));
        }
    }

    @Plugin(type=Converter.class)
    public static class ImageDisplayToImgPlusConverter
    extends ConciseConverter<ImageDisplay, ImgPlus> {
        public ImageDisplayToImgPlusConverter() {
            super(ImageDisplay.class, ImgPlus.class, src -> ImageConverters.ds2ip(ImageConverters.dv2ds(ImageConverters.disp2dv(src))));
        }
    }

    @Plugin(type=Converter.class, priority=-100.0)
    public static class ImageDisplayToImgConverter
    extends ConciseConverter<ImageDisplay, Img> {
        public ImageDisplayToImgConverter() {
            super(ImageDisplay.class, Img.class, src -> ImageConverters.ip2img(ImageConverters.ds2ip(ImageConverters.dv2ds(ImageConverters.disp2dv(src)))));
        }
    }

    @Plugin(type=Converter.class)
    public static class DatasetViewToImageDisplayConverter
    extends ConciseConverter<DatasetView, ImageDisplay> {
        public DatasetViewToImageDisplayConverter() {
            super(DatasetView.class, ImageDisplay.class, x$0 -> ImageConverters.dv2disp(x$0));
        }
    }

    @Plugin(type=Converter.class)
    public static class DatasetViewToDatasetConverter
    extends ConciseConverter<DatasetView, Dataset> {
        public DatasetViewToDatasetConverter() {
            super(DatasetView.class, Dataset.class, x$0 -> ImageConverters.dv2ds(x$0));
        }
    }

    @Plugin(type=Converter.class)
    public static class DatasetViewToImgPlusConverter
    extends ConciseConverter<DatasetView, ImgPlus> {
        public DatasetViewToImgPlusConverter() {
            super(DatasetView.class, ImgPlus.class, src -> ImageConverters.ds2ip(ImageConverters.dv2ds(src)));
        }
    }

    @Plugin(type=Converter.class, priority=-100.0)
    public static class DatasetViewToImgConverter
    extends ConciseConverter<DatasetView, Img> {
        public DatasetViewToImgConverter() {
            super(DatasetView.class, Img.class, src -> ImageConverters.ip2img(ImageConverters.ds2ip(ImageConverters.dv2ds(src))));
        }
    }

    @Plugin(type=Converter.class)
    public static class DatasetToImageDisplayConverter
    extends ConciseConverter<Dataset, ImageDisplay> {
        public DatasetToImageDisplayConverter() {
            super(Dataset.class, ImageDisplay.class, src -> ImageConverters.dv2disp(ImageConverters.ds2dv(src)));
        }
    }

    @Plugin(type=Converter.class)
    public static class DatasetToDatasetViewConverter
    extends ConciseConverter<Dataset, DatasetView> {
        public DatasetToDatasetViewConverter() {
            super(Dataset.class, DatasetView.class, src -> {
                DatasetView view = ImageConverters.ds2dv(src);
                view.rebuild();
                return view;
            });
        }
    }

    @Plugin(type=Converter.class)
    public static class DatasetToImgPlusConverter
    extends ConciseConverter<Dataset, ImgPlus> {
        public DatasetToImgPlusConverter() {
            super(Dataset.class, ImgPlus.class, x$0 -> ImageConverters.ds2ip(x$0));
        }
    }

    @Plugin(type=Converter.class, priority=-100.0)
    public static class DatasetToImgConverter
    extends ConciseConverter<Dataset, Img> {
        public DatasetToImgConverter() {
            super(Dataset.class, Img.class, src -> ImageConverters.ip2img(ImageConverters.ds2ip(src)));
        }
    }

    @Plugin(type=Converter.class)
    public static class ImgPlusToImageDisplayConverter
    extends ConciseConverter<ImgPlus, ImageDisplay> {
        @Parameter
        private Context ctx;

        public ImgPlusToImageDisplayConverter() {
            super(ImgPlus.class, ImageDisplay.class, null);
        }

        @Override
        protected ImageDisplay convert(ImgPlus src) {
            return ImageConverters.dv2disp(ImageConverters.ds2dv(ImageConverters.ip2ds(src, this.ctx)));
        }
    }

    @Plugin(type=Converter.class)
    public static class ImgPlusToDatasetViewConverter
    extends ConciseConverter<ImgPlus, DatasetView> {
        @Parameter
        private Context ctx;

        public ImgPlusToDatasetViewConverter() {
            super(ImgPlus.class, DatasetView.class, null);
        }

        @Override
        protected DatasetView convert(ImgPlus src) {
            return ImageConverters.ds2dv(ImageConverters.ip2ds(src, this.ctx));
        }
    }

    @Plugin(type=Converter.class)
    public static class ImgPlusToDatasetConverter
    extends ConciseConverter<ImgPlus, Dataset> {
        @Parameter
        private Context ctx;

        public ImgPlusToDatasetConverter() {
            super(ImgPlus.class, Dataset.class, null);
        }

        @Override
        protected Dataset convert(ImgPlus src) {
            return ImageConverters.ip2ds(src, this.ctx);
        }
    }

    @Plugin(type=Converter.class, priority=-100.0)
    public static class ImgPlusToImgConverter
    extends ConciseConverter<ImgPlus, Img> {
        public ImgPlusToImgConverter() {
            super(ImgPlus.class, Img.class, x$0 -> ImageConverters.ip2img(x$0));
        }
    }

    @Plugin(type=Converter.class, priority=-100.0)
    public static class ImgToImageDisplayConverter
    extends ConciseConverter<Img, ImageDisplay> {
        @Parameter
        private Context ctx;

        public ImgToImageDisplayConverter() {
            super(Img.class, ImageDisplay.class, null);
        }

        @Override
        protected ImageDisplay convert(Img src) {
            return ImageConverters.dv2disp(ImageConverters.ds2dv(ImageConverters.ip2ds(ImageConverters.img2ip(src), this.ctx)));
        }
    }

    @Plugin(type=Converter.class, priority=-100.0)
    public static class ImgToDatasetViewConverter
    extends ConciseConverter<Img, DatasetView> {
        @Parameter
        private Context ctx;

        public ImgToDatasetViewConverter() {
            super(Img.class, DatasetView.class, null);
        }

        @Override
        protected DatasetView convert(Img src) {
            return ImageConverters.ds2dv(ImageConverters.ip2ds(ImageConverters.img2ip(src), this.ctx));
        }
    }

    @Plugin(type=Converter.class, priority=-100.0)
    public static class ImgToDatasetConverter
    extends ConciseConverter<Img, Dataset> {
        @Parameter
        private Context ctx;

        public ImgToDatasetConverter() {
            super(Img.class, Dataset.class, null);
        }

        @Override
        protected Dataset convert(Img src) {
            return ImageConverters.ip2ds(ImageConverters.img2ip(src), this.ctx);
        }
    }

    @Plugin(type=Converter.class, priority=-100.0)
    public static class ImgToImgPlusConverter
    extends ConciseConverter<Img, ImgPlus> {
        public ImgToImgPlusConverter() {
            super(Img.class, ImgPlus.class, x$0 -> ImageConverters.img2ip(x$0));
        }
    }

    @Plugin(type=Converter.class, priority=-10000.0)
    public static class RAIToImageDisplayConverter
    extends ConciseConverter<RandomAccessibleInterval, ImageDisplay> {
        @Parameter
        private Context ctx;

        public RAIToImageDisplayConverter() {
            super(RandomAccessibleInterval.class, ImageDisplay.class, null);
        }

        @Override
        protected ImageDisplay convert(RandomAccessibleInterval src) {
            return ImageConverters.dv2disp(ImageConverters.ds2dv(ImageConverters.ip2ds(ImageConverters.img2ip(ImageConverters.rai2img(src)), this.ctx)));
        }
    }

    @Plugin(type=Converter.class, priority=-10000.0)
    public static class RAIToDatasetViewConverter
    extends ConciseConverter<RandomAccessibleInterval, DatasetView> {
        @Parameter
        private Context ctx;

        public RAIToDatasetViewConverter() {
            super(RandomAccessibleInterval.class, DatasetView.class, null);
        }

        @Override
        protected DatasetView convert(RandomAccessibleInterval src) {
            return ImageConverters.ds2dv(ImageConverters.ip2ds(ImageConverters.img2ip(ImageConverters.rai2img(src)), this.ctx));
        }
    }

    @Plugin(type=Converter.class, priority=-10000.0)
    public static class RAIToDatasetConverter
    extends ConciseConverter<RandomAccessibleInterval, Dataset> {
        @Parameter
        private Context ctx;

        public RAIToDatasetConverter() {
            super(RandomAccessibleInterval.class, Dataset.class, null);
        }

        @Override
        protected Dataset convert(RandomAccessibleInterval src) {
            return ImageConverters.ip2ds(ImageConverters.img2ip(ImageConverters.rai2img(src)), this.ctx);
        }
    }

    @Plugin(type=Converter.class, priority=-10000.0)
    public static class RAIToImgPlusConverter
    extends ConciseConverter<RandomAccessibleInterval, ImgPlus> {
        public RAIToImgPlusConverter() {
            super(RandomAccessibleInterval.class, ImgPlus.class, src -> ImageConverters.img2ip(ImageConverters.rai2img(src)));
        }
    }

    @Plugin(type=Converter.class, priority=-1000000.0)
    public static class RAIToImgConverter
    extends ConciseConverter<RandomAccessibleInterval, Img> {
        public RAIToImgConverter() {
            super(RandomAccessibleInterval.class, Img.class, x$0 -> ImageConverters.rai2img(x$0));
        }
    }
}

