/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imagej.types.UnboundedIntegerType;
import org.scijava.AbstractContextual;

public class DataTypeVariableBitSignedInteger
extends AbstractContextual
implements DataType<UnboundedIntegerType> {
    private UnboundedIntegerType type = new UnboundedIntegerType();

    @Override
    public UnboundedIntegerType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "Unbounded integer";
    }

    @Override
    public String longName() {
        return "Unbounded integer";
    }

    @Override
    public String description() {
        return "An integer data type whose size is unrestricted";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public void lowerBound(UnboundedIntegerType dest) {
        throw new UnsupportedOperationException("This data type is unbounded");
    }

    @Override
    public void upperBound(UnboundedIntegerType dest) {
        throw new UnsupportedOperationException("This data type is unbounded");
    }

    @Override
    public int bitCount() {
        return -1;
    }

    @Override
    public UnboundedIntegerType createVariable() {
        return new UnboundedIntegerType();
    }

    @Override
    public void cast(UnboundedIntegerType val, BigComplex dest) {
        dest.setReal(val.get());
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, UnboundedIntegerType dest) {
        dest.set(val.getReal().toBigInteger());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return false;
    }

    @Override
    public boolean hasLongRepresentation() {
        return false;
    }

    @Override
    public double asDouble(UnboundedIntegerType val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong(UnboundedIntegerType val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(UnboundedIntegerType val, double v) {
        this.setLong(val, (long)v);
    }

    @Override
    public void setLong(UnboundedIntegerType val, long v) {
        val.set(BigInteger.valueOf(v));
    }
}

