/*
 * Decompiled with CFR 0.152.
 */
package net.imagej;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.imagej.Data;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.DefaultDataset;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.IdentityAxis;
import net.imagej.display.DataView;
import net.imagej.display.ImageDisplay;
import net.imagej.types.DataTypeService;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converters;
import net.imglib2.converter.readwrite.WriteConvertedRandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import org.scijava.log.LogService;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.ScriptService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public final class DefaultDatasetService
extends AbstractService
implements DatasetService {
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private LogService log;
    @Parameter
    private ObjectService objectService;
    @Parameter
    private DataTypeService dataTypeService;

    @Override
    public ObjectService getObjectService() {
        return this.objectService;
    }

    @Override
    public List<Dataset> getDatasets() {
        return this.objectService.getObjects(Dataset.class);
    }

    @Override
    public List<Dataset> getDatasets(ImageDisplay display) {
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        if (display != null) {
            Iterator iterator = display.iterator();
            while (iterator.hasNext()) {
                DataView view = (DataView)iterator.next();
                Data data = view.getData();
                if (!(data instanceof Dataset)) continue;
                Dataset dataset = (Dataset)data;
                datasets.add(dataset);
            }
        }
        return datasets;
    }

    @Override
    public Dataset create(long[] dims, String name, AxisType[] axes, int bitsPerPixel, boolean signed, boolean floating) {
        return this.create(dims, name, axes, bitsPerPixel, signed, floating, false);
    }

    @Override
    public Dataset create(long[] dims, String name, AxisType[] axes, int bitsPerPixel, boolean signed, boolean floating, boolean virtual) {
        if (bitsPerPixel == 1) {
            if (signed || floating) {
                this.invalidParams(bitsPerPixel, signed, floating);
            }
            return this.create(new BitType(), dims, name, axes, virtual);
        }
        if (bitsPerPixel == 8) {
            if (floating) {
                this.invalidParams(bitsPerPixel, signed, floating);
            }
            if (signed) {
                return this.create(new ByteType(), dims, name, axes, virtual);
            }
            return this.create(new UnsignedByteType(), dims, name, axes, virtual);
        }
        if (bitsPerPixel == 12) {
            if (signed || floating) {
                this.invalidParams(bitsPerPixel, signed, floating);
            }
            return this.create(new Unsigned12BitType(), dims, name, axes, virtual);
        }
        if (bitsPerPixel == 16) {
            if (floating) {
                this.invalidParams(bitsPerPixel, signed, floating);
            }
            if (signed) {
                return this.create(new ShortType(), dims, name, axes, virtual);
            }
            return this.create(new UnsignedShortType(), dims, name, axes, virtual);
        }
        if (bitsPerPixel == 32) {
            if (floating) {
                if (!signed) {
                    this.invalidParams(bitsPerPixel, signed, floating);
                }
                return this.create(new FloatType(), dims, name, axes, virtual);
            }
            if (signed) {
                return this.create(new IntType(), dims, name, axes, virtual);
            }
            return this.create(new UnsignedIntType(), dims, name, axes, virtual);
        }
        if (bitsPerPixel == 64) {
            if (!signed) {
                this.invalidParams(bitsPerPixel, signed, floating);
            }
            if (floating) {
                return this.create(new DoubleType(), dims, name, axes, virtual);
            }
            return this.create(new LongType(), dims, name, axes, virtual);
        }
        this.invalidParams(bitsPerPixel, signed, floating);
        return null;
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> Dataset create(T type, long[] dims, String name, AxisType[] axes) {
        return this.create(type, dims, name, axes, false);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> Dataset create(T type, long[] dims, String name, AxisType[] axes, boolean virtual) {
        Object imgFactory = virtual ? new CellImgFactory((NativeType<T>)type) : new PlanarImgFactory((NativeType<T>)type);
        return this.create((ImgFactory<T>)imgFactory, dims, name, axes);
    }

    @Override
    public <T extends RealType<T>> Dataset create(ImgFactory<T> factory, long[] dims, String name, AxisType[] axes) {
        Img img = factory.create(dims);
        ImgPlus imgPlus = new ImgPlus(img, name, axes, null);
        return this.create(imgPlus);
    }

    @Override
    public <T extends Type<T>> Dataset create(ImgPlus<T> imgPlus) {
        Type type = (Type)imgPlus.firstElement();
        if (type instanceof ARGBType) {
            return this.createARGBType(imgPlus);
        }
        if (type instanceof RealType) {
            return this.createRealType(imgPlus);
        }
        throw new IllegalArgumentException("Only RealType and ARGBType are supported. Given pixel type: " + type.getClass().getName());
    }

    private <T extends RealType<T>> Dataset createRealType(ImgPlus<T> imgPlus) {
        return new DefaultDataset(this.getContext(), imgPlus);
    }

    private Dataset createARGBType(ImgPlus<ARGBType> imgPlus) {
        ImgPlus<UnsignedByteType> multiChannel = this.argbToMultiChannel(imgPlus);
        Dataset dataset = this.createRealType(multiChannel);
        dataset.setRGBMerged(true);
        return dataset;
    }

    @Override
    public <T extends Type<T>> Dataset create(RandomAccessibleInterval<T> rai) {
        return this.create(ImgPlus.wrapRAI(rai));
    }

    private ImgPlus<UnsignedByteType> argbToMultiChannel(ImgPlus<ARGBType> imgPlus) {
        Img<ARGBType> rai = imgPlus.getImg();
        WriteConvertedRandomAccessibleInterval red = Converters.argbChannel(rai, (int)1);
        WriteConvertedRandomAccessibleInterval green = Converters.argbChannel(rai, (int)2);
        WriteConvertedRandomAccessibleInterval blue = Converters.argbChannel(rai, (int)3);
        Img channels = ImgPlus.wrapToImg(Views.stack((RandomAccessibleInterval[])new RandomAccessibleInterval[]{red, green, blue}));
        int n = imgPlus.numDimensions();
        CalibratedAxis[] axes = new CalibratedAxis[n + 1];
        for (int d = 0; d < n; ++d) {
            axes[d] = (CalibratedAxis)imgPlus.axis(d);
        }
        axes[n] = new IdentityAxis(Axes.CHANNEL);
        return new ImgPlus<UnsignedByteType>(channels, imgPlus.getName(), axes);
    }

    public void initialize() {
        this.scriptService.addAlias(Dataset.class);
    }

    @Override
    @Deprecated
    public boolean canOpen(String source) {
        throw new UnsupportedOperationException("Use io.scif.services.DatasetIOService instead.");
    }

    @Override
    @Deprecated
    public boolean canSave(String destination) {
        throw new UnsupportedOperationException("Use io.scif.services.DatasetIOService instead.");
    }

    @Override
    @Deprecated
    public Dataset open(String source) throws IOException {
        throw new UnsupportedOperationException("Use io.scif.services.DatasetIOService instead.");
    }

    @Override
    @Deprecated
    public Dataset open(String source, Object config) throws IOException {
        throw new UnsupportedOperationException("Use io.scif.services.DatasetIOService instead.");
    }

    @Override
    @Deprecated
    public void revert(Dataset dataset) throws IOException {
        throw new UnsupportedOperationException("Use io.scif.services.DatasetIOService instead.");
    }

    @Override
    @Deprecated
    public Object save(Dataset dataset, String destination) throws IOException {
        throw new UnsupportedOperationException("Use io.scif.services.DatasetIOService instead.");
    }

    @Override
    @Deprecated
    public Object save(Dataset dataset, String destination, Object config) throws IOException {
        throw new UnsupportedOperationException("Use io.scif.services.DatasetIOService instead.");
    }

    @Override
    @Deprecated
    public <T extends RealType<T>> Dataset create(ImgFactory<T> factory, T type, long[] dims, String name, AxisType[] axes) {
        Img img = factory.create(dims, type);
        ImgPlus imgPlus = new ImgPlus(img, name, axes, null);
        return this.create(imgPlus);
    }

    private void invalidParams(int bitsPerPixel, boolean signed, boolean floating) {
        throw new IllegalArgumentException("Invalid parameters: bitsPerPixel=" + bitsPerPixel + ", signed=" + signed + ", floating=" + floating);
    }
}

