/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display.process;

import java.util.LinkedHashMap;
import java.util.function.Supplier;
import net.imagej.Dataset;
import net.imagej.display.DataView;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import org.scijava.convert.ConvertService;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.module.process.AbstractSingleInputPreprocessor;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=PreprocessorPlugin.class, priority=10000.0)
public class ActiveImagePreprocessor
extends AbstractSingleInputPreprocessor {
    @Parameter(required=false)
    private ImageDisplayService imageDisplayService;
    @Parameter(required=false)
    private ModuleService moduleService;
    @Parameter(required=false)
    private ConvertService convertService;

    public void process(Module m) {
        if (this.imageDisplayService == null || this.moduleService == null) {
            return;
        }
        ImageDisplay imageDisplay = this.imageDisplayService.getActiveImageDisplay();
        if (imageDisplay == null) {
            return;
        }
        LinkedHashMap<Class, Supplier<Object>> types = new LinkedHashMap<Class, Supplier<Object>>();
        types.put(ImageDisplay.class, () -> imageDisplay);
        types.put(DatasetView.class, () -> this.imageDisplayService.getActiveDatasetView(imageDisplay));
        types.put(DataView.class, () -> imageDisplay.getActiveView());
        types.put(Dataset.class, () -> this.imageDisplayService.getActiveDataset(imageDisplay));
        types.keySet().forEach(type -> this.fill(m, this.getSingleInput(m, (Class)type), (Supplier)types.get(type)));
        types.keySet().forEach(type -> this.fill(m, this.getConvertibleSingleInput(m, (Class<?>)type), (Supplier)types.get(type)));
    }

    private String getConvertibleSingleInput(Module m, Class<?> type) {
        if (this.moduleService == null || this.convertService == null) {
            return null;
        }
        ModuleItem item = this.moduleService.getSingleInput(m, this.convertService.getCompatibleOutputClasses(type));
        if (item == null || !item.isAutoFill()) {
            return null;
        }
        return item.getName();
    }

    private void fill(Module module, String name, Supplier<?> valueSupplier) {
        if (name == null) {
            return;
        }
        Object value = valueSupplier.get();
        if (value == null) {
            return;
        }
        Class type = module.getInfo().getInput(name).getType();
        if (!type.isInstance(value)) {
            value = this.convertService.convert(value, type);
        }
        if (value == null) {
            return;
        }
        module.setInput(name, value);
        module.resolveInput(name);
    }
}

