/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.parse;

import java.util.ArrayList;
import java.util.Map;
import net.imglib2.ops.operation.real.unary.RealAbs;
import net.imglib2.ops.operation.real.unary.RealArccos;
import net.imglib2.ops.operation.real.unary.RealArccosh;
import net.imglib2.ops.operation.real.unary.RealArccot;
import net.imglib2.ops.operation.real.unary.RealArccoth;
import net.imglib2.ops.operation.real.unary.RealArccsc;
import net.imglib2.ops.operation.real.unary.RealArccsch;
import net.imglib2.ops.operation.real.unary.RealArcsec;
import net.imglib2.ops.operation.real.unary.RealArcsech;
import net.imglib2.ops.operation.real.unary.RealArcsin;
import net.imglib2.ops.operation.real.unary.RealArcsinh;
import net.imglib2.ops.operation.real.unary.RealArctan;
import net.imglib2.ops.operation.real.unary.RealArctanh;
import net.imglib2.ops.operation.real.unary.RealCeil;
import net.imglib2.ops.operation.real.unary.RealCos;
import net.imglib2.ops.operation.real.unary.RealCosh;
import net.imglib2.ops.operation.real.unary.RealCot;
import net.imglib2.ops.operation.real.unary.RealCoth;
import net.imglib2.ops.operation.real.unary.RealCsc;
import net.imglib2.ops.operation.real.unary.RealCsch;
import net.imglib2.ops.operation.real.unary.RealCubeRoot;
import net.imglib2.ops.operation.real.unary.RealExp;
import net.imglib2.ops.operation.real.unary.RealExpMinusOne;
import net.imglib2.ops.operation.real.unary.RealFloor;
import net.imglib2.ops.operation.real.unary.RealGaussianRandom;
import net.imglib2.ops.operation.real.unary.RealLog;
import net.imglib2.ops.operation.real.unary.RealLog10;
import net.imglib2.ops.operation.real.unary.RealLog2;
import net.imglib2.ops.operation.real.unary.RealLogOnePlusX;
import net.imglib2.ops.operation.real.unary.RealNearestInt;
import net.imglib2.ops.operation.real.unary.RealRound;
import net.imglib2.ops.operation.real.unary.RealSec;
import net.imglib2.ops.operation.real.unary.RealSech;
import net.imglib2.ops.operation.real.unary.RealSignum;
import net.imglib2.ops.operation.real.unary.RealSin;
import net.imglib2.ops.operation.real.unary.RealSinc;
import net.imglib2.ops.operation.real.unary.RealSincPi;
import net.imglib2.ops.operation.real.unary.RealSinh;
import net.imglib2.ops.operation.real.unary.RealSqr;
import net.imglib2.ops.operation.real.unary.RealSqrt;
import net.imglib2.ops.operation.real.unary.RealStep;
import net.imglib2.ops.operation.real.unary.RealTan;
import net.imglib2.ops.operation.real.unary.RealTanh;
import net.imglib2.ops.operation.real.unary.RealUlp;
import net.imglib2.ops.operation.real.unary.RealUniformRandom;
import net.imglib2.ops.parse.ParseStatus;
import net.imglib2.ops.parse.token.And;
import net.imglib2.ops.parse.token.AngleReference;
import net.imglib2.ops.parse.token.Assign;
import net.imglib2.ops.parse.token.CloseParen;
import net.imglib2.ops.parse.token.CloseRange;
import net.imglib2.ops.parse.token.Comma;
import net.imglib2.ops.parse.token.DimensionReference;
import net.imglib2.ops.parse.token.DistanceFromCenterReference;
import net.imglib2.ops.parse.token.Divide;
import net.imglib2.ops.parse.token.DotDot;
import net.imglib2.ops.parse.token.Equal;
import net.imglib2.ops.parse.token.Exponent;
import net.imglib2.ops.parse.token.FunctionCall;
import net.imglib2.ops.parse.token.Greater;
import net.imglib2.ops.parse.token.GreaterEqual;
import net.imglib2.ops.parse.token.ImgReference;
import net.imglib2.ops.parse.token.Int;
import net.imglib2.ops.parse.token.Less;
import net.imglib2.ops.parse.token.LessEqual;
import net.imglib2.ops.parse.token.Max;
import net.imglib2.ops.parse.token.Min;
import net.imglib2.ops.parse.token.Minus;
import net.imglib2.ops.parse.token.Mod;
import net.imglib2.ops.parse.token.Not;
import net.imglib2.ops.parse.token.NotEqual;
import net.imglib2.ops.parse.token.OpenParen;
import net.imglib2.ops.parse.token.OpenRange;
import net.imglib2.ops.parse.token.Or;
import net.imglib2.ops.parse.token.Plus;
import net.imglib2.ops.parse.token.Real;
import net.imglib2.ops.parse.token.Times;
import net.imglib2.ops.parse.token.Token;
import net.imglib2.ops.parse.token.TypeBoundReference;
import net.imglib2.ops.parse.token.Variable;
import net.imglib2.ops.parse.token.Xor;
import net.imglib2.type.numeric.real.DoubleType;

@Deprecated
public class Lexer {
    public ParseStatus tokenize(String spec, Map<String, Integer> varMap) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        char[] chars = spec.toCharArray();
        int i = 0;
        while (i < chars.length) {
            Character ch = Character.valueOf(chars[i]);
            if (Character.isLetter(ch.charValue())) {
                StringBuilder builder = new StringBuilder();
                while (i < chars.length && (Character.isLetter(chars[i]) || Character.isDigit(chars[i]))) {
                    builder.append(chars[i]);
                    ++i;
                }
                String name = builder.toString();
                Token token = this.reservedWordLookup(name, i);
                if (token != null) {
                    tokens.add(token);
                    continue;
                }
                tokens.add(new Variable(i, name, varMap));
                continue;
            }
            if (Character.isDigit(ch.charValue())) {
                int start = i;
                StringBuilder builder = new StringBuilder();
                boolean isReal = false;
                while (i < chars.length && Character.isDigit(chars[i])) {
                    char next2;
                    builder.append(chars[i]);
                    char next = ++i < chars.length ? chars[i] : (char)'\u0000';
                    char c = next2 = i < chars.length - 1 ? chars[i + 1] : (char)'\u0000';
                    if (next == '.' && next2 == '.') break;
                    if (next != '.') continue;
                    if (isReal) {
                        return this.lexicalError(spec, i, Character.valueOf(chars[i]));
                    }
                    isReal = true;
                    builder.append(".");
                    ++i;
                }
                String numStr = builder.toString();
                if (isReal) {
                    tokens.add(new Real(start, numStr));
                    continue;
                }
                tokens.add(new Int(start, numStr));
                continue;
            }
            if (ch.charValue() == '<') {
                if (++i < chars.length && chars[i] == '=') {
                    tokens.add(new LessEqual(++i - 2, "<="));
                    continue;
                }
                tokens.add(new Less(i - 1, "<"));
                continue;
            }
            if (ch.charValue() == '>') {
                if (++i < chars.length && chars[i] == '=') {
                    tokens.add(new GreaterEqual(++i - 2, ">="));
                    continue;
                }
                tokens.add(new Greater(i - 1, ">"));
                continue;
            }
            if (ch.charValue() == '!') {
                if (++i < chars.length && chars[i] == '=') {
                    tokens.add(new NotEqual(++i - 2, "!="));
                    continue;
                }
                tokens.add(new Not(i - 1, "!"));
                continue;
            }
            if (ch.charValue() == '=') {
                if (++i < chars.length && chars[i] == '=') {
                    tokens.add(new Equal(++i - 2, "=="));
                    continue;
                }
                tokens.add(new Assign(i - 1, "="));
                continue;
            }
            if (ch.charValue() == '.') {
                if (++i < chars.length && chars[i] == '.') {
                    tokens.add(new DotDot(++i - 2, ".."));
                    continue;
                }
                return this.lexicalError(spec, i - 1, ch);
            }
            if (ch.charValue() == '&') {
                if (++i < chars.length && chars[i] == '&') {
                    tokens.add(new And(++i - 2, "&&"));
                    continue;
                }
                return this.lexicalError(spec, i - 1, ch);
            }
            if (ch.charValue() == '|') {
                if (++i < chars.length && chars[i] == '|') {
                    tokens.add(new Or(++i - 2, "||"));
                    continue;
                }
                return this.lexicalError(spec, i - 1, ch);
            }
            if (ch.charValue() == '^') {
                if (++i < chars.length && chars[i] == '^') {
                    tokens.add(new Xor(++i - 2, "^^"));
                    continue;
                }
                tokens.add(new Exponent(i - 1, "^"));
                continue;
            }
            if (ch.charValue() == ',') {
                tokens.add(new Comma(++i - 1, ","));
                continue;
            }
            if (ch.charValue() == '[') {
                tokens.add(new OpenRange(++i - 1, "["));
                continue;
            }
            if (ch.charValue() == ']') {
                tokens.add(new CloseRange(++i - 1, "["));
                continue;
            }
            if (ch.charValue() == '+') {
                tokens.add(new Plus(++i - 1, "+"));
                continue;
            }
            if (ch.charValue() == '*') {
                if (++i < chars.length && chars[i] == '*') {
                    tokens.add(new Exponent(++i - 2, "**"));
                }
                tokens.add(new Times(i - 1, "*"));
                continue;
            }
            if (ch.charValue() == '/') {
                tokens.add(new Divide(++i - 1, "/"));
                continue;
            }
            if (ch.charValue() == '-') {
                tokens.add(new Minus(++i - 1, "-"));
                continue;
            }
            if (ch.charValue() == '%') {
                tokens.add(new Mod(++i - 1, "%"));
                continue;
            }
            if (ch.charValue() == '(') {
                tokens.add(new OpenParen(++i - 1, "("));
                continue;
            }
            if (ch.charValue() == ')') {
                tokens.add(new CloseParen(++i - 1, ")"));
                continue;
            }
            if (Character.isWhitespace(ch.charValue())) {
                ++i;
                continue;
            }
            return this.lexicalError(spec, i, ch);
        }
        ParseStatus status = new ParseStatus();
        status.tokens = tokens;
        return status;
    }

    private Token reservedWordLookup(String name, int pos) {
        if (name.equals("E")) {
            return new Real(pos, name, Math.E);
        }
        if (name.equals("PI")) {
            return new Real(pos, name, Math.PI);
        }
        if (name.equals("img")) {
            return new ImgReference(pos, name);
        }
        if (name.equals("dim")) {
            return new DimensionReference(pos, name);
        }
        if (name.equals("tmin")) {
            return new TypeBoundReference(pos, name, true);
        }
        if (name.equals("tmax")) {
            return new TypeBoundReference(pos, name, false);
        }
        if (name.equals("dctr")) {
            return new DistanceFromCenterReference(pos, name);
        }
        if (name.equals("angle")) {
            return new AngleReference(pos, name);
        }
        if (name.equals("min")) {
            return new Min(pos, name);
        }
        if (name.equals("max")) {
            return new Max(pos, name);
        }
        if (name.equals("and")) {
            return new And(pos, name);
        }
        if (name.equals("or")) {
            return new Or(pos, name);
        }
        if (name.equals("xor")) {
            return new Xor(pos, name);
        }
        if (name.equals("not")) {
            return new Not(pos, name);
        }
        RealAbs<DoubleType, DoubleType> op = null;
        if (name.equals("abs")) {
            op = new RealAbs();
        }
        if (name.equals("acos")) {
            op = new RealArccos();
        }
        if (name.equals("acosh")) {
            op = new RealArccosh();
        }
        if (name.equals("acot")) {
            op = new RealArccot();
        }
        if (name.equals("acoth")) {
            op = new RealArccoth();
        }
        if (name.equals("acsc")) {
            op = new RealArccsc();
        }
        if (name.equals("acsch")) {
            op = new RealArccsch();
        }
        if (name.equals("asec")) {
            op = new RealArcsec();
        }
        if (name.equals("asech")) {
            op = new RealArcsech();
        }
        if (name.equals("asin")) {
            op = new RealArcsin();
        }
        if (name.equals("asinh")) {
            op = new RealArcsinh();
        }
        if (name.equals("atan")) {
            op = new RealArctan();
        }
        if (name.equals("atanh")) {
            op = new RealArctanh();
        }
        if (name.equals("cbrt")) {
            op = new RealCubeRoot();
        }
        if (name.equals("ceil")) {
            op = new RealCeil();
        }
        if (name.equals("cos")) {
            op = new RealCos();
        }
        if (name.equals("cosh")) {
            op = new RealCosh();
        }
        if (name.equals("cot")) {
            op = new RealCot();
        }
        if (name.equals("coth")) {
            op = new RealCoth();
        }
        if (name.equals("csc")) {
            op = new RealCsc();
        }
        if (name.equals("csch")) {
            op = new RealCsch();
        }
        if (name.equals("exp")) {
            op = new RealExp();
        }
        if (name.equals("expm1")) {
            op = new RealExpMinusOne();
        }
        if (name.equals("floor")) {
            op = new RealFloor();
        }
        if (name.equals("gauss")) {
            op = new RealGaussianRandom();
        }
        if (name.equals("log")) {
            op = new RealLog();
        }
        if (name.equals("log1p")) {
            op = new RealLogOnePlusX();
        }
        if (name.equals("log10")) {
            op = new RealLog10();
        }
        if (name.equals("log2")) {
            op = new RealLog2();
        }
        if (name.equals("rand")) {
            op = new RealUniformRandom();
        }
        if (name.equals("rint")) {
            op = new RealNearestInt();
        }
        if (name.equals("round")) {
            op = new RealRound();
        }
        if (name.equals("sec")) {
            op = new RealSec();
        }
        if (name.equals("sech")) {
            op = new RealSech();
        }
        if (name.equals("signum")) {
            op = new RealSignum();
        }
        if (name.equals("sin")) {
            op = new RealSin();
        }
        if (name.equals("sinc")) {
            op = new RealSinc();
        }
        if (name.equals("sincpi")) {
            op = new RealSincPi();
        }
        if (name.equals("sinh")) {
            op = new RealSinh();
        }
        if (name.equals("sqr")) {
            op = new RealSqr();
        }
        if (name.equals("sqrt")) {
            op = new RealSqrt();
        }
        if (name.equals("step")) {
            op = new RealStep();
        }
        if (name.equals("tan")) {
            op = new RealTan();
        }
        if (name.equals("tanh")) {
            op = new RealTanh();
        }
        if (name.equals("ulp")) {
            op = new RealUlp();
        }
        if (op != null) {
            return new FunctionCall(pos, name, op);
        }
        return null;
    }

    private ParseStatus lexicalError(String input, int pos, Character ch) {
        ArrayList<Token> emptyTokenList = new ArrayList<Token>();
        String errorMessage = "Invalid char (" + ch + ") at position (" + pos + ") of input string (" + input + ")";
        ParseStatus status = new ParseStatus();
        status.tokens = emptyTokenList;
        status.columnNumber = pos;
        status.errMsg = errorMessage;
        return status;
    }
}

