/*
 * Decompiled with CFR 0.152.
 */
package imagej.maven;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyJarsMojo
extends AbstractMojo {
    private String imagejDirectoryProperty;
    private boolean deleteOtherVersions;
    private MavenProject project;
    private MavenSession session;
    protected List<String> remoteRepositories;
    protected ArtifactRepository localRepository;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder treeBuilder;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    private File imagejDirectory;
    private static final Pattern versionPattern = Pattern.compile("(.+?)(-\\d+(\\.\\d+|\\d{7})+[a-z]?\\d?(-[A-Za-z0-9.]+?|\\.GA)*?)?((-(swing|swt|sources|javadoc))?(\\.jar(-[a-z]*)?))");
    private static final int PREFIX_INDEX = 1;
    private static final int SUFFIX_INDEX = 5;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        if (this.imagejDirectoryProperty == null) {
            this.getLog().info((CharSequence)"No property name for the ImageJ.app/ directory location was specified; Skipping");
            return;
        }
        String path = System.getProperty(this.imagejDirectoryProperty);
        if (path == null) {
            path = this.project.getProperties().getProperty(this.imagejDirectoryProperty);
        }
        if (path == null) {
            if (!this.hasIJ1Dependency()) return;
            this.getLog().info((CharSequence)("Property '" + this.imagejDirectoryProperty + "' unset; Skipping copy-jars"));
            return;
        }
        String interpolated = this.interpolate(path);
        this.imagejDirectory = new File(interpolated);
        if (!this.imagejDirectory.isDirectory()) {
            this.getLog().warn((CharSequence)("'" + this.imagejDirectory + "'" + (interpolated.equals(path) ? "" : " (" + path + ")") + " is not an ImageJ.app/ directory; Skipping copy-jars"));
            return;
        }
        try {
            ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("compile");
            DependencyNode rootNode = this.treeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, (ArtifactFilter)artifactFilter, this.artifactCollector);
            CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
            rootNode.accept((DependencyNodeVisitor)visitor);
            for (DependencyNode dependencyNode : visitor.getNodes()) {
                Artifact artifact;
                String scope;
                if (dependencyNode.getState() != 0 || (scope = (artifact = dependencyNode.getArtifact()).getScope()) != null && !scope.equals("compile") && !scope.equals("runtime")) continue;
                try {
                    this.installArtifact(artifact, false);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Could not copy " + artifact + " to " + this.imagejDirectory, e);
                    return;
                }
            }
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Could not get the dependencies for " + this.project.getArtifactId(), (Exception)((Object)e));
        }
    }

    private boolean hasIJ1Dependency() {
        List dependencies = this.project.getDependencies();
        for (Dependency dependency : dependencies) {
            String artifactId = dependency.getArtifactId();
            if (!"ij".equals(artifactId) && !"imagej".equals(artifactId)) continue;
            return true;
        }
        return false;
    }

    private String interpolate(String original) throws MojoExecutionException {
        if (original == null || original.indexOf("${") < 0) {
            return original;
        }
        try {
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
            interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
            ArrayList<String> synonymPrefixes = new ArrayList<String>();
            synonymPrefixes.add("project.");
            synonymPrefixes.add("pom.");
            PrefixedValueSourceWrapper modelWrapper = new PrefixedValueSourceWrapper((ValueSource)new ObjectBasedValueSource((Object)this.project.getModel()), synonymPrefixes, true);
            interpolator.addValueSource((ValueSource)modelWrapper);
            PrefixedValueSourceWrapper pomPropertyWrapper = new PrefixedValueSourceWrapper((ValueSource)new PropertiesBasedValueSource(this.project.getModel().getProperties()), synonymPrefixes, true);
            interpolator.addValueSource((ValueSource)pomPropertyWrapper);
            interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(this.session.getExecutionProperties()));
            PrefixAwareRecursionInterceptor recursionInterceptor = new PrefixAwareRecursionInterceptor(synonymPrefixes, true);
            return interpolator.interpolate(original, (RecursionInterceptor)recursionInterceptor);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not interpolate '" + original + "'", e);
        }
    }

    private void installArtifact(Artifact artifact, boolean force) throws ArtifactResolutionException, ArtifactNotFoundException, IOException {
        this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        if (!"jar".equals(artifact.getType())) {
            return;
        }
        File source = artifact.getFile();
        File targetDirectory = new File(this.imagejDirectory, CopyJarsMojo.isIJ1Plugin(source) ? "plugins" : "jars");
        String fileName = "Fiji_Updater".equals(artifact.getArtifactId()) ? artifact.getArtifactId() + ".jar" : source.getName();
        File target = new File(targetDirectory, fileName);
        if (!force && target.exists() && target.lastModified() > source.lastModified()) {
            this.getLog().info((CharSequence)("Dependency " + fileName + " is already there; skipping"));
        } else {
            this.getLog().info((CharSequence)("Copying " + fileName + " to " + targetDirectory));
            FileUtils.copyFile((File)source, (File)target);
        }
        Collection<File> otherVersions = CopyJarsMojo.getEncroachingVersions(target);
        if (otherVersions != null && !otherVersions.isEmpty()) {
            for (File file : otherVersions) {
                if (!this.deleteOtherVersions) {
                    this.getLog().warn((CharSequence)("Possibly incompatible version exists: " + file.getName()));
                    continue;
                }
                if (file.delete()) {
                    this.getLog().info((CharSequence)("Deleted overridden " + file.getName()));
                    continue;
                }
                this.getLog().warn((CharSequence)("Could not delete overridden " + file.getName()));
            }
        }
    }

    private static boolean isIJ1Plugin(File file) {
        String name = file.getName();
        if (name.indexOf(95) < 0 || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return new File(file, "src/main/resources/plugins.config").exists();
        }
        if (name.endsWith(".jar")) {
            try {
                JarFile jar = new JarFile(file);
                for (JarEntry entry : Collections.list(jar.entries())) {
                    if (!entry.getName().equals("plugins.config")) continue;
                    jar.close();
                    return true;
                }
                jar.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static Collection<File> getEncroachingVersions(File file) {
        File directory;
        Matcher matcher = versionPattern.matcher(file.getName());
        if (!matcher.matches()) {
            return null;
        }
        final String prefix = matcher.group(1);
        final String suffix = matcher.group(5);
        File parent = file.getParentFile();
        File file2 = directory = parent != null ? parent : file.getAbsoluteFile().getParentFile();
        if (directory == null) {
            return null;
        }
        File[] candidates = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!name.startsWith(prefix)) {
                    return false;
                }
                Matcher matcher = versionPattern.matcher(name);
                return matcher.matches() && prefix.equals(matcher.group(1)) && suffix.equals(matcher.group(5));
            }
        });
        if (candidates == null || candidates.length == (file.exists() ? 1 : 0)) {
            return null;
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File candidate : candidates) {
            if (candidate.equals(file)) continue;
            result.add(candidate);
        }
        return result;
    }
}

