/*
 * Decompiled with CFR 0.152.
 */
package imagej.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class SetRootDirPropertyMojo
extends AbstractMojo {
    private String rootdirPropertyName;
    private MavenProject currentProject;
    private List<MavenProject> reactorProjects;

    public void execute() throws MojoExecutionException {
        MavenProject parent;
        if (this.currentProject.getProperties().getProperty(this.rootdirPropertyName) != null) {
            this.getLog().debug((CharSequence)"Using previously defined rootdir");
            return;
        }
        if (!SetRootDirPropertyMojo.isLocalProject(this.currentProject)) {
            return;
        }
        MavenProject project = this.currentProject;
        while ((parent = project.getParent()) != null && SetRootDirPropertyMojo.isLocalProject(parent)) {
            project = parent;
        }
        String rootdir = project.getBasedir().getAbsolutePath();
        this.getLog().info((CharSequence)("Setting rootdir: " + rootdir));
        for (MavenProject reactorProject : this.reactorProjects) {
            reactorProject.getProperties().setProperty(this.rootdirPropertyName, rootdir);
        }
    }

    private static boolean isLocalProject(MavenProject project) {
        File baseDir = project.getBasedir();
        return baseDir != null && baseDir.exists();
    }
}

