/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.upload;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import net.iharder.Base64;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, menuPath="Help>Upload Sample Image")
public class SampleImageUploader
implements Command {
    @Parameter
    private File sampleImage;
    @Parameter
    private StatusService status;
    @Parameter
    private LogService log;
    @Parameter(required=false)
    private UIService ui;
    private static String baseURL = "http://upload.imagej.net/";

    public static void run(File file, StatusService status, LogService log) {
        SampleImageUploader uploader = new SampleImageUploader();
        uploader.sampleImage = file;
        uploader.status = status;
        uploader.log = log;
        uploader.run();
    }

    public void run() {
        if (this.sampleImage.length() >= 0x1400000L) {
            if (this.ui == null) {
                this.log.error((Object)("File too large: " + this.sampleImage));
                return;
            }
            DialogPrompt.Result answer = this.ui.showDialog("The file is really large: " + this.sampleImage + ". Continue?", "Huge file!", DialogPrompt.MessageType.QUESTION_MESSAGE, DialogPrompt.OptionType.OK_CANCEL_OPTION);
            if (answer != DialogPrompt.Result.OK_OPTION) {
                return;
            }
        }
        try {
            this.uploadFile(this.sampleImage);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
    }

    private void uploadFile(File file) throws IOException, MalformedURLException {
        String path = file.toURI().toURL().getFile();
        path = path.substring(path.lastIndexOf(47, path.length() - 2) + 1);
        this.upload(baseURL + path, new BufferedInputStream(new FileInputStream(file)), file.length());
    }

    private void upload(String url, InputStream in, long totalLength) throws IOException, MalformedURLException {
        String line;
        int count2;
        if (this.status != null) {
            this.status.showStatus("Uploading " + url);
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        String authentication = "ij2-sample-upload:password";
        connection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])"ij2-sample-upload:password".getBytes()));
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        OutputStream out = connection.getOutputStream();
        byte[] buffer = new byte[65536];
        long count = 0L;
        while ((count2 = in.read(buffer)) >= 0) {
            out.write(buffer, 0, count2);
            count += (long)count2;
            if (totalLength <= 0L || this.status == null) continue;
            this.status.showProgress((int)count, (int)totalLength);
        }
        out.close();
        in.close();
        BufferedReader response = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = response.readLine()) != null) {
            System.err.println(line);
        }
        response.close();
        if (this.status != null) {
            this.status.clearStatus();
            this.status.showStatus("Upload complete!");
        }
    }
}

