/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign;

import net.imagej.Dataset;
import net.imagej.Position;
import net.imagej.overlay.Overlay;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.meta.Axes;
import net.imglib2.meta.ImgPlus;
import net.imglib2.ops.condition.Condition;
import net.imglib2.ops.condition.UVInsideRoiCondition;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.function.complex.ComplexImageFunction;
import net.imglib2.ops.function.general.GeneralUnaryFunction;
import net.imglib2.ops.img.ImageAssignment;
import net.imglib2.ops.input.InputIteratorFactory;
import net.imglib2.ops.input.PointInputIteratorFactory;
import net.imglib2.ops.operation.complex.unary.ComplexUnaryOperation;
import net.imglib2.type.numeric.ComplexType;

public class InplaceUnaryTransform<I extends ComplexType<I>, O extends ComplexType<O>> {
    private final ImageAssignment<I, O, long[]> assigner1;
    private final ImageAssignment<I, O, long[]> assigner2;
    private final ImageAssignment<I, O, long[]> assigner3;
    private final Dataset dataset;
    private long[] origin;
    private long[] span;
    private Condition<long[]> condition;

    public InplaceUnaryTransform(ComplexUnaryOperation<O, O> operation, O outType, Dataset dataset, Overlay overlay) {
        this.dataset = dataset;
        this.setRegion(dataset, overlay);
        ImgPlus img = dataset.getImgPlus();
        ComplexImageFunction f1 = new ComplexImageFunction((Img)img, (ComplexType)outType.createVariable());
        GeneralUnaryFunction function = new GeneralUnaryFunction((Function)f1, operation, (ComplexType)outType.createVariable());
        PointInputIteratorFactory factory = new PointInputIteratorFactory();
        this.assigner1 = new ImageAssignment((RandomAccessibleInterval)img, this.origin, this.span, (Function)function, this.condition, (InputIteratorFactory)factory);
        this.assigner2 = null;
        this.assigner3 = null;
    }

    public InplaceUnaryTransform(ComplexUnaryOperation<O, O> operation, O outType, Dataset dataset, Overlay overlay, Position planePos) {
        this.dataset = dataset;
        this.setRegion(dataset, overlay, planePos);
        ImgPlus img = dataset.getImgPlus();
        ComplexImageFunction f1 = new ComplexImageFunction((Img)img, (ComplexType)outType.createVariable());
        GeneralUnaryFunction function = new GeneralUnaryFunction((Function)f1, operation, (ComplexType)outType.createVariable());
        PointInputIteratorFactory factory = new PointInputIteratorFactory();
        boolean rgb = dataset.isRGBMerged();
        int chIndex = dataset.dimensionIndex(Axes.CHANNEL);
        if (rgb) {
            this.origin[chIndex] = 0L;
        }
        this.assigner1 = new ImageAssignment((RandomAccessibleInterval)img, this.origin, this.span, (Function)function, this.condition, (InputIteratorFactory)factory);
        if (rgb) {
            this.origin[chIndex] = 1L;
            this.assigner2 = new ImageAssignment((RandomAccessibleInterval)img, this.origin, this.span, (Function)function, this.condition, (InputIteratorFactory)factory);
            this.origin[chIndex] = 2L;
            this.assigner3 = new ImageAssignment((RandomAccessibleInterval)img, this.origin, this.span, (Function)function, this.condition, (InputIteratorFactory)factory);
        } else {
            this.assigner2 = null;
            this.assigner3 = null;
        }
    }

    public void run() {
        if (this.assigner1 != null) {
            this.assigner1.assign();
        }
        if (this.assigner2 != null) {
            this.assigner2.assign();
        }
        if (this.assigner3 != null) {
            this.assigner3.assign();
        }
        this.dataset.update();
    }

    public long[] getRegionOrigin() {
        return this.origin;
    }

    public long[] getRegionSpan() {
        return this.span;
    }

    private void setRegion(Dataset ds, Overlay overlay) {
        int xIndex = ds.dimensionIndex(Axes.X);
        int yIndex = ds.dimensionIndex(Axes.Y);
        if (xIndex < 0 || yIndex < 0) {
            throw new IllegalArgumentException("display does not have XY planes");
        }
        LongRect rect = this.findXYRegion(ds, overlay, xIndex, yIndex);
        this.origin = new long[ds.numDimensions()];
        this.span = new long[ds.numDimensions()];
        for (int i = 0; i < ds.numDimensions(); ++i) {
            if (i == xIndex) {
                this.origin[xIndex] = rect.x;
                this.span[xIndex] = rect.w;
                continue;
            }
            if (i == yIndex) {
                this.origin[yIndex] = rect.y;
                this.span[yIndex] = rect.h;
                continue;
            }
            this.origin[i] = 0L;
            this.span[i] = ds.dimension(i);
        }
        this.condition = null;
        if (overlay != null) {
            this.condition = new UVInsideRoiCondition(overlay.getRegionOfInterest());
        }
    }

    private void setRegion(Dataset ds, Overlay overlay, Position planePos) {
        int xIndex = ds.dimensionIndex(Axes.X);
        int yIndex = ds.dimensionIndex(Axes.Y);
        if (xIndex < 0 || yIndex < 0) {
            throw new IllegalArgumentException("display does not have XY planes");
        }
        LongRect rect = this.findXYRegion(ds, overlay, xIndex, yIndex);
        this.origin = new long[ds.numDimensions()];
        this.span = new long[ds.numDimensions()];
        int p = 0;
        for (int i = 0; i < ds.numDimensions(); ++i) {
            if (i == xIndex) {
                this.origin[xIndex] = rect.x;
                this.span[xIndex] = rect.w;
                continue;
            }
            if (i == yIndex) {
                this.origin[yIndex] = rect.y;
                this.span[yIndex] = rect.h;
                continue;
            }
            this.origin[i] = planePos.getLongPosition(p++);
            this.span[i] = 1L;
        }
        this.condition = null;
        if (overlay != null) {
            this.condition = new UVInsideRoiCondition(overlay.getRegionOfInterest());
        }
    }

    private LongRect findXYRegion(Dataset ds, Overlay overlay, int xIndex, int yIndex) {
        LongRect rect = new LongRect();
        if (overlay == null) {
            rect.x = 0L;
            rect.y = 0L;
            rect.w = ds.dimension(xIndex);
            rect.h = ds.dimension(yIndex);
        } else {
            rect.x = (long)overlay.realMin(0);
            rect.y = (long)overlay.realMin(1);
            rect.w = Math.round(overlay.realMax(0) - (double)rect.x);
            rect.h = Math.round(overlay.realMax(1) - (double)rect.y);
        }
        return rect;
    }

    private class LongRect {
        public long x;
        public long y;
        public long w;
        public long h;

        private LongRect() {
        }
    }
}

