/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.binary;

import java.util.Arrays;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.autoscale.AutoscaleService;
import net.imagej.autoscale.DataRange;
import net.imagej.display.ImageDisplayService;
import net.imagej.threshold.ThresholdMethod;
import net.imagej.threshold.ThresholdService;
import net.imglib2.Axis;
import net.imglib2.Dimensions;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.histogram.Real1dBinMapper;
import net.imglib2.img.Img;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.meta.ImgPlus;
import net.imglib2.meta.IntervalUtils;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetIterator;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, initializer="init", menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Binary", mnemonic=98), @Menu(label="Binarize...")}, headless=true, attrs={@Attr(name="no-legacy")})
public class Binarize<T extends RealType<T>>
extends ContextCommand {
    public static final String INSIDE = "Inside threshold";
    public static final String OUTSIDE = "Outside threshold";
    public static final String WHITE = "White";
    public static final String BLACK = "Black";
    public static final String DEFAULT_METHOD = "Default";
    @Parameter
    private Dataset inputData;
    @Parameter(persist=false, autoFill=false, required=false)
    private Dataset inputMask = null;
    @Parameter(type=ItemIO.OUTPUT)
    private Dataset outputMask = null;
    @Parameter(label="Threshold method")
    private ThresholdMethod method = null;
    @Parameter(label="Mask pixels", choices={"Inside threshold", "Outside threshold"})
    private String maskPixels = "Inside threshold";
    @Parameter(label="Mask color", choices={"White", "Black"})
    private String maskColor = "White";
    @Parameter(label="Fill mask foreground")
    private boolean fillFg = true;
    @Parameter(label="Fill mask background")
    private boolean fillBg = true;
    @Parameter(label="Threshold each plane")
    private boolean thresholdEachPlane = false;
    @Parameter(label="Change input")
    private boolean changeInput = false;
    @Parameter
    private ThresholdService threshSrv;
    @Parameter
    private ImageDisplayService imgDispSrv;
    @Parameter
    private DatasetService datasetSrv;
    @Parameter
    private AutoscaleService autoscaleSrv;

    public void setThresholdMethod(ThresholdMethod thresholdMethod) {
        this.method = thresholdMethod;
    }

    public ThresholdMethod thresholdMethod() {
        return this.method;
    }

    public void setMaskPixels(String insideOrOutside) {
        if (insideOrOutside.equals(INSIDE)) {
            this.maskPixels = INSIDE;
        } else if (insideOrOutside.equals(OUTSIDE)) {
            this.maskPixels = OUTSIDE;
        } else {
            throw new IllegalArgumentException("Unknown mask pixel specification: " + insideOrOutside);
        }
    }

    public String maskPixels() {
        return this.maskPixels;
    }

    public void setMaskColor(String blackOrWhite) {
        if (blackOrWhite.equals(BLACK)) {
            this.maskColor = BLACK;
        } else if (blackOrWhite.equals(WHITE)) {
            this.maskColor = WHITE;
        } else {
            throw new IllegalArgumentException("Unknown mask color specification: " + blackOrWhite);
        }
    }

    public String maskColor() {
        return this.maskColor;
    }

    public void setThresholdEachPlane(boolean val) {
        this.thresholdEachPlane = val;
    }

    public boolean thresholdEachPlane() {
        return this.thresholdEachPlane;
    }

    public void setFillMaskForeground(boolean val) {
        this.fillFg = val;
    }

    public boolean fillMaskForeground() {
        return this.fillFg;
    }

    public void setFillMaskBackground(boolean val) {
        this.fillBg = val;
    }

    public boolean fillMaskBackground() {
        return this.fillBg;
    }

    public void setInputData(Dataset dataset) {
        this.inputData = dataset;
    }

    public Dataset inputData() {
        return this.inputData;
    }

    public void setInputMask(Dataset dataset) {
        this.inputMask = dataset;
    }

    public Dataset inputMask() {
        return this.inputMask;
    }

    public Dataset outputMask() {
        return this.outputMask;
    }

    public void setChangeInput(boolean val) {
        this.changeInput = val;
    }

    public boolean changeInput() {
        return this.changeInput;
    }

    public void setDefaultThresholdMethod() {
        this.method = this.threshSrv.getThresholdMethod(DEFAULT_METHOD);
    }

    public void run() {
        long[] dims = IntervalUtils.getDims((Dimensions)this.inputData);
        String err = this.checkInputMask(this.inputMask, dims);
        if (err != null) {
            this.cancel(err);
            return;
        }
        CalibratedAxis[] axes = new CalibratedAxis[dims.length];
        this.inputData.axes((Axis[])axes);
        AxisType[] types = new AxisType[dims.length];
        for (int i = 0; i < dims.length; ++i) {
            types[i] = axes[i].type();
        }
        Dataset mask = this.inputMask != null ? this.inputMask : this.datasetSrv.create((RealType)new BitType(), dims, "Mask", types, this.isVirtual(this.inputData));
        mask.setAxes(axes);
        RandomAccess maskAccessor = mask.getImgPlus().randomAccess();
        RandomAccess dataAccessor = this.inputData.getImgPlus().randomAccess();
        DataRange minMax = this.calcDataRange(this.inputData);
        Histogram1d<T> histogram = null;
        boolean testLess = this.maskPixels.equals(INSIDE);
        DoubleType val = new DoubleType();
        if (this.thresholdEachPlane && this.planeCount(this.inputData) > 1L) {
            long[] planeSpace = this.planeSpace(this.inputData);
            for (long[] planePos : new HyperVolumePointSet(planeSpace)) {
                histogram = this.buildHistogram(this.inputData, planePos, minMax, histogram);
                double cutoffVal = this.cutoff(histogram, this.method, testLess, val);
                PointSet planeData = this.planeData(this.inputData, planePos);
                PointSetIterator iter = planeData.iterator();
                while (iter.hasNext()) {
                    this.updateMask((long[])iter.next(), testLess, cutoffVal, dataAccessor, (RandomAccess<BitType>)maskAccessor);
                }
            }
        } else {
            histogram = this.buildHistogram(this.inputData, null, minMax, null);
            double cutoffVal = this.cutoff(histogram, this.method, testLess, val);
            PointSet fullData = this.fullData(dims);
            PointSetIterator iter = fullData.iterator();
            while (iter.hasNext()) {
                this.updateMask((long[])iter.next(), testLess, cutoffVal, dataAccessor, (RandomAccess<BitType>)maskAccessor);
            }
        }
        this.assignColorTables(mask);
        if (this.changeInput) {
            this.inputData.setImgPlus(mask.getImgPlus());
        } else {
            this.outputMask = mask;
        }
    }

    private void init() {
        this.setDefaultThresholdMethod();
    }

    private boolean isVirtual(Dataset ds) {
        Img img = ds.getImgPlus().getImg();
        return AbstractCellImg.class.isAssignableFrom(img.getClass());
    }

    private DataRange calcDataRange(Dataset ds) {
        return this.autoscaleSrv.getDefaultIntervalRange((IterableInterval)ds.getImgPlus());
    }

    private long planeCount(Dataset ds) {
        long count = 1L;
        for (int d = 0; d < ds.numDimensions(); ++d) {
            AxisType type = ((CalibratedAxis)ds.axis(d)).type();
            if (type == Axes.X || type == Axes.Y) continue;
            count *= ds.dimension(d);
        }
        return count;
    }

    long[] planeSpace(Dataset ds) {
        long[] planeSpace = new long[ds.numDimensions() - 2];
        int i = 0;
        for (int d = 0; d < ds.numDimensions(); ++d) {
            AxisType type = ((CalibratedAxis)ds.axis(d)).type();
            if (type == Axes.X || type == Axes.Y) continue;
            planeSpace[i++] = ds.dimension(d);
        }
        return planeSpace;
    }

    private Histogram1d<T> buildHistogram(Dataset ds, long[] planePos, DataRange minMax, Histogram1d<T> existingHist) {
        Histogram1d<T> histogram;
        long[] min = new long[ds.numDimensions()];
        long[] max = (long[])min.clone();
        int xIndex = ds.dimensionIndex(Axes.X);
        int yIndex = ds.dimensionIndex(Axes.Y);
        int i = 0;
        for (int d = 0; d < ds.numDimensions(); ++d) {
            if (planePos == null || d == xIndex || d == yIndex) {
                min[d] = 0L;
                max[d] = ds.dimension(d) - 1L;
                continue;
            }
            min[d] = planePos[i];
            max[d] = planePos[i];
            ++i;
        }
        ImgPlus img = ds.getImgPlus();
        IntervalView view = Views.interval((RandomAccessible)img, (long[])min, (long[])max);
        IterableInterval data = Views.iterable((RandomAccessibleInterval)view);
        if (existingHist == null) {
            histogram = this.allocateHistogram(ds.isInteger(), minMax);
        } else {
            existingHist.resetCounters();
            histogram = existingHist;
        }
        histogram.countData((Iterable)data);
        return histogram;
    }

    private Histogram1d<T> allocateHistogram(boolean dataIsIntegral, DataRange dataRange) {
        double range = dataRange.getExtent();
        if (dataIsIntegral) {
            range += 1.0;
        }
        Real1dBinMapper binMapper = null;
        int maxBinCount = 16384;
        for (int binCount = 256; binCount <= 16384; binCount *= 2) {
            if (!(range <= (double)binCount)) continue;
            binMapper = new Real1dBinMapper(dataRange.getMin(), dataRange.getMax(), (long)binCount, false);
            break;
        }
        if (binMapper == null) {
            binMapper = new Real1dBinMapper(dataRange.getMin(), dataRange.getMax(), 16384L, false);
        }
        return new Histogram1d(binMapper);
    }

    private double cutoff(Histogram1d<T> hist, ThresholdMethod thresholdMethod, boolean testLess, DoubleType val) {
        long threshIndex = thresholdMethod.getThreshold(hist);
        if (testLess) {
            hist.getUpperBound(threshIndex, (Object)val);
        } else {
            hist.getLowerBound(threshIndex, (Object)val);
        }
        return val.getRealDouble();
    }

    private void updateMask(long[] pos, boolean testLess, double cutoffVal, RandomAccess<? extends RealType<?>> dataAccessor, RandomAccess<BitType> maskAccessor) {
        boolean partOfMask;
        dataAccessor.setPosition(pos);
        if (testLess) {
            partOfMask = ((RealType)dataAccessor.get()).getRealDouble() <= cutoffVal;
        } else {
            boolean bl = partOfMask = ((RealType)dataAccessor.get()).getRealDouble() >= cutoffVal;
        }
        if (partOfMask) {
            if (this.fillFg) {
                maskAccessor.setPosition(pos);
                ((BitType)maskAccessor.get()).set(true);
            }
        } else if (this.fillBg) {
            maskAccessor.setPosition(pos);
            ((BitType)maskAccessor.get()).set(false);
        }
    }

    private PointSet planeData(Dataset ds, long[] planePos) {
        long[] pt1 = new long[ds.numDimensions()];
        long[] pt2 = new long[ds.numDimensions()];
        int i = 0;
        for (int d = 0; d < ds.numDimensions(); ++d) {
            AxisType type = ((CalibratedAxis)ds.axis(d)).type();
            if (type == Axes.X || type == Axes.Y) {
                pt1[d] = 0L;
                pt2[d] = ds.dimension(d) - 1L;
                continue;
            }
            pt1[d] = planePos[i];
            pt2[d] = planePos[i];
            ++i;
        }
        return new HyperVolumePointSet(pt1, pt2);
    }

    private PointSet fullData(long[] dims) {
        return new HyperVolumePointSet(dims);
    }

    private void assignColorTables(Dataset ds) {
        ColorTable8 table = this.maskColor.equals(WHITE) ? this.white() : this.black();
        long planeCount = this.planeCount(ds);
        if (planeCount > Integer.MAX_VALUE) {
            planeCount = Integer.MAX_VALUE;
        }
        ds.initializeColorTables((int)planeCount);
        int i = 0;
        while ((long)i < planeCount) {
            ds.setColorTable((ColorTable)table, i);
            ++i;
        }
    }

    private ColorTable8 white() {
        return this.makeTable(0, 255);
    }

    private ColorTable8 black() {
        return this.makeTable(255, 0);
    }

    private ColorTable8 makeTable(int first, int rest) {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        byte n = (byte)rest;
        Arrays.fill(r, n);
        Arrays.fill(g, n);
        Arrays.fill(b, n);
        r[0] = n = (byte)first;
        g[0] = n;
        b[0] = n;
        return new ColorTable8((byte[][])new byte[][]{r, g, b});
    }

    private String checkInputMask(Dataset mask, long[] dims) {
        if (mask == null) {
            return null;
        }
        if (!(mask.getImgPlus().firstElement() instanceof BitType)) {
            return "Mask is not a binary image";
        }
        for (int d = 0; d < dims.length; ++d) {
            long dim = dims[d];
            if (mask.dimension(d) == dim) continue;
            return "Mask shape not same as input data";
        }
        return null;
    }
}

