/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.display;

import net.imagej.Data;
import net.imagej.display.DataView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayView;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.RectangleOverlay;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.roi.RegionOfInterest;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Edit", weight=1.0, mnemonic=101), @Menu(label="Selection", mnemonic=115), @Menu(label="Select View", mnemonic=118, weight=0.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class SelectView
extends ContextCommand {
    @Parameter
    private Context context;
    @Parameter
    private ImageDisplayService imgDispService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;

    public void run() {
        for (DataView view : this.display) {
            if (!(view instanceof OverlayView)) continue;
            view.setSelected(false);
        }
        for (DataView view : this.display) {
            if (!(view instanceof OverlayView)) continue;
            OverlayView overlayView = (OverlayView)view;
            if (!this.viewIsInCurrentDisplayedPlane(this.display, view) || !this.viewFillsDisplay(overlayView, this.display)) continue;
            view.setSelected(true);
            return;
        }
        DataView dataView = this.makeOverlayView(this.display);
        this.display.add((Object)dataView);
        dataView.setSelected(true);
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }

    private boolean viewIsInCurrentDisplayedPlane(ImageDisplay disp, DataView view) {
        for (int d = 0; d < disp.numDimensions(); ++d) {
            AxisType axisType = ((CalibratedAxis)disp.axis(d)).type();
            if (axisType.isXY() || disp.getLongPosition(axisType) == view.getLongPosition(axisType)) continue;
            return false;
        }
        return true;
    }

    private boolean viewFillsDisplay(OverlayView view, ImageDisplay disp) {
        Overlay o = view.getData();
        if (!(o instanceof RectangleOverlay)) {
            return false;
        }
        RegionOfInterest region = o.getRegionOfInterest();
        if (region.realMin(0) > 0.0) {
            return false;
        }
        if (region.realMin(1) > 0.0) {
            return false;
        }
        if (region.realMax(0) < (double)disp.dimension(0)) {
            return false;
        }
        return !(region.realMax(1) < (double)disp.dimension(1));
    }

    private DataView makeOverlayView(ImageDisplay disp) {
        Overlay newOverlay = this.makeOverlay(disp);
        DataView dataView = this.imgDispService.createDataView((Data)newOverlay);
        for (int i = 0; i < disp.numDimensions(); ++i) {
            AxisType axis = ((CalibratedAxis)disp.axis(i)).type();
            if (axis.isXY() || dataView.getData().dimensionIndex(axis) >= 0) continue;
            dataView.setPosition(disp.getLongPosition(axis), axis);
        }
        return dataView;
    }

    private Overlay makeOverlay(ImageDisplay disp) {
        RectangleOverlay rect = new RectangleOverlay(this.context);
        rect.setOrigin(0.0, 0);
        rect.setOrigin(0.0, 1);
        rect.setExtent((double)disp.dimension(0), 0);
        rect.setExtent((double)disp.dimension(1), 1);
        return rect;
    }
}

