/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.display.interactive;

import net.imagej.Dataset;
import net.imagej.autoscale.AutoscaleService;
import net.imagej.autoscale.DataRange;
import net.imagej.command.InteractiveImageCommand;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.event.AxisPositionEvent;
import net.imagej.overlay.ThresholdOverlay;
import net.imagej.threshold.ThresholdMethod;
import net.imagej.threshold.ThresholdService;
import net.imagej.widget.HistogramBundle;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.histogram.Real1dBinMapper;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.meta.ImgPlus;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.event.EventHandler;
import org.scijava.module.Module;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;
import org.scijava.util.Colors;
import org.scijava.widget.Button;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Adjust"), @Menu(label="Threshold...", accelerator="shift ^T")}, initializer="initValues", attrs={@Attr(name="no-legacy")})
public class Threshold<T extends RealType<T>>
extends InteractiveImageCommand {
    private static final String RED = "Red";
    private static final String BLACK_WHITE = "Black/White";
    private static final String OVER_UNDER = "Over/Under";
    @Parameter(label="Histogram")
    private HistogramBundle histBundle;
    @Parameter(label="Display Type", choices={"Red", "Black/White", "Over/Under"}, callback="displayTypeChanged", persist=false)
    private String displayType = "Red";
    @Parameter(label="Method", callback="autoThreshold", persist=false)
    private ThresholdMethod method;
    @Parameter(label="Auto", callback="autoThreshold")
    private Button auto;
    @Parameter(label="Apply", callback="changePixels")
    private Button apply;
    @Parameter(label="Delete", callback="deleteThreshold")
    private Button delete;
    @Parameter(label="Dark Background", callback="backgroundChange", persist=false)
    private boolean darkBackground;
    @Parameter(label="Stack Histogram", callback="stackHistogram", persist=false)
    private boolean stackHistogram = true;
    @Parameter(label="Nan Background", persist=false)
    private boolean nanBackground;
    @Parameter(label="Minimum", callback="rangeChanged", persist=false, style="scroll bar")
    private double minimum;
    @Parameter(label="Maximum", callback="rangeChanged", persist=false, style="scroll bar")
    private double maximum;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    @Parameter
    private ThresholdService threshSrv;
    @Parameter
    private ImageDisplayService imgDispSrv;
    @Parameter
    private AutoscaleService autoscaleService;
    @Parameter
    private UIService uiSrv;
    private Histogram1d<T> fullHistogram;
    private Histogram1d<T> planeHistogram;
    private boolean invalidPlaneHist = true;
    private DataRange minMax;

    public Threshold() {
        super(new String[0]);
    }

    public void setImageDisplay(ImageDisplay disp) {
        this.display = disp;
    }

    public ImageDisplay getImageDisplay() {
        return this.display;
    }

    public void run() {
    }

    protected void initValues() {
        if (this.display == null) {
            return;
        }
        boolean alreadyHadOne = this.threshSrv.hasThreshold(this.display);
        ThresholdOverlay overlay = this.threshSrv.getThreshold(this.display);
        this.minMax = this.calcDataRange();
        this.fullHistogram = this.buildHistogram(true, null);
        this.planeHistogram = null;
        this.invalidPlaneHist = true;
        if (!alreadyHadOne) {
            double mn = 1.0 * this.minMax.getExtent() / 3.0;
            double mx = 2.0 * this.minMax.getExtent() / 3.0;
            overlay.setRange(mn, mx);
        }
        long binCount = this.fullHistogram.getBinCount();
        long minBin = this.calcBin(binCount, overlay.getRangeMin());
        long maxBin = this.calcBin(binCount, overlay.getRangeMax());
        this.histBundle = new HistogramBundle(this.fullHistogram);
        this.histBundle.setMinBin(minBin);
        this.histBundle.setMaxBin(maxBin);
        MutableModuleItem minItem = this.getInfo().getMutableInput("minimum", Double.class);
        minItem.setMinimumValue((Object)this.minMax.getMin());
        minItem.setMaximumValue((Object)this.minMax.getMax());
        minItem.setValue((Module)this, (Object)overlay.getRangeMin());
        MutableModuleItem maxItem = this.getInfo().getMutableInput("maximum", Double.class);
        maxItem.setMinimumValue((Object)this.minMax.getMin());
        maxItem.setMaximumValue((Object)this.minMax.getMax());
        maxItem.setValue((Module)this, (Object)overlay.getRangeMax());
        this.colorize(overlay);
    }

    protected void autoThreshold() {
        Histogram1d<T> hist = this.histogram();
        long cutoff = this.method.getThreshold(hist);
        if (cutoff < 0L) {
            DialogPrompt dialog = this.uiSrv.getDefaultUI().dialogPrompt(this.method.getMessage(), "Thresholding failure", DialogPrompt.MessageType.INFORMATION_MESSAGE, DialogPrompt.OptionType.DEFAULT_OPTION);
            dialog.prompt();
            return;
        }
        if (this.method.getMessage() != null) {
            this.log().warn((Object)this.method.getMessage());
        }
        double maxRange = hist.max();
        double bot = this.darkBackground ? (double)(cutoff + 1L) : 0.0;
        double top = this.darkBackground ? maxRange : (double)cutoff;
        this.minimum = this.minMax.getMin() + bot / maxRange * this.minMax.getExtent();
        this.maximum = this.minMax.getMin() + top / maxRange * this.minMax.getExtent();
        this.rangeChanged();
    }

    protected void backgroundChange() {
        this.autoThreshold();
    }

    protected void changePixels() {
        ThresholdOverlay thresh = this.getThreshold();
        Dataset ds = this.imgDispSrv.getActiveDataset(this.display);
        ImgPlus imgPlus = ds.getImgPlus();
        Cursor cursor = imgPlus.cursor();
        double typeMax = ((RealType)cursor.get()).getMaxValue();
        boolean setOffOnly = this.nanBackground && !ds.isInteger();
        double OFF = setOffOnly ? Double.NaN : 0.0;
        double ON = typeMax < 255.0 ? typeMax : 255.0;
        double min = thresh.getRangeMin();
        double max = thresh.getRangeMax();
        while (cursor.hasNext()) {
            boolean set;
            cursor.fwd();
            double value = ((RealType)cursor.get()).getRealDouble();
            if (value < min || value > max || Double.isNaN(value)) {
                value = OFF;
                set = true;
            } else {
                value = ON;
                boolean bl = set = !setOffOnly;
            }
            if (!set) continue;
            ((RealType)cursor.get()).setReal(value);
        }
        this.deleteThreshold();
        ds.update();
    }

    protected void deleteThreshold() {
        this.threshSrv.removeThreshold(this.display);
    }

    protected void displayTypeChanged() {
        ThresholdOverlay overlay = this.getThreshold();
        overlay.update();
    }

    protected void rangeChanged() {
        double min = (Double)this.getInput("minimum");
        double max = (Double)this.getInput("maximum");
        ThresholdOverlay overlay = this.getThreshold();
        overlay.setRange(min, max);
        this.display.update();
        this.updateBundle(min, max);
    }

    protected void stackHistogram() {
        this.autoThreshold();
    }

    @EventHandler
    protected void onEvent(AxisPositionEvent evt) {
        if (evt.getDisplay() != this.display) {
            return;
        }
        this.invalidPlaneHist = true;
    }

    private ThresholdOverlay getThreshold() {
        ThresholdOverlay overlay = this.threshSrv.getThreshold(this.display);
        this.colorize(overlay);
        return overlay;
    }

    private Histogram1d<T> histogram() {
        if (this.stackHistogram) {
            return this.fullHistogram;
        }
        if (this.invalidPlaneHist) {
            this.planeHistogram = this.buildHistogram(false, null);
            this.invalidPlaneHist = false;
        }
        return this.planeHistogram;
    }

    private void colorize(ThresholdOverlay overlay) {
        if (this.displayType.equals(BLACK_WHITE)) {
            overlay.setColorWithin(Colors.WHITE);
            overlay.setColorLess(Colors.BLACK);
            overlay.setColorGreater(Colors.BLACK);
        } else if (this.displayType.equals(OVER_UNDER)) {
            overlay.setColorWithin(null);
            overlay.setColorLess(Colors.BLUE);
            overlay.setColorGreater(Colors.GREEN);
        } else {
            overlay.setColorWithin(Colors.RED);
            overlay.setColorLess(null);
            overlay.setColorGreater(null);
        }
    }

    private DataRange calcDataRange() {
        Dataset ds = this.imgDispSrv.getActiveDataset(this.display);
        return this.autoscaleService.getDefaultIntervalRange((IterableInterval)ds.getImgPlus());
    }

    private Histogram1d<T> buildHistogram(boolean allData, Histogram1d<T> existingHist) {
        return this.buildHistogramFromViews(allData, existingHist);
    }

    private Histogram1d<T> buildHistogramFromViews(boolean allData, Histogram1d<T> existingHist) {
        Histogram1d<T> histogram;
        Dataset ds = this.imgDispSrv.getActiveDataset(this.display);
        long[] min = new long[ds.numDimensions()];
        long[] max = (long[])min.clone();
        max[0] = ds.dimension(0) - 1L;
        max[1] = ds.dimension(1) - 1L;
        for (int d = 2; d < ds.numDimensions(); ++d) {
            long pos;
            if (allData) {
                min[d] = 0L;
                max[d] = ds.dimension(d) - 1L;
                continue;
            }
            AxisType axisType = ((CalibratedAxis)ds.axis(d)).type();
            min[d] = pos = this.display.getLongPosition(axisType);
            max[d] = pos;
        }
        ImgPlus img = ds.getImgPlus();
        IntervalView view = Views.interval((RandomAccessible)img, (long[])min, (long[])max);
        IterableInterval data = Views.iterable((RandomAccessibleInterval)view);
        if (existingHist == null) {
            histogram = this.allocateHistogram(ds.isInteger(), this.minMax);
        } else {
            existingHist.resetCounters();
            histogram = existingHist;
        }
        histogram.countData((Iterable)data);
        return histogram;
    }

    private Histogram1d<T> allocateHistogram(boolean dataIsIntegral, DataRange dataRange) {
        double range = dataRange.getExtent();
        if (dataIsIntegral) {
            range += 1.0;
        }
        Real1dBinMapper binMapper = null;
        int MaxBinCount = 16384;
        for (int binCount = 256; binCount <= 16384; binCount *= 2) {
            if (!(range <= (double)binCount)) continue;
            binMapper = new Real1dBinMapper(dataRange.getMin(), dataRange.getMax(), (long)binCount, false);
            break;
        }
        if (binMapper == null) {
            binMapper = new Real1dBinMapper(dataRange.getMin(), dataRange.getMax(), 16384L, false);
        }
        return new Histogram1d(binMapper);
    }

    private long calcBin(long binCount, double val) {
        long value = (long)((double)binCount * (val - this.minMax.getMin()) / this.minMax.getExtent());
        if (value < 0L) {
            value = 0L;
        }
        if (value >= binCount) {
            value = binCount - 1L;
        }
        return value;
    }

    private void updateBundle(double min, double max) {
        long binCount = this.histogram().getBinCount();
        this.histBundle.setHistogram(0, this.histogram());
        this.histBundle.setMinBin(this.calcBin(binCount, min));
        this.histBundle.setMaxBin(this.calcBin(binCount, max));
    }
}

