/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.imglib;

import java.util.HashMap;
import java.util.Map;
import net.imagej.display.ImageDisplay;
import net.imagej.sampler.AxisSubrange;
import net.imagej.sampler.SamplerService;
import net.imagej.sampler.SamplingDefinition;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.SpaceUtils;
import net.imglib2.meta.TypedSpace;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.display.DisplayService;
import org.scijava.module.DefaultMutableModuleItem;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Duplicate", accelerator="shift ^D")}, headless=true, initializer="initializer", attrs={@Attr(name="no-legacy")})
public class DuplicateImage
extends DynamicCommand {
    @Parameter
    private SamplerService samplerService;
    @Parameter
    private DisplayService displayService;
    @Parameter
    private ImageDisplay inputDisplay;
    @Parameter(type=ItemIO.OUTPUT)
    private ImageDisplay outputDisplay;
    @Parameter(label="Title:", initializer="initName", persist=false)
    private String name = "";
    @Parameter(label="Constrain axes as below:")
    private boolean specialBehavior = false;
    private Map<AxisType, AxisSubrange> definitions;
    private AxisType[] theAxes;

    public void setDefaultBehavior(boolean value) {
        this.specialBehavior = !value;
    }

    public boolean isDefaultBehavior() {
        return !this.specialBehavior;
    }

    public void setInputDisplay(ImageDisplay disp) {
        this.inputDisplay = disp;
    }

    public ImageDisplay getInputDisplay() {
        return this.inputDisplay;
    }

    public ImageDisplay getOutputDisplay() {
        return this.outputDisplay;
    }

    public String setAxisRange(AxisType axis, String axisDefinition, boolean originIsOne) {
        this.specialBehavior = true;
        AxisSubrange subrange = new AxisSubrange(this.inputDisplay, axis, axisDefinition, originIsOne);
        if (subrange.getError() == null) {
            this.definitions.put(axis, subrange);
        }
        return subrange.getError();
    }

    public void run() {
        try {
            if (this.specialBehavior) {
                SamplingDefinition samples = this.determineSamples();
                this.outputDisplay = this.samplerService.createSampledImage(samples);
            } else {
                this.outputDisplay = this.samplerService.duplicateSelectedCompositePlane(this.inputDisplay);
            }
        }
        catch (Exception e) {
            this.cancel(e.getMessage());
        }
        if (this.name.length() != 0) {
            this.outputDisplay.setName(this.name);
        } else {
            this.outputDisplay.setName("Untitled");
        }
    }

    protected void initializer() {
        this.definitions = new HashMap<AxisType, AxisSubrange>();
        for (AxisType axis : this.theAxes = SpaceUtils.getAxisTypes((TypedSpace)this.inputDisplay)) {
            DefaultMutableModuleItem axisItem = new DefaultMutableModuleItem((Module)this, this.name(axis), String.class);
            axisItem.setPersisted(false);
            axisItem.setValue((Module)this, (Object)this.fullRangeString(this.inputDisplay, axis));
            this.addInput((ModuleItem)axisItem);
        }
    }

    protected void initName() {
        this.name = this.getUniqueName();
    }

    private String fullRangeString(ImageDisplay disp, AxisType axis) {
        int axisIndex = disp.dimensionIndex(axis);
        return "1-" + disp.dimension(axisIndex);
    }

    private SamplingDefinition determineSamples() {
        if (this.definitions.size() > 0) {
            SamplingDefinition def = SamplingDefinition.sampleAllPlanes((ImageDisplay)this.inputDisplay);
            for (AxisType axis : this.definitions.keySet()) {
                def.constrain(axis, this.definitions.get(axis));
            }
            return def;
        }
        return this.parsedDefinition();
    }

    private SamplingDefinition parsedDefinition() {
        SamplingDefinition sampleDef = SamplingDefinition.sampleAllPlanes((ImageDisplay)this.inputDisplay);
        for (AxisType axis : this.theAxes) {
            String definition = (String)this.getInput(this.name(axis));
            AxisSubrange subrange = new AxisSubrange(this.inputDisplay, axis, definition, true);
            sampleDef.constrain(axis, subrange);
        }
        return sampleDef;
    }

    private String name(AxisType axis) {
        return axis.getLabel() + " axis range";
    }

    private String getUniqueName() {
        String s;
        String origName = this.inputDisplay.getName();
        String extension = "";
        int extPos = origName.lastIndexOf(".");
        if (extPos >= 0) {
            extension = origName.substring(extPos);
            origName = origName.substring(0, extPos);
        }
        String base = origName;
        if (this.isDefaultEnding(origName)) {
            int dashPos = base.lastIndexOf("-");
            base = base.substring(0, dashPos);
        }
        int num = 1;
        do {
            s = base + "-" + num + extension;
            ++num;
        } while (!this.displayService.isUniqueName(s));
        return s;
    }

    private boolean isDefaultEnding(String s) {
        int dashPos = s.lastIndexOf("-");
        if (dashPos < 0) {
            return false;
        }
        String rest = s.substring(dashPos + 1);
        if (rest == null || rest.length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(rest);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

