/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.imglib;

import java.util.ArrayList;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.LanczosInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.meta.ImgPlus;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, initializer="init", headless=true, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Transform", mnemonic=116), @Menu(label="Translate...", mnemonic=116)}, attrs={@Attr(name="no-legacy")})
public class TranslateImage<T extends RealType<T>>
extends ContextCommand {
    private static final String LANCZOS = "Lanczos";
    private static final String LINEAR = "Linear";
    private static final String NEAREST_NEIGHBOR = "Nearest Neighbor";
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    @Parameter(label="Deltas", persist=false)
    private String deltasString;
    @Parameter(label="Interpolation", choices={"Linear", "Nearest Neighbor", "Lanczos"}, persist=false)
    private String method = "Linear";
    @Parameter(label="Use user units", persist=false)
    private boolean useUserUnits;
    @Parameter
    private DatasetService datasetService;
    private String err = null;
    private List<Double> deltas = new ArrayList<Double>();

    public void setDataset(Dataset ds) {
        this.dataset = ds;
        this.init();
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDelta(int d, double delta) {
        if (d < 0 || d >= this.deltas.size()) {
            throw new IllegalArgumentException("dimension " + d + " out of bounds (0," + (this.deltas.size() - 1) + ")");
        }
        this.deltas.set(d, delta);
        this.deltasString = this.deltasString();
    }

    public double getDelta(int d) {
        if (d < 0 || d >= this.deltas.size()) {
            throw new IllegalArgumentException("dimension " + d + " out of bounds (0," + (this.deltas.size() - 1) + ")");
        }
        return this.deltas.get(d);
    }

    public void setInterpolationMethod(String str) {
        if (str.equals(LINEAR)) {
            this.method = LINEAR;
        } else if (str.equals(NEAREST_NEIGHBOR)) {
            this.method = NEAREST_NEIGHBOR;
        } else if (str.equals(LANCZOS)) {
            this.method = LANCZOS;
        } else {
            throw new IllegalArgumentException("Unknown interpolation method: " + str);
        }
    }

    public String getInterpolationMethod() {
        return this.method;
    }

    public void setUseUserUnits(boolean val) {
        this.useUserUnits = val;
    }

    public boolean useUserUnits() {
        return this.useUserUnits;
    }

    public String getError() {
        return this.err;
    }

    public void run() {
        List<Double> delts = this.parseDeltas(this.dataset, this.deltasString);
        if (delts == null) {
            this.cancel(this.err);
            return;
        }
        if (this.useUserUnits) {
            this.toPixelUnits(this.dataset, delts);
        }
        this.resampleData(this.dataset, delts);
    }

    protected void init() {
        this.deltas.clear();
        for (int i = 0; i < this.dataset.numDimensions(); ++i) {
            this.deltas.add(0.0);
        }
        this.deltasString = this.deltasString();
    }

    private List<Double> parseDeltas(Dataset ds, String spec) {
        int i;
        if (spec == null) {
            this.err = "Deltas specification string is null.";
            return null;
        }
        String[] terms = spec.split(",");
        if (terms.length == 0) {
            this.err = "Deltas specification string is empty.";
            return null;
        }
        ArrayList<Double> delts = new ArrayList<Double>();
        for (i = 0; i < ds.numDimensions(); ++i) {
            delts.add(0.0);
        }
        for (i = 0; i < terms.length; ++i) {
            double delta;
            int axisIndex;
            String term = terms[i].trim();
            String[] parts = term.split("=");
            if (parts.length != 2) {
                this.err = "Err in deltas specification string: each delta must be two numbers separated by an '=' sign.";
                return null;
            }
            try {
                axisIndex = Integer.parseInt(parts[0].trim());
                delta = Double.parseDouble(parts[1].trim());
            }
            catch (NumberFormatException e) {
                this.err = "Err in deltas specification string: each delta must be two numbers separated by an '=' sign.";
                return null;
            }
            if (axisIndex < 0 || axisIndex >= ds.numDimensions()) {
                this.err = "An axis index is outside dimensionality of input dataset.";
                return null;
            }
            this.deltas.set(axisIndex, delta);
        }
        return this.deltas;
    }

    private void resampleData(Dataset ds, List<Double> delts) {
        ImgPlus dest = ds.getImgPlus();
        ImgPlus src = dest.copy();
        RealType zero = (RealType)((RealType)src.firstElement()).createVariable();
        zero.setZero();
        InterpolatorFactory<T, RandomAccessible<T>> ifac = this.getInterpolator();
        RealRandomAccess inter = ifac.create((Object)Views.extend((RandomAccessibleInterval)src, (OutOfBoundsFactory)new OutOfBoundsConstantValueFactory((Type)zero)));
        Cursor c2 = Views.iterable((RandomAccessibleInterval)dest).localizingCursor();
        double[] delta = new double[dest.numDimensions()];
        for (int i = 0; i < delta.length; ++i) {
            delta[i] = delts.get(i);
        }
        long[] d = new long[dest.numDimensions()];
        while (c2.hasNext()) {
            c2.fwd();
            c2.localize(d);
            for (int i = 0; i < d.length; ++i) {
                inter.setPosition((double)d[i] - delta[i], i);
            }
            ((RealType)c2.get()).set((Type)inter.get());
        }
        ds.update();
    }

    private String deltasString() {
        String str = "";
        for (int i = 0; i < this.deltas.size(); ++i) {
            if (i != 0) {
                str = str + ", ";
            }
            str = str + i + "=" + this.deltas.get(i);
        }
        return str;
    }

    private InterpolatorFactory<T, RandomAccessible<T>> getInterpolator() {
        if (this.method.equals(LINEAR)) {
            return new NLinearInterpolatorFactory();
        }
        if (this.method.equals(NEAREST_NEIGHBOR)) {
            return new NearestNeighborInterpolatorFactory();
        }
        if (this.method.equals(LANCZOS)) {
            return new LanczosInterpolatorFactory();
        }
        throw new IllegalArgumentException("unknown interpolation method: " + this.method);
    }

    private void toPixelUnits(Dataset ds, List<Double> delts) {
        for (int i = 0; i < delts.size(); ++i) {
            CalibratedAxis axis = (CalibratedAxis)ds.axis(i);
            double userUnit = delts.get(i);
            double pixelUnit = axis.rawValue(userUnit) - axis.rawValue(0.0);
            delts.set(i, pixelUnit);
        }
    }
}

