/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.io;

import java.io.File;
import java.io.IOException;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.display.Display;
import org.scijava.log.LogService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, menu={@Menu(label="File", weight=0.0, mnemonic=102), @Menu(label="Save As...", weight=21.0, accelerator="shift ^S")}, attrs={@Attr(name="no-legacy")})
public class SaveAsImage
extends ContextCommand {
    @Parameter
    private LogService log;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private UIService uiService;
    @Parameter(label="File to save", style="save", initializer="initOutputFile", persist=false)
    private File outputFile;
    @Parameter
    private Dataset dataset;
    @Parameter(type=ItemIO.BOTH)
    private Display<?> display;

    protected void initOutputFile() {
        if (this.dataset == null) {
            return;
        }
        this.outputFile = new File(this.dataset.getImgPlus().getSource());
    }

    public void run() {
        DialogPrompt.Result result;
        if (this.outputFile.exists() && (result = this.uiService.showDialog("\"" + this.outputFile.getName() + "\" already exists. Do you want to replace it?", "Save", DialogPrompt.MessageType.WARNING_MESSAGE, DialogPrompt.OptionType.YES_NO_OPTION)) != DialogPrompt.Result.YES_OPTION) {
            return;
        }
        try {
            this.datasetService.save(this.dataset, this.outputFile.getAbsolutePath());
        }
        catch (IOException exc) {
            this.log.error((Throwable)exc);
            this.uiService.showDialog(exc.getMessage(), "Error Saving Image", DialogPrompt.MessageType.ERROR_MESSAGE);
            return;
        }
        this.display.setName(this.dataset.getName());
    }
}

