/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.misc;

import java.io.IOException;
import java.net.URL;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.lut.LUTService;
import net.imglib2.RandomAccess;
import net.imglib2.display.ColorTable;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.display.DisplayService;
import org.scijava.log.LogService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, attrs={@Attr(name="no-legacy")})
public class ApplyLookupTable
implements Command {
    @Parameter
    private LogService logService;
    @Parameter
    private LUTService lutService;
    @Parameter
    private DisplayService displayService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private DatasetService datasetService;
    @Parameter(required=false)
    private ImageDisplay display;
    @Parameter(required=false)
    private DatasetView view;
    @Parameter
    private URL tableURL;
    @Parameter(type=ItemIO.OUTPUT)
    private ImageDisplay output;
    private static final int WIDTH = 256;
    private static final int HEIGHT = 32;

    public void run() {
        ColorTable colorTable;
        if (this.tableURL == null) {
            this.logService.warn((Object)"ApplyLookupTable: no URL string provided.");
            return;
        }
        try {
            colorTable = this.lutService.loadLUT(this.tableURL);
        }
        catch (IOException exc) {
            this.logService.error((Object)("ApplyLookupTable: error loading color table at URL: " + this.tableURL), (Throwable)exc);
            return;
        }
        if (colorTable == null) {
            this.logService.error((Object)("ApplyLookupTable: no color table at URL: " + this.tableURL));
            return;
        }
        if (this.display == null) {
            Dataset ds = this.makeData();
            this.display = (ImageDisplay)this.displayService.createDisplay((Object)ds);
        }
        if (this.view == null) {
            this.view = this.imageDisplayService.getActiveDatasetView(this.display);
        }
        int channel = (int)this.view.getLongPosition(Axes.CHANNEL);
        this.view.setColorTable(colorTable, channel);
        this.output = this.display;
    }

    private Dataset makeData() {
        String urlString;
        try {
            urlString = this.tableURL.toURI().getPath();
        }
        catch (Exception e) {
            urlString = this.tableURL.getPath();
        }
        String name = urlString.substring(urlString.lastIndexOf("/") + 1, urlString.length());
        long[] dims = new long[]{256L, 32L};
        AxisType[] axes = new AxisType[]{Axes.X, Axes.Y};
        int bitsPerPixel = 8;
        boolean signed = false;
        boolean floating = false;
        Dataset ds = this.datasetService.create(dims, name, axes, bitsPerPixel, signed, floating);
        this.ramp(ds);
        return ds;
    }

    private void ramp(Dataset ds) {
        RandomAccess accessor = ds.getImgPlus().randomAccess();
        for (int x = 0; x < 256; ++x) {
            accessor.setPosition(x, 0);
            for (int y = 0; y < 32; ++y) {
                accessor.setPosition(y, 1);
                ((RealType)accessor.get()).setReal((float)x);
            }
        }
    }
}

