/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.restructure;

import java.util.ArrayList;
import net.imagej.Dataset;
import net.imagej.plugins.commands.restructure.ColorTableRemapper;
import net.imagej.plugins.commands.restructure.RestructureUtils;
import net.imglib2.Dimensions;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.meta.ImgPlus;
import net.imglib2.meta.IntervalUtils;
import net.imglib2.meta.SpaceUtils;
import net.imglib2.meta.TypedSpace;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Data", mnemonic=100), @Menu(label="Delete Data...")}, headless=true, initializer="initAll", attrs={@Attr(name="no-legacy")})
public class DeleteData
extends DynamicCommand {
    private static final String AXIS_NAME = "axisName";
    private static final String POSITION = "position";
    private static final String QUANTITY = "quantity";
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    @Parameter(label="Axis to modify", persist=false, callback="parameterChanged")
    private String axisName;
    @Parameter(label="Deletion position", persist=false, callback="parameterChanged")
    private long position = 1L;
    @Parameter(label="Deletion quantity", persist=false, callback="parameterChanged")
    private long quantity = 1L;

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public String getAxisName() {
        return this.axisName;
    }

    public void setAxisName(String axisName) {
        this.axisName = axisName;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(long quantity) {
        this.quantity = quantity;
    }

    public void run() {
        AxisType axis = Axes.get((String)this.axisName);
        if (this.inputBad(axis)) {
            return;
        }
        AxisType[] axes = SpaceUtils.getAxisTypes((TypedSpace)this.dataset);
        long[] newDimensions = RestructureUtils.getDimensions(this.dataset, axis, -this.quantity);
        ImgPlus<? extends RealType<?>> dstImgPlus = RestructureUtils.createNewImgPlus(this.dataset, newDimensions, axes);
        int compositeChannelCount = this.compositeStatus(this.dataset.getCompositeChannelCount(), dstImgPlus, axis);
        this.fillNewImgPlus(this.dataset.getImgPlus(), dstImgPlus, axis);
        dstImgPlus.setCompositeChannelCount(compositeChannelCount);
        RestructureUtils.allocateColorTables(dstImgPlus);
        if (axis.isXY()) {
            RestructureUtils.copyColorTables(this.dataset.getImgPlus(), dstImgPlus);
        } else {
            int d = this.dataset.dimensionIndex(axis);
            ColorTableRemapper remapper = new ColorTableRemapper(new RemapAlgorithm(IntervalUtils.getDims((Dimensions)this.dataset), d));
            remapper.remapColorTables(this.dataset.getImgPlus(), dstImgPlus);
        }
        this.dataset.setImgPlus(dstImgPlus);
    }

    protected void initAll() {
        this.initAxisName();
        this.initPosition();
        this.initQuantity();
    }

    protected void parameterChanged() {
        this.setPositionRange();
        this.setQuantityRange();
        this.clampPosition();
        this.clampQuantity();
    }

    private boolean inputBad(AxisType axis) {
        if (axis == null) {
            this.cancel("Axis must not be null.");
            return true;
        }
        int axisIndex = this.dataset.dimensionIndex(axis);
        long axisSize = this.dataset.getImgPlus().dimension(axisIndex);
        if (axisIndex < 0) {
            this.cancel("Axis " + axis.getLabel() + " is not present in input dataset.");
            return true;
        }
        if (this.position < 1L || this.position > axisSize) {
            this.cancel("Start position is out of bounds.");
            return true;
        }
        if (this.quantity <= 0L) {
            this.cancel("Quantity to delete must be a positive number.");
            return true;
        }
        if (this.quantity >= axisSize) {
            this.cancel("Cannot delete all entries along axis " + axis.getLabel());
            return true;
        }
        return false;
    }

    private void fillNewImgPlus(ImgPlus<? extends RealType<?>> srcImgPlus, ImgPlus<? extends RealType<?>> dstImgPlus, AxisType modifiedAxis) {
        long numBeforeCut = this.position - 1L;
        long numInCut = this.quantity;
        int axisIndex = this.dataset.dimensionIndex(modifiedAxis);
        long axisSize = this.dataset.dimension(axisIndex);
        if (numBeforeCut + numInCut > axisSize) {
            numInCut = axisSize - numBeforeCut;
        }
        long numAfterCut = axisSize - (numBeforeCut + numInCut);
        RestructureUtils.copyData(srcImgPlus, dstImgPlus, modifiedAxis, 0L, 0L, numBeforeCut);
        RestructureUtils.copyData(srcImgPlus, dstImgPlus, modifiedAxis, numBeforeCut + numInCut, numBeforeCut, numAfterCut);
    }

    private int compositeStatus(int compositeCount, ImgPlus<?> output, AxisType axis) {
        int axisIndex;
        long numChannels;
        if (axis == Axes.CHANNEL && (numChannels = output.dimension(axisIndex = output.dimensionIndex(Axes.CHANNEL))) < (long)compositeCount) {
            return (int)numChannels;
        }
        return compositeCount;
    }

    private void initAxisName() {
        MutableModuleItem axisNameItem = this.getInfo().getMutableInput(AXIS_NAME, String.class);
        Dataset ds = this.getDataset();
        ArrayList<String> choices = new ArrayList<String>();
        for (int i = 0; i < ds.numDimensions(); ++i) {
            AxisType axisType = ((CalibratedAxis)ds.axis(i)).type();
            choices.add(axisType.getLabel());
        }
        axisNameItem.setChoices(choices);
    }

    private void initPosition() {
        long max = this.getDataset().getImgPlus().dimension(0);
        this.setItemRange(POSITION, 1L, max);
        this.setPosition(1L);
    }

    private void initQuantity() {
        long max = this.getDataset().getImgPlus().dimension(0);
        this.setItemRange(QUANTITY, 1L, max);
        this.setQuantity(1L);
    }

    private void setPositionRange() {
        long max = this.currDimLen();
        this.setItemRange(POSITION, 1L, max);
    }

    private void setQuantityRange() {
        long max = this.currDimLen() - this.getPosition() + 1L;
        this.setItemRange(QUANTITY, 1L, max);
    }

    private void clampPosition() {
        long max = this.currDimLen();
        long pos = this.getPosition();
        if (pos < 1L) {
            this.setPosition(1L);
        } else if (pos > max) {
            this.setPosition(max);
        }
    }

    private void clampQuantity() {
        long max = this.currDimLen() - this.getPosition() + 1L;
        long total = this.getQuantity();
        if (total < 1L) {
            this.setQuantity(1L);
        } else if (total > max) {
            this.setQuantity(max);
        }
    }

    private long currDimLen() {
        AxisType axis = Axes.get((String)this.getAxisName());
        int axisIndex = this.getDataset().dimensionIndex(axis);
        return this.getDataset().getImgPlus().dimension(axisIndex);
    }

    private void setItemRange(String fieldName, long min, long max) {
        MutableModuleItem item = this.getInfo().getMutableInput(fieldName, Long.class);
        item.setMinimumValue((Object)min);
    }

    private class RemapAlgorithm
    implements ColorTableRemapper.RemapAlgorithm {
        private final long[] origPlaneDims;
        private final long[] srcPlanePos;
        private final int axisIndex;

        public RemapAlgorithm(long[] origDims, int axisIndex) {
            this.origPlaneDims = new long[origDims.length - 2];
            for (int i = 0; i < this.origPlaneDims.length; ++i) {
                this.origPlaneDims[i] = origDims[i + 2];
            }
            this.srcPlanePos = new long[this.origPlaneDims.length];
            this.axisIndex = axisIndex;
        }

        @Override
        public boolean isValidSourcePlane(long i) {
            ColorTableRemapper.toND(this.origPlaneDims, i, this.srcPlanePos);
            if (this.srcPlanePos[this.axisIndex - 2] < DeleteData.this.position - 1L) {
                return true;
            }
            return this.srcPlanePos[this.axisIndex - 2] >= DeleteData.this.position - 1L + DeleteData.this.quantity;
        }

        @Override
        public void remapPlanePosition(long[] origPlaneDims, long[] origPlanePos, long[] newPlanePos) {
            for (int i = 0; i < origPlanePos.length; ++i) {
                if (i != this.axisIndex - 2) {
                    newPlanePos[i] = origPlanePos[i];
                    continue;
                }
                if (origPlanePos[i] < DeleteData.this.position - 1L) {
                    newPlanePos[i] = origPlanePos[i];
                    continue;
                }
                if (origPlanePos[i] >= DeleteData.this.position - 1L + DeleteData.this.quantity) {
                    newPlanePos[i] = origPlanePos[i] - DeleteData.this.quantity;
                    continue;
                }
                System.out.println("val = " + origPlanePos[i] + " pos-1 = " + (DeleteData.this.position - 1L) + " quantity = " + DeleteData.this.quantity);
                throw new IllegalArgumentException("position remap should not be happening here!");
            }
        }
    }
}

