/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.restructure;

import net.imagej.Dataset;
import net.imagej.Extents;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccess;
import net.imglib2.display.ColorTable;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.meta.ImgPlus;
import net.imglib2.meta.IntervalUtils;
import net.imglib2.meta.axis.DefaultLinearAxis;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSetIterator;
import net.imglib2.type.numeric.RealType;

public class RestructureUtils {
    private RestructureUtils() {
    }

    public static long[] getDimensions(Dataset ds, AxisType oneToModify, long delta) {
        int axisIndex;
        long[] dimensions = IntervalUtils.getDims((Dimensions)ds);
        int n = axisIndex = ds.dimensionIndex(oneToModify);
        dimensions[n] = dimensions[n] + delta;
        return dimensions;
    }

    public static ImgPlus<? extends RealType<?>> createNewImgPlus(Dataset ds, long[] dimensions, AxisType[] axisTypes) {
        return RestructureUtils.createNewImgPlus(ds.getImgPlus(), dimensions, axisTypes);
    }

    public static <T> ImgPlus<T> createNewImgPlus(ImgPlus<T> imgPlus, long[] dimensions, AxisType[] axisTypes) {
        ImgFactory factory = imgPlus.factory();
        Img newImg = factory.create(dimensions, imgPlus.firstElement());
        String name = imgPlus.getName();
        CalibratedAxis[] newAxes = new CalibratedAxis[dimensions.length];
        for (int d = 0; d < newImg.numDimensions(); ++d) {
            int axisIndex = imgPlus.dimensionIndex(axisTypes[d]);
            newAxes[d] = axisIndex < 0 ? new DefaultLinearAxis(axisTypes[d]) : ((CalibratedAxis)imgPlus.axis(axisIndex)).copy();
        }
        return new ImgPlus(newImg, name, newAxes);
    }

    public static void copyData(ImgPlus<? extends RealType<?>> srcImgPlus, ImgPlus<? extends RealType<?>> dstImgPlus, AxisType axis, long srcStartPos, long dstStartPos, long numHyperplanes) {
        if (numHyperplanes == 0L) {
            return;
        }
        long[] srcOrigin = RestructureUtils.calcOrigin(srcImgPlus, axis, srcStartPos);
        long[] dstOrigin = RestructureUtils.calcOrigin(dstImgPlus, axis, dstStartPos);
        long[] srcSpan = RestructureUtils.calcSpan(srcImgPlus, axis, numHyperplanes);
        long[] dstSpan = RestructureUtils.calcSpan(dstImgPlus, axis, numHyperplanes);
        RestructureUtils.copyHyperVolume(srcImgPlus, srcOrigin, srcSpan, dstImgPlus, dstOrigin, dstSpan);
    }

    public static void copyHyperVolume(ImgPlus<? extends RealType<?>> srcImgPlus, long[] srcOrigin, long[] srcSpan, ImgPlus<? extends RealType<?>> dstImgPlus, long[] dstOrigin, long[] dstSpan) {
        RestructureUtils.checkSpanShapes(srcSpan, dstSpan);
        RandomAccess srcAccessor = srcImgPlus.randomAccess();
        RandomAccess dstAccessor = dstImgPlus.randomAccess();
        long[] srcMax = new long[srcOrigin.length];
        for (int i = 0; i < srcMax.length; ++i) {
            srcMax[i] = srcOrigin[i] + srcSpan[i] - 1L;
        }
        long[] dstMax = new long[dstOrigin.length];
        for (int i = 0; i < dstMax.length; ++i) {
            dstMax[i] = dstOrigin[i] + dstSpan[i] - 1L;
        }
        HyperVolumePointSet srcPointSet = new HyperVolumePointSet(srcOrigin, srcMax);
        HyperVolumePointSet dstPointSet = new HyperVolumePointSet(dstOrigin, dstMax);
        PointSetIterator iterS = srcPointSet.iterator();
        PointSetIterator iterD = dstPointSet.iterator();
        long[] srcPos = null;
        long[] dstPos = null;
        while (iterS.hasNext() && iterD.hasNext()) {
            srcPos = (long[])iterS.next();
            dstPos = (long[])iterD.next();
            srcAccessor.setPosition(srcPos);
            dstAccessor.setPosition(dstPos);
            double value = ((RealType)srcAccessor.get()).getRealDouble();
            ((RealType)dstAccessor.get()).setReal(value);
        }
    }

    public static void allocateColorTables(ImgPlus<?> imgPlus) {
        long planeCount = RestructureUtils.planeCount(imgPlus);
        if (planeCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("allocating color tables: too many planes");
        }
        imgPlus.initializeColorTables((int)planeCount);
    }

    public static long planeCount(ImgPlus<?> imgPlus) {
        int numD = imgPlus.numDimensions();
        if (numD < 2) {
            return 0L;
        }
        if (numD == 2) {
            return 1L;
        }
        long count = 1L;
        for (int d = 2; d < numD; ++d) {
            count *= imgPlus.dimension(d);
        }
        return count;
    }

    public static void copyColorTables(ImgPlus<?> srcImgPlus, ImgPlus<?> dstImgPlus) {
        int tableCount = srcImgPlus.getColorTableCount();
        for (int i = 0; i < tableCount; ++i) {
            ColorTable c = srcImgPlus.getColorTable(i);
            dstImgPlus.setColorTable(c, i);
        }
    }

    private static long[] calcSpan(ImgPlus<?> imgPlus, AxisType axis, long numElements) {
        long[] span = new long[imgPlus.numDimensions()];
        imgPlus.dimensions(span);
        int axisIndex = imgPlus.dimensionIndex(axis);
        span[axisIndex] = numElements;
        return span;
    }

    private static long[] calcOrigin(ImgPlus<?> imgPlus, AxisType axis, long startPos) {
        long[] origin = new long[imgPlus.numDimensions()];
        int axisIndex = imgPlus.dimensionIndex(axis);
        origin[axisIndex] = startPos;
        return origin;
    }

    private static void checkSpanShapes(long[] srcSpan, long[] dstSpan) {
        Extents srcExtents = new Extents(srcSpan);
        Extents dstExtents = new Extents(dstSpan);
        if (srcExtents.numElements() != dstExtents.numElements()) {
            throw new IllegalArgumentException("hypervolume regions not shape compatible");
        }
    }
}

