/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.typechange;

import java.util.ArrayList;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.display.ColorTables;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imagej.types.DataTypeService;
import net.imglib2.Axis;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.display.ColorTable;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.meta.ImgPlus;
import net.imglib2.meta.IntervalUtils;
import net.imglib2.meta.SpaceUtils;
import net.imglib2.meta.TypedSpace;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSetIterator;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.Module;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Type", mnemonic=116), @Menu(label="Change...", mnemonic=99)}, headless=true, attrs={@Attr(name="no-legacy")})
public class TypeChanger<U extends RealType<U>, V extends RealType<V> & NativeType<V>>
extends DynamicCommand {
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private DataTypeService dataTypeService;
    @Parameter
    private Dataset data;
    @Parameter(label="Type", persist=false, initializer="init")
    private String typeName;
    @Parameter(label="Combine channels", persist=false)
    private boolean combineChannels;

    public void run() {
        Class<?> typeClass = ((RealType)this.data.getImgPlus().firstElement()).getClass();
        DataType inType = this.dataTypeService.getTypeByClass(typeClass);
        DataType outType = this.dataTypeService.getTypeByName(this.typeName);
        int chAxis = this.data.dimensionIndex(Axes.CHANNEL);
        long channelCount = chAxis < 0 ? 1L : this.data.dimension(chAxis);
        Dataset newData = this.combineChannels && channelCount > 1L && channelCount <= Integer.MAX_VALUE ? this.channelAveragingCase(inType, outType, chAxis, (int)channelCount) : this.channelPreservingCase(inType, outType);
        this.data.setImgPlus(newData.getImgPlus());
        this.data.setRGBMerged(false);
    }

    protected void init() {
        MutableModuleItem input = this.getInfo().getMutableInput("typeName", String.class);
        ArrayList<String> choices = new ArrayList<String>();
        for (DataType dataType : this.dataTypeService.getInstances()) {
            choices.add(dataType.longName());
        }
        input.setChoices(choices);
        RealType dataVar = (RealType)this.data.getImgPlus().firstElement();
        DataType type = this.dataTypeService.getTypeByClass(dataVar.getClass());
        if (type == null) {
            input.setValue((Module)this, choices.get(0));
        } else {
            input.setValue((Module)this, (Object)type.longName());
        }
    }

    private Dataset channelAveragingCase(DataType<U> inType, DataType<V> outType, int chAxis, int count) {
        BigComplex[] temps = new BigComplex[count];
        for (int i = 0; i < count; ++i) {
            temps[i] = new BigComplex();
        }
        BigComplex combined = new BigComplex();
        BigComplex divisor = new BigComplex((long)count, 0L);
        long[] dims = this.calcDims(IntervalUtils.getDims((Dimensions)this.data), chAxis);
        AxisType[] axes = this.calcAxes(SpaceUtils.getAxisTypes((TypedSpace)this.data), chAxis);
        Dataset newData = this.datasetService.create((RealType)outType.createVariable(), dims, "Converted Image", axes);
        long[] span = (long[])IntervalUtils.getDims((Dimensions)this.data).clone();
        span[chAxis] = 1L;
        HyperVolumePointSet combinedSpace = new HyperVolumePointSet(span);
        PointSetIterator iter = combinedSpace.iterator();
        RandomAccess inAccessor = this.data.getImgPlus().randomAccess();
        RandomAccess outAccessor = newData.getImgPlus().randomAccess();
        while (iter.hasNext()) {
            int i;
            long[] pos = (long[])iter.next();
            inAccessor.setPosition(pos);
            for (i = 0; i < count; ++i) {
                inAccessor.setPosition(i, chAxis);
                inType.cast((NumericType)inAccessor.get(), temps[i]);
            }
            combined.setZero();
            for (i = 0; i < count; ++i) {
                combined.add(temps[i]);
            }
            int d = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                if (i2 == chAxis) continue;
                outAccessor.setPosition(pos[i2], d++);
            }
            combined.div(divisor);
            outType.cast(combined, (NumericType)outAccessor.get());
        }
        this.copyMetaDataChannelsCase(this.data.getImgPlus(), newData.getImgPlus());
        return newData;
    }

    private Dataset channelPreservingCase(DataType<U> inType, DataType<V> outType) {
        Dataset newData = this.datasetService.create((RealType)outType.createVariable(), IntervalUtils.getDims((Dimensions)this.data), "Converted Image", SpaceUtils.getAxisTypes((TypedSpace)this.data));
        Cursor inCursor = this.data.getImgPlus().cursor();
        RandomAccess outAccessor = newData.getImgPlus().randomAccess();
        BigComplex tmp = new BigComplex();
        while (inCursor.hasNext()) {
            inCursor.fwd();
            outAccessor.setPosition((Localizable)inCursor);
            this.dataTypeService.cast(inType, (NumericType)inCursor.get(), outType, (NumericType)outAccessor.get(), tmp);
        }
        this.copyMetaDataDefaultCase(this.data.getImgPlus(), newData.getImgPlus());
        return newData;
    }

    private void copyMetaDataDefaultCase(ImgPlus<?> src, ImgPlus<?> dest) {
        dest.setName(src.getName());
        int tableCount = src.getColorTableCount();
        dest.initializeColorTables(tableCount);
        for (int i = 0; i < tableCount; ++i) {
            dest.setColorTable(src.getColorTable(i), i);
        }
        int chAxis = src.dimensionIndex(Axes.CHANNEL);
        int channels = chAxis < 0 ? 1 : (int)src.dimension(chAxis);
        for (int i = 0; i < channels; ++i) {
            double min = src.getChannelMinimum(i);
            double max = src.getChannelMaximum(i);
            dest.setChannelMinimum(i, min);
            dest.setChannelMaximum(i, max);
        }
        for (int d = 0; d < src.numDimensions(); ++d) {
            dest.setAxis((Axis)((CalibratedAxis)src.axis(d)).copy(), d);
        }
    }

    private void copyMetaDataChannelsCase(ImgPlus<?> src, ImgPlus<?> dest) {
        int chAxis = src.dimensionIndex(Axes.CHANNEL);
        dest.setName(src.getName());
        int tableCount = (int)this.calcTableCount(src, chAxis);
        dest.initializeColorTables(tableCount);
        for (int i = 0; i < tableCount; ++i) {
            dest.setColorTable((ColorTable)ColorTables.GRAYS, i);
        }
        double min = src.getChannelMinimum(0);
        double max = src.getChannelMaximum(0);
        int channels = chAxis < 0 ? 1 : (int)src.dimension(chAxis);
        for (int i = 1; i < channels; ++i) {
            min = Math.min(min, src.getChannelMinimum(i));
            max = Math.max(max, src.getChannelMaximum(i));
        }
        dest.setChannelMinimum(0, min);
        dest.setChannelMaximum(0, max);
        int dDest = 0;
        for (int dSrc = 0; dSrc < src.numDimensions(); ++dSrc) {
            if (dSrc == chAxis) continue;
            dest.setAxis((Axis)((CalibratedAxis)src.axis(dSrc)).copy(), dDest++);
        }
    }

    private long[] calcDims(long[] dims, int chAxis) {
        long[] outputDims = new long[dims.length - 1];
        int d = 0;
        for (int i = 0; i < dims.length; ++i) {
            if (i == chAxis) continue;
            outputDims[d++] = dims[i];
        }
        return outputDims;
    }

    private AxisType[] calcAxes(AxisType[] axes, int chAxis) {
        AxisType[] outputAxes = new AxisType[axes.length - 1];
        int d = 0;
        for (int i = 0; i < axes.length; ++i) {
            if (i == chAxis) continue;
            outputAxes[d++] = axes[i];
        }
        return outputAxes;
    }

    private long calcTableCount(ImgPlus<?> src, int chAxis) {
        long count = 1L;
        for (int i = 0; i < src.numDimensions(); ++i) {
            if (i == chAxis) continue;
            count *= src.dimension(i);
        }
        return count;
    }
}

