/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.animation;

import java.util.ArrayList;
import net.imagej.animation.Animation;
import net.imagej.animation.AnimationService;
import net.imagej.display.ImageDisplay;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedAxis;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Animation", mnemonic=97), @Menu(label="Animation Options...", weight=4.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class AnimationOptions
extends DynamicCommand {
    @Parameter
    private AnimationService animationService;
    @Parameter
    private ImageDisplay display;
    @Parameter(label="Axis", persist=false, initializer="initAxisName", callback="axisChanged")
    private String axisName;
    @Parameter(label="First position", persist=false, initializer="initFirst", min="1")
    private long first;
    @Parameter(label="Last position", persist=false, initializer="initLast", min="1")
    private long last;
    @Parameter(label="Speed (0.1 - 1000 fps)", persist=false, initializer="initFPS", min="0.1", max="1000")
    private double fps;
    @Parameter(label="Loop back and forth", persist=false, initializer="initBackAndForth")
    private boolean backAndForth;

    public AnimationService getAnimationService() {
        return this.animationService;
    }

    public void setAnimationService(AnimationService animationService) {
        this.animationService = animationService;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }

    public AxisType getAxis() {
        return Axes.get((String)this.axisName);
    }

    public void setAxis(AxisType axis) {
        this.axisName = axis.toString();
    }

    public double getFPS() {
        return this.fps;
    }

    public void setFPS(double fps) {
        this.fps = fps;
    }

    public long getFirst() {
        return this.first;
    }

    public void setFirst(long first) {
        this.first = first;
    }

    public long getLast() {
        return this.last;
    }

    public void setLast(long last) {
        this.last = last;
    }

    public boolean isBackAndForth() {
        return this.backAndForth;
    }

    public void setBackAndForth(boolean backAndForth) {
        this.backAndForth = backAndForth;
    }

    public void run() {
        this.clampFirstAndLast();
        Animation animation = this.getAnimation();
        boolean active = animation.isActive();
        animation.stop();
        animation.setAxis(this.getAxis());
        animation.setBackAndForth(this.isBackAndForth());
        animation.setFirst(this.getFirst() - 1L);
        animation.setLast(this.getLast() - 1L);
        animation.setFPS(this.getFPS());
        if (active) {
            animation.start();
        }
    }

    protected void initAxisName() {
        MutableModuleItem axisNameItem = this.getInfo().getMutableInput("axisName", String.class);
        ArrayList<String> choices = new ArrayList<String>();
        for (int d = 0; d < this.getDisplay().numDimensions(); ++d) {
            AxisType axisType = ((CalibratedAxis)this.getDisplay().axis(d)).type();
            if (axisType.isXY()) continue;
            choices.add(axisType.getLabel());
        }
        axisNameItem.setChoices(choices);
        AxisType curAxis = this.getAnimation().getAxis();
        if (curAxis != null) {
            this.setAxis(curAxis);
        }
    }

    protected void initFirst() {
        this.setFirst(this.getAnimation().getFirst() + 1L);
    }

    protected void initLast() {
        this.setLast(this.getAnimation().getLast() + 1L);
    }

    protected void initFPS() {
        this.setFPS(this.getAnimation().getFPS());
    }

    protected void initBackAndForth() {
        this.setBackAndForth(this.getAnimation().isBackAndForth());
    }

    protected void axisChanged() {
        this.setLast(this.getAxisLength());
        this.clampFirstAndLast();
    }

    private void clampFirstAndLast() {
        long max = this.getAxisLength();
        long f = this.getFirst();
        long l = this.getLast();
        if (f < 1L) {
            f = 1L;
        }
        if (l < 1L) {
            l = 1L;
        }
        if (f > max) {
            f = max;
        }
        if (l > max) {
            l = max;
        }
        this.setFirst(f);
        this.setLast(l);
    }

    private long getAxisLength() {
        int axisIndex = this.getDisplay().dimensionIndex(this.getAxis());
        if (axisIndex < 0) {
            return -1L;
        }
        return this.getDisplay().dimension(axisIndex);
    }

    private Animation getAnimation() {
        return this.getAnimationService().getAnimation(this.getDisplay());
    }
}

