/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign;

import java.net.URL;
import net.imagej.Dataset;
import net.imagej.Position;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.overlay.Overlay;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.meta.Axes;
import net.imglib2.ops.condition.Condition;
import net.imglib2.ops.condition.UVInsideRoiCondition;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.img.ImageAssignment;
import net.imglib2.ops.input.InputIteratorFactory;
import net.imglib2.ops.input.PointInputIteratorFactory;
import net.imglib2.ops.parse.RealEquationFunctionParser;
import net.imglib2.ops.util.Tuple2;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.widget.Button;

@Plugin(type=Command.class, menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Math", mnemonic=109), @Menu(label="Equation...", weight=20.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class EquationDataValues<T extends RealType<T>>
extends ContextCommand {
    @Parameter
    private OverlayService overlayService;
    @Parameter
    private ImageDisplayService imgDispService;
    @Parameter
    private PlatformService platformService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    @Parameter(visibility=ItemVisibility.MESSAGE)
    private final String examples = "<html><b>Format examples:</b><ul><li>img + 40</li><li>[x,y], x^2 + y^2</li><li>[u1,v1,w1] , -2.003*u1 + 8.41*w1 + E + PI</li><li>[x,y,c,z,t], cos(t*PI/7) + sin(z*PI/12)</li></ul>";
    @Parameter(label="Apply to all planes")
    private boolean allPlanes;
    @Parameter(label="Equation")
    private String equationString;
    @Parameter(label="Help", description="View a web page detailing the equation language", callback="openWebPage", persist=false)
    private Button openWebPage;
    private Dataset dataset;
    private long[] origin;
    private long[] span;
    private UVInsideRoiCondition condition;

    public void run() {
        String err = this.setRegion(this.display, this.allPlanes);
        if (err != null) {
            this.cancel(err);
            return;
        }
        RealEquationFunctionParser parser = new RealEquationFunctionParser();
        Tuple2 result = parser.parse(this.equationString, (Img)this.dataset.getImgPlus());
        if (result.get2() != null) {
            this.cancel("Equation parsing error: " + (String)result.get2());
            return;
        }
        PointInputIteratorFactory factory = new PointInputIteratorFactory();
        Function function = (Function)result.get1();
        ImageAssignment assigner = new ImageAssignment((RandomAccessibleInterval)this.dataset.getImgPlus(), this.origin, this.span, function, (Condition)this.condition, (InputIteratorFactory)factory);
        assigner.assign();
        this.dataset.update();
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }

    public boolean isAllPlanes() {
        return this.allPlanes;
    }

    public void setAllPlanes(boolean value) {
        this.allPlanes = value;
    }

    public String getEquation() {
        return this.equationString;
    }

    public void setEquation(String equationString) {
        this.equationString = equationString;
    }

    private String setRegion(ImageDisplay disp, boolean allPlanes) {
        long h;
        long w;
        long y;
        long x;
        this.dataset = this.imgDispService.getActiveDataset(disp);
        Overlay overlay = this.overlayService.getActiveOverlay(disp);
        DatasetView view = this.imgDispService.getActiveDatasetView(disp);
        int xIndex = this.dataset.dimensionIndex(Axes.X);
        int yIndex = this.dataset.dimensionIndex(Axes.Y);
        if (xIndex < 0 || yIndex < 0) {
            return "display does not have XY planes";
        }
        if (overlay == null) {
            x = 0L;
            y = 0L;
            w = this.dataset.dimension(xIndex);
            h = this.dataset.dimension(yIndex);
        } else {
            x = (long)overlay.realMin(0);
            y = (long)overlay.realMin(1);
            w = Math.round(overlay.realMax(0) - (double)x);
            h = Math.round(overlay.realMax(1) - (double)y);
        }
        this.origin = new long[this.dataset.numDimensions()];
        this.span = new long[this.dataset.numDimensions()];
        Position pos = view.getPlanePosition();
        int p = 0;
        for (int i = 0; i < this.dataset.numDimensions(); ++i) {
            if (i == xIndex) {
                this.origin[xIndex] = x;
                this.span[xIndex] = w;
                continue;
            }
            if (i == yIndex) {
                this.origin[yIndex] = y;
                this.span[yIndex] = h;
                continue;
            }
            if (allPlanes) {
                this.origin[i] = 0L;
                this.span[i] = this.dataset.dimension(i);
                continue;
            }
            this.origin[i] = pos.getLongPosition(p++);
            this.span[i] = 1L;
        }
        this.condition = null;
        if (overlay != null) {
            this.condition = new UVInsideRoiCondition(overlay.getRegionOfInterest());
        }
        return null;
    }

    protected void openWebPage() {
        try {
            String urlString = "http://wiki.imagej.net/ImageJ2/Documentation/Process/Math/Equation";
            URL url = new URL(urlString);
            this.platformService.open(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

