/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.display;

import net.imagej.display.ColorMode;
import net.imagej.display.DatasetView;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.command.Previewable;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Color"), @Menu(label="Channels Tool...", accelerator="shift ^Z", weight=-5.0)}, iconPath="/icons/commands/color_wheel.png", headless=true, attrs={@Attr(name="no-legacy")})
public class ChannelsTool
extends ContextCommand
implements Previewable {
    public static final String GRAYSCALE = "Grayscale";
    public static final String COLOR = "Color";
    public static final String COMPOSITE = "Composite";
    @Parameter(type=ItemIO.BOTH)
    private DatasetView view;
    @Parameter(label="Color mode", persist=false, choices={"Grayscale", "Color", "Composite"})
    private String modeString = "Grayscale";

    public ChannelsTool() {
        if (this.view != null) {
            this.setColorMode(this.view.getColorMode());
        }
    }

    public void run() {
        if (this.view == null) {
            return;
        }
        this.view.setColorMode(this.getColorMode());
        this.view.update();
    }

    public void preview() {
        this.run();
    }

    public void cancel() {
    }

    public DatasetView getView() {
        return this.view;
    }

    public void setView(DatasetView view) {
        this.view = view;
    }

    public ColorMode getColorMode() {
        return ColorMode.get((String)this.modeString);
    }

    public void setColorMode(ColorMode colorMode) {
        this.modeString = colorMode.getLabel();
    }
}

