/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.display;

import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.event.DatasetRestructuredEvent;
import net.imagej.event.DatasetUpdatedEvent;
import net.imagej.widget.HistogramBundle;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccess;
import net.imglib2.histogram.BinMapper1d;
import net.imglib2.histogram.DiscreteFrequencyDistribution;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.histogram.Real1dBinMapper;
import net.imglib2.meta.Axes;
import net.imglib2.meta.IntervalUtils;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSetIterator;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.command.InteractiveCommand;
import org.scijava.event.EventHandler;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;
import org.scijava.widget.Button;

@Plugin(type=Command.class, menu={@Menu(label="Analyze"), @Menu(label="Histogram Plot", accelerator="shift alt ^H", weight=0.0)}, attrs={@Attr(name="no-legacy")})
public class HistogramPlot<T extends RealType<T>>
extends InteractiveCommand {
    @Parameter
    private UIService uiService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private OverlayService overlayService;
    @Parameter
    private ImageDisplay display;
    @Parameter(label="Histogram", initializer="initBundle")
    private HistogramBundle bundle;
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false)
    private String pixelsStr;
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false)
    private String minStr;
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false)
    private String maxStr;
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false)
    private String meanStr;
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false)
    private String stdDevStr;
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false)
    private String binsStr;
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false)
    private String binWidthStr;
    @Parameter(label="Static", callback="liveClicked")
    private Button liveButton;
    @Parameter(label="List", callback="listClicked")
    private Button listButton;
    @Parameter(label="Copy", callback="copyClicked")
    private Button copyButton;
    @Parameter(label="Log", callback="logClicked")
    private Button logButton;
    @Parameter(label="Composite", callback="chanClicked")
    private Button chanButton;
    private Dataset dataset;
    private long channels;
    private Histogram1d<T>[] histograms;
    private double[] means;
    private double[] stdDevs;
    private double[] mins;
    private double[] maxes;
    private double[] sum1s;
    private double[] sum2s;
    private long sampleCount;
    private double binWidth;
    private double dataMin;
    private double dataMax;
    private long binCount;
    private int currHistNum;
    private boolean liveUpdates = false;

    public HistogramPlot() {
        super(new String[0]);
    }

    public void setDisplay(ImageDisplay disp) {
        this.display = disp;
        this.dataset = this.imageDisplayService.getActiveDataset(this.display);
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void run() {
        this.display(this.histograms.length - 1);
    }

    protected void initBundle() {
        this.build();
        this.bundle = new HistogramBundle(this.histograms[this.histograms.length - 1]);
        this.setValues(this.histograms.length - 1);
    }

    protected void chanClicked() {
        int nextHistNum;
        MutableModuleItem item = this.getInfo().getMutableInput("chanButton", Button.class);
        int n = nextHistNum = this.currHistNum >= this.histograms.length - 1 ? 0 : this.currHistNum + 1;
        if (nextHistNum == this.histograms.length - 1) {
            item.setLabel("Composite");
        } else {
            item.setLabel("Channel " + nextHistNum);
        }
        this.display(nextHistNum);
    }

    protected void copyClicked() {
        this.uiService.showDialog("To be implemented");
    }

    protected void listClicked() {
        this.uiService.showDialog("To be implemented");
    }

    protected void liveClicked() {
        this.liveUpdates = !this.liveUpdates;
        MutableModuleItem item = this.getInfo().getMutableInput("liveButton", Button.class);
        item.setLabel(this.liveUpdates ? "Live" : "Static");
        if (this.liveUpdates) {
            this.liveUpdate(this.dataset);
        }
    }

    protected void logClicked() {
        long maxCount = this.max(this.bundle.getHistogram(0).dfd());
        double max = Math.log(maxCount);
        if (this.bundle.getHistogramCount() == 1) {
            Real1dBinMapper mapper = new Real1dBinMapper(this.dataMin, this.dataMax, this.binCount, false);
            Histogram1d hist = new Histogram1d((BinMapper1d)mapper);
            long[] binPos = new long[1];
            int i = 0;
            while ((long)i < this.binCount) {
                binPos[0] = i;
                long count = this.bundle.getHistogram(0).dfd().frequency(binPos);
                long value = (long)((double)maxCount * Math.log(count) / max);
                this.setBinValue(hist.dfd(), binPos, value);
                ++i;
            }
            this.bundle.setHistogram(1, hist);
        } else {
            this.bundle.setHistogram(1, null);
        }
    }

    private long max(DiscreteFrequencyDistribution dfd) {
        long max = -1L;
        Cursor cursor = dfd.cursor();
        while (cursor.hasNext()) {
            LongType val = (LongType)cursor.next();
            if (val.get() <= max) continue;
            max = val.get();
        }
        return max;
    }

    private void setBinValue(DiscreteFrequencyDistribution dfd, long[] binPos, long value) {
        while (dfd.frequency(binPos) > 0L) {
            dfd.decrement(binPos);
        }
        for (long i = 0L; i < value; ++i) {
            dfd.increment(binPos);
        }
    }

    @EventHandler
    protected void onEvent(DatasetRestructuredEvent evt) {
        this.liveUpdate(evt.getObject());
    }

    @EventHandler
    protected void onEvent(DatasetUpdatedEvent evt) {
        this.liveUpdate(evt.getObject());
    }

    private void display(int histNumber) {
        int h = histNumber;
        if (h >= this.histograms.length) {
            h = this.histograms.length - 1;
        }
        this.currHistNum = h;
        this.bundle.setHistogram(0, this.histograms[h]);
        this.setTitle(h);
        this.setValues(h);
    }

    private void setValues(int histNumber) {
        this.pixelsStr = this.formatStr("Pixels", this.sampleCount / this.channels);
        this.minStr = this.formatStr("Min", this.mins[histNumber]);
        this.maxStr = this.formatStr("Max", this.maxes[histNumber]);
        this.meanStr = this.formatStr("Mean", this.means[histNumber]);
        this.stdDevStr = this.formatStr("Std Dev", this.stdDevs[histNumber]);
        this.binsStr = this.formatStr("Bins", this.binCount);
        this.binWidthStr = this.formatStr("Bin Width", this.binWidth);
    }

    private String formatStr(String label, long num) {
        return String.format("%12s:%10d", label, num);
    }

    private String formatStr(String label, double num) {
        return String.format("%12s:%10.2f", label, num);
    }

    private void setTitle(int histNum) {
        String title = histNum == this.histograms.length - 1 ? "Composite histogram of " : "Channel " + histNum + " histogram of ";
        title = title + this.display.getName();
    }

    private void calcBinInfo() {
        this.dataMin = Double.POSITIVE_INFINITY;
        this.dataMax = Double.NEGATIVE_INFINITY;
        Cursor cursor = this.dataset.getImgPlus().cursor();
        while (cursor.hasNext()) {
            double val = ((RealType)cursor.next()).getRealDouble();
            if (val < this.dataMin) {
                this.dataMin = val;
            }
            if (!(val > this.dataMax)) continue;
            this.dataMax = val;
        }
        if (this.dataMin > this.dataMax) {
            this.dataMin = 0.0;
            this.dataMax = 0.0;
        }
        double dataRange = this.dataMax - this.dataMin;
        if (this.dataset.isInteger()) {
            if ((dataRange += 1.0) <= 65536.0) {
                this.binCount = (long)dataRange;
                this.binWidth = 1.0;
            } else {
                this.binCount = 65536L;
                this.binWidth = dataRange / (double)this.binCount;
            }
        } else {
            this.binCount = 1000L;
            this.binWidth = dataRange / (double)this.binCount;
        }
    }

    private void allocateDataStructures() {
        int i;
        int chIndex = this.dataset.dimensionIndex(Axes.CHANNEL);
        this.channels = chIndex < 0 ? 1L : this.dataset.dimension(chIndex);
        this.histograms = new Histogram1d[(int)this.channels + 1];
        Real1dBinMapper mapper = new Real1dBinMapper(this.dataMin, this.dataMax, this.binCount, false);
        for (i = 0; i < this.histograms.length; ++i) {
            this.histograms[i] = new Histogram1d((BinMapper1d)mapper);
        }
        this.means = new double[this.histograms.length];
        this.stdDevs = new double[this.histograms.length];
        this.sum1s = new double[this.histograms.length];
        this.sum2s = new double[this.histograms.length];
        this.mins = new double[this.histograms.length];
        this.maxes = new double[this.histograms.length];
        for (i = 0; i < this.histograms.length; ++i) {
            this.mins[i] = Double.POSITIVE_INFINITY;
            this.maxes[i] = Double.NEGATIVE_INFINITY;
        }
    }

    private void computeStats() {
        int chIndex = this.dataset.dimensionIndex(Axes.CHANNEL);
        int composH = this.histograms.length - 1;
        RandomAccess accessor = this.dataset.getImgPlus().randomAccess();
        long[] span = IntervalUtils.getDims((Dimensions)this.dataset);
        if (chIndex >= 0) {
            span[chIndex] = 1L;
        }
        HyperVolumePointSet pixelSpace = new HyperVolumePointSet(span);
        PointSetIterator pixelSpaceIter = pixelSpace.iterator();
        this.sampleCount = 0L;
        while (pixelSpaceIter.hasNext()) {
            long[] pos = (long[])pixelSpaceIter.next();
            accessor.setPosition(pos);
            double composVal = 0.0;
            for (long chan = 0L; chan < this.channels; ++chan) {
                if (chIndex >= 0) {
                    accessor.setPosition(chan, chIndex);
                }
                double val = ((RealType)accessor.get()).getRealDouble();
                composVal += val;
                long index = (long)((val - this.dataMin) / this.binWidth);
                if (index >= this.binCount) {
                    index = this.binCount - 1L;
                }
                int c = (int)chan;
                this.histograms[c].increment(index);
                int n = c;
                this.sum1s[n] = this.sum1s[n] + val;
                int n2 = c;
                this.sum2s[n2] = this.sum2s[n2] + val * val;
                if (val < this.mins[c]) {
                    this.mins[c] = val;
                }
                if (val > this.maxes[c]) {
                    this.maxes[c] = val;
                }
                ++this.sampleCount;
            }
            long index = (long)(((composVal /= (double)this.channels) - this.dataMin) / this.binWidth);
            if (index >= this.binCount) {
                index = this.binCount - 1L;
            }
            this.histograms[composH].increment(index);
            int n = composH;
            this.sum1s[n] = this.sum1s[n] + composVal;
            int n3 = composH;
            this.sum2s[n3] = this.sum2s[n3] + composVal * composVal;
            if (composVal < this.mins[composH]) {
                this.mins[composH] = composVal;
            }
            if (!(composVal > this.maxes[composH])) continue;
            this.maxes[composH] = composVal;
        }
        long pixels = this.sampleCount / this.channels;
        for (int i = 0; i < this.histograms.length; ++i) {
            this.means[i] = this.sum1s[i] / (double)pixels;
            this.stdDevs[i] = Math.sqrt((this.sum2s[i] - this.sum1s[i] * this.sum1s[i] / (double)pixels) / (double)(pixels - 1L));
        }
    }

    private void build() {
        this.dataset = this.imageDisplayService.getActiveDataset(this.display);
        this.calcBinInfo();
        this.allocateDataStructures();
        this.computeStats();
    }

    private void liveUpdate(Dataset ds) {
        if (!this.liveUpdates) {
            return;
        }
        if (ds != this.dataset) {
            return;
        }
        this.build();
        this.bundle.setHasChanges(true);
        this.display(this.currHistNum);
    }
}

