/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.display;

import java.util.List;
import net.imagej.ChannelCollection;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.DrawingTool;
import net.imagej.display.ColorTables;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.render.RenderingService;
import net.imagej.render.TextRenderer;
import net.imglib2.display.ColorTable;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ColorRGB;
import org.scijava.util.Colors;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Color"), @Menu(label="Show LUT", weight=12.0)}, attrs={@Attr(name="no-legacy")})
public class ShowLUT
extends ContextCommand {
    @Parameter
    private ImageDisplayService imgDispService;
    @Parameter
    private DisplayService displayService;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private RenderingService renderingService;
    @Parameter
    private ImageDisplay display;
    @Parameter(type=ItemIO.OUTPUT)
    private Display<?> output;

    public void run() {
        DatasetView view = this.imgDispService.getActiveDatasetView(this.display);
        List colorTables = view.getColorTables();
        int currChannel = this.display.getIntPosition(Axes.CHANNEL);
        ColorTable colorTable = (ColorTable)colorTables.get(currChannel);
        Dataset ds = this.createDataset(colorTable);
        this.output = this.displayService.createDisplay((Object)ds);
    }

    public void setDisplay(ImageDisplay disp) {
        this.display = disp;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public Display<?> getOutput() {
        return this.output;
    }

    private Dataset createDataset(ColorTable lut) {
        long[] dims = new long[]{326L, 188L, 3L};
        String name = "Look-Up Table";
        AxisType[] axes = new AxisType[]{Axes.X, Axes.Y, Axes.CHANNEL};
        int bitsPerPixel = 8;
        boolean signed = false;
        boolean floating = false;
        Dataset ds = this.datasetService.create(dims, name, axes, bitsPerPixel, signed, floating);
        ds.setRGBMerged(true);
        this.drawLUTInfo(ds, lut);
        return ds;
    }

    private void drawLUTInfo(Dataset ds, ColorTable ct) {
        int y2;
        int x2;
        int i;
        DrawingTool tool = new DrawingTool(ds, this.renderingService);
        int xMargin = 35;
        int yMargin = 20;
        int width = 256;
        int height = 128;
        int barHeight = 12;
        boolean isGray = ColorTables.isGrayColorTable((ColorTable)ct);
        int mapSize = ct.getLength();
        int imageWidth = width + 2 * xMargin;
        int imageHeight = height + 3 * yMargin;
        tool.setChannels(new ChannelCollection(Colors.WHITE));
        tool.fillRect(0L, 0L, (long)imageWidth, (long)imageHeight);
        tool.setChannels(new ChannelCollection(Colors.BLACK));
        tool.drawRect((long)xMargin, (long)yMargin, (long)width, (long)height);
        double scale = 256.0 / (double)mapSize;
        if (!isGray) {
            tool.setChannels(new ChannelCollection(Colors.RED));
        }
        int x1 = xMargin;
        int y1 = yMargin + height - ct.getResampled(0, 256, 0) / 2;
        for (i = 1; i < 256; ++i) {
            x2 = xMargin + i;
            y2 = yMargin + height - ct.getResampled(0, 256, (int)((double)i / scale)) / 2;
            tool.drawLine((long)x1, (long)y1, (long)x2, (long)y2);
            x1 = x2;
            y1 = y2;
        }
        if (!isGray) {
            tool.setChannels(new ChannelCollection(Colors.LIGHTGREEN));
            x1 = xMargin;
            y1 = yMargin + height - ct.getResampled(1, 256, 0) / 2;
            for (i = 1; i < 256; ++i) {
                x2 = xMargin + i;
                y2 = yMargin + height - ct.getResampled(1, 256, (int)((double)i / scale)) / 2;
                tool.drawLine((long)x1, (long)y1, (long)x2, (long)y2);
                x1 = x2;
                y1 = y2;
            }
        }
        if (!isGray) {
            tool.setChannels(new ChannelCollection(Colors.BLUE));
            x1 = xMargin;
            y1 = yMargin + height - ct.getResampled(2, 256, 0) / 2;
            for (i = 1; i < 255; ++i) {
                x2 = xMargin + i;
                y2 = yMargin + height - ct.getResampled(2, 256, (int)((double)i / scale)) / 2;
                tool.drawLine((long)x1, (long)y1, (long)x2, (long)y2);
                x1 = x2;
                y1 = y2;
            }
        }
        int x = xMargin;
        int y = yMargin + height + 2;
        this.drawColorBar(tool, ct, x, y, 256, barHeight);
        tool.setChannels(new ChannelCollection(Colors.BLACK));
        tool.drawText((long)(x - 4), (long)(y += barHeight + 15), "0", TextRenderer.TextJustification.LEFT);
        tool.drawText((long)(x + width - 10), (long)y, "" + (mapSize - 1), TextRenderer.TextJustification.LEFT);
        tool.drawText(7L, (long)(yMargin + 4), "255", TextRenderer.TextJustification.LEFT);
    }

    private void drawColorBar(DrawingTool tool, ColorTable ct, int x, int y, int width, int height) {
        double scale = 256.0 / (double)ct.getLength();
        for (int i = 0; i < 256; ++i) {
            int index = (int)((double)i / scale);
            int r = ct.getResampled(0, 256, index);
            int g = ct.getResampled(1, 256, index);
            int b = ct.getResampled(2, 256, index);
            ColorRGB color = new ColorRGB(r, g, b);
            tool.setChannels(new ChannelCollection(color));
            tool.moveTo((long)(x + i), (long)y);
            tool.lineTo((long)(x + i), (long)(y + height));
        }
        tool.setChannels(new ChannelCollection(Colors.BLACK));
        tool.drawRect((long)x, (long)y, (long)width, (long)height);
    }
}

