/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.imglib;

import net.imagej.Dataset;
import net.imglib2.ExtendedRandomAccessibleInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.img.Img;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.meta.ImgPlus;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Filters", mnemonic=102), @Menu(label="Gaussian Blur...")}, headless=true, attrs={@Attr(name="no-legacy")})
public class GaussianBlur<T extends RealType<T>>
extends ContextCommand {
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    @Parameter(label="Sigma (radius)", min="0.0001")
    private double sigma = 2.0;
    @Parameter(label="Use units")
    private boolean useUnits = false;

    public void run() {
        double[] sigmas = this.sigmas();
        ImgPlus target = this.dataset.getImgPlus();
        Img input = target.copy();
        ExtendedRandomAccessibleInterval paddedInput = Views.extendMirrorSingle((RandomAccessibleInterval)input);
        try {
            Gauss3.gauss((double[])sigmas, (RandomAccessible)paddedInput, (RandomAccessibleInterval)target);
        }
        catch (Exception e) {
            this.cancel(e.getMessage());
        }
    }

    private double[] sigmas() {
        double[] sigmas = new double[this.dataset.numDimensions()];
        for (int d = 0; d < sigmas.length; ++d) {
            if (this.useUnits) {
                CalibratedAxis axis = (CalibratedAxis)this.dataset.axis(d);
                sigmas[d] = axis.rawValue(this.sigma) - axis.rawValue(0.0);
                continue;
            }
            sigmas[d] = this.sigma;
        }
        return sigmas;
    }
}

