/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.imglib;

import net.imagej.Dataset;
import net.imagej.plugins.commands.imglib.OutputAlgorithm;
import net.imglib2.img.Img;
import net.imglib2.meta.ImgPlus;
import net.imglib2.meta.ImgPlusMetadata;
import net.imglib2.type.numeric.RealType;

public class ImgLibDataTransform
implements Runnable {
    private final Dataset dataset;
    private final OutputAlgorithm<Img<? extends RealType<?>>> algorithm;

    public ImgLibDataTransform(Dataset dataset, OutputAlgorithm<Img<? extends RealType<?>>> algorithm) {
        this.dataset = dataset;
        this.algorithm = algorithm;
    }

    @Override
    public void run() {
        if (!this.algorithm.checkInput() || !this.algorithm.process()) {
            throw new IllegalStateException(this.algorithm.getErrorMessage());
        }
        ImgPlus imgPlus = ImgPlus.wrap(this.algorithm.getResult(), (ImgPlusMetadata)this.dataset);
        this.dataset.setImgPlus(imgPlus);
    }
}

