/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.overlay;

import java.util.ArrayList;
import java.util.List;
import net.imagej.options.OptionsOverlay;
import net.imagej.overlay.Overlay;
import org.scijava.command.ContextCommand;
import org.scijava.command.Previewable;
import org.scijava.options.OptionsService;
import org.scijava.plugin.Parameter;
import org.scijava.util.ColorRGB;
import org.scijava.util.Colors;

public abstract class AbstractOverlayProperties
extends ContextCommand
implements Previewable {
    private static final String solidLineStyle = "Solid";
    private static final String dashLineStyle = "Dash";
    private static final String dotLineStyle = "Dot";
    private static final String dotDashLineStyle = "Dot-dash";
    private static final String noLineStyle = "None";
    private static final String arrowLineDecoration = "Arrow";
    private static final String noLineDecoration = "None";
    @Parameter(label="Line color", persist=false)
    private ColorRGB lineColor = Colors.YELLOW;
    @Parameter(label="Line width", persist=false, min="0.1")
    private double lineWidth = 1.0;
    @Parameter(label="Line style", persist=false, choices={"Solid", "Dash", "Dot", "Dot-dash", "None"})
    private String lineStyle = "Solid";
    @Parameter(label="Fill color", persist=false)
    private ColorRGB fillColor = null;
    @Parameter(label="Alpha", description="The opacity or alpha of the interior of the overlay (0=transparent, 255=opaque)", persist=false, style="scroll bar", min="0", max="255")
    private int alpha = 0;
    @Parameter(label="Line start arrow style", description="The arrow style at the starting point of a line or other path", persist=false, choices={"None", "Arrow"})
    private String startLineArrowStyle = "None";
    @Parameter(label="Line end arrow style", description="The arrow style at the end point of a line or other path", persist=false, choices={"None", "Arrow"})
    private String endLineArrowStyle = "None";
    @Parameter(label="Update default overlay settings", persist=false)
    private boolean updateDefaults = false;
    @Parameter
    private OptionsService os;
    private List<Overlay> overlays = new ArrayList<Overlay>();

    protected void setOverlays(List<Overlay> overlays) {
        this.overlays = overlays;
    }

    protected void updateValues() {
        if (this.overlays.size() > 0) {
            Overlay o = this.overlays.get(0);
            this.lineColor = o.getLineColor();
            this.lineWidth = o.getLineWidth();
            this.fillColor = o.getFillColor();
            this.alpha = o.getAlpha();
            switch (o.getLineStyle()) {
                case SOLID: {
                    this.lineStyle = solidLineStyle;
                    break;
                }
                case DASH: {
                    this.lineStyle = dashLineStyle;
                    break;
                }
                case DOT: {
                    this.lineStyle = dotLineStyle;
                    break;
                }
                case DOT_DASH: {
                    this.lineStyle = dotDashLineStyle;
                    break;
                }
                case NONE: {
                    this.lineStyle = "None";
                }
            }
            switch (o.getLineStartArrowStyle()) {
                case NONE: {
                    this.startLineArrowStyle = "None";
                    break;
                }
                case ARROW: {
                    this.startLineArrowStyle = arrowLineDecoration;
                }
            }
            switch (o.getLineEndArrowStyle()) {
                case NONE: {
                    this.endLineArrowStyle = "None";
                    break;
                }
                case ARROW: {
                    this.endLineArrowStyle = arrowLineDecoration;
                }
            }
        }
    }

    public void run() {
        for (Overlay o : this.overlays) {
            o.setLineColor(this.getLineColor());
            o.setLineWidth(this.getLineWidth());
            o.setFillColor(this.getFillColor());
            o.setAlpha(this.getAlpha());
            o.setLineStyle(this.getLineStyle());
            o.setLineStartArrowStyle(this.getStartLineArrowStyle());
            o.setLineEndArrowStyle(this.getEndLineArrowStyle());
            o.update();
        }
        if (this.updateDefaults) {
            this.updateDefaults();
        }
    }

    public void preview() {
        this.run();
    }

    public void cancel() {
    }

    public ColorRGB getLineColor() {
        return this.lineColor;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public ColorRGB getFillColor() {
        return this.fillColor;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Overlay.LineStyle getLineStyle() {
        return this.decodeLineStyle(this.lineStyle);
    }

    public Overlay.ArrowStyle getStartLineArrowStyle() {
        return this.decodeArrowStyle(this.startLineArrowStyle);
    }

    public Overlay.ArrowStyle getEndLineArrowStyle() {
        return this.decodeArrowStyle(this.endLineArrowStyle);
    }

    public boolean isUpdateDefaults() {
        return this.updateDefaults;
    }

    public void setUpdateDefaults(boolean updateDefaults) {
        this.updateDefaults = updateDefaults;
    }

    private void updateDefaults() {
        OptionsOverlay options = (OptionsOverlay)this.os.getOptions(OptionsOverlay.class);
        options.setLineWidth(this.getLineWidth());
        options.setLineColor(this.getLineColor());
        options.setLineStyle(this.getLineStyle());
        options.setFillColor(this.getFillColor());
        options.setAlpha(this.getAlpha());
        options.setStartArrowStyle(this.getStartLineArrowStyle());
        options.setEndArrowStyle(this.getEndLineArrowStyle());
        options.run();
    }

    private Overlay.LineStyle decodeLineStyle(String style) {
        if (style == null) {
            return Overlay.LineStyle.SOLID;
        }
        if (style.equals(solidLineStyle)) {
            return Overlay.LineStyle.SOLID;
        }
        if (style.equals(dashLineStyle)) {
            return Overlay.LineStyle.DASH;
        }
        if (style.equals(dotLineStyle)) {
            return Overlay.LineStyle.DOT;
        }
        if (style.equals(dotDashLineStyle)) {
            return Overlay.LineStyle.DOT_DASH;
        }
        if (style.equals("None")) {
            return Overlay.LineStyle.NONE;
        }
        throw new UnsupportedOperationException("Unimplemented style: " + style);
    }

    private Overlay.ArrowStyle decodeArrowStyle(String style) {
        if (style == null) {
            return Overlay.ArrowStyle.NONE;
        }
        if (style.equals(arrowLineDecoration)) {
            return Overlay.ArrowStyle.ARROW;
        }
        if (style.equals("None")) {
            return Overlay.ArrowStyle.NONE;
        }
        throw new UnsupportedOperationException("Unimplemented style: " + style);
    }
}

