/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.restructure;

import java.util.ArrayList;
import net.imagej.Dataset;
import net.imagej.plugins.commands.restructure.ColorTableRemapper;
import net.imagej.plugins.commands.restructure.RestructureUtils;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.meta.ImgPlus;
import net.imglib2.meta.SpaceUtils;
import net.imglib2.meta.TypedSpace;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Data", mnemonic=100), @Menu(label="Add Data...")}, headless=true, initializer="initAll", attrs={@Attr(name="no-legacy")})
public class AddData
extends DynamicCommand {
    private static final String AXIS_NAME = "axisName";
    private static final String POSITION = "position";
    private static final String QUANTITY = "quantity";
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    @Parameter(label="Axis to modify", persist=false, callback="parameterChanged")
    private String axisName;
    @Parameter(label="Insertion position", persist=false, callback="parameterChanged")
    private long position = 1L;
    @Parameter(label="Insertion quantity", persist=false, callback="parameterChanged")
    private long quantity = 1L;

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public AxisType getAxis() {
        return Axes.get((String)this.axisName);
    }

    public void setAxis(AxisType axis) {
        this.axisName = axis.toString();
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(long quantity) {
        this.quantity = quantity;
    }

    public void run() {
        AxisType axis = Axes.get((String)this.axisName);
        if (this.inputBad(axis)) {
            return;
        }
        AxisType[] axes = SpaceUtils.getAxisTypes((TypedSpace)this.dataset);
        long[] newDimensions = RestructureUtils.getDimensions(this.dataset, axis, this.quantity);
        ImgPlus<? extends RealType<?>> dstImgPlus = RestructureUtils.createNewImgPlus(this.dataset, newDimensions, axes);
        this.fillNewImgPlus(this.dataset.getImgPlus(), dstImgPlus, axis);
        int compositeChannelCount = this.compositeStatus(this.dataset, dstImgPlus, axis);
        dstImgPlus.setCompositeChannelCount(compositeChannelCount);
        RestructureUtils.allocateColorTables(dstImgPlus);
        if (axis.isXY()) {
            RestructureUtils.copyColorTables(this.dataset.getImgPlus(), dstImgPlus);
        } else {
            ColorTableRemapper remapper = new ColorTableRemapper(new RemapAlgorithm());
            remapper.remapColorTables(this.dataset.getImgPlus(), dstImgPlus);
        }
        this.dataset.setImgPlus(dstImgPlus);
    }

    protected void initAll() {
        this.initAxisName();
        this.initPosition();
        this.initQuantity();
    }

    protected void parameterChanged() {
        this.setPositionRange();
        this.setQuantityRange();
        this.clampPosition();
        this.clampQuantity();
    }

    private boolean inputBad(AxisType axis) {
        if (axis == null) {
            this.cancel("Axis must not be null.");
            return true;
        }
        int axisIndex = this.dataset.dimensionIndex(axis);
        long axisSize = this.dataset.getImgPlus().dimension(axisIndex);
        if (axisIndex < 0) {
            this.cancel("Axis " + axis.getLabel() + " is not present in input dataset.");
            return true;
        }
        if (this.position < 1L || this.position > axisSize + 1L) {
            this.cancel("Insertion position is out of bounds.");
            return true;
        }
        if (this.quantity <= 0L || this.quantity > Long.MAX_VALUE - axisSize) {
            this.cancel("Insertion quantity is out of bounds.");
            return true;
        }
        return false;
    }

    private void fillNewImgPlus(ImgPlus<? extends RealType<?>> srcImgPlus, ImgPlus<? extends RealType<?>> dstImgPlus, AxisType modifiedAxis) {
        int axisIndex = this.dataset.dimensionIndex(modifiedAxis);
        long axisSize = this.dataset.dimension(axisIndex);
        long numBeforeInsert = this.position - 1L;
        long numInInsertion = this.quantity;
        long numAfterInsertion = axisSize - numBeforeInsert;
        RestructureUtils.copyData(srcImgPlus, dstImgPlus, modifiedAxis, 0L, 0L, numBeforeInsert);
        RestructureUtils.copyData(srcImgPlus, dstImgPlus, modifiedAxis, numBeforeInsert, numBeforeInsert + numInInsertion, numAfterInsertion);
    }

    private int compositeStatus(Dataset origData, ImgPlus<?> dstImgPlus, AxisType axis) {
        if (axis != Axes.CHANNEL) {
            return origData.getCompositeChannelCount();
        }
        int currComposCount = this.dataset.getCompositeChannelCount();
        int origAxisPos = origData.dimensionIndex(Axes.CHANNEL);
        long numOrigChannels = origData.getImgPlus().dimension(origAxisPos);
        long numNewChannels = dstImgPlus.dimension(origAxisPos);
        if (currComposCount == 1) {
            return 1;
        }
        if (numOrigChannels == (long)currComposCount) {
            return (int)numNewChannels;
        }
        if (numOrigChannels % (long)currComposCount == 0L && numNewChannels % (long)currComposCount == 0L) {
            return currComposCount;
        }
        return 1;
    }

    private void initAxisName() {
        MutableModuleItem axisNameItem = this.getInfo().getMutableInput(AXIS_NAME, String.class);
        Dataset ds = this.getDataset();
        ArrayList<String> choices = new ArrayList<String>();
        for (int i = 0; i < ds.numDimensions(); ++i) {
            AxisType axisType = ((CalibratedAxis)ds.axis(i)).type();
            choices.add(axisType.getLabel());
        }
        axisNameItem.setChoices(choices);
    }

    private void initPosition() {
        long max = this.getDataset().getImgPlus().dimension(0);
        this.setItemRange(POSITION, 1L, max);
        this.setPosition(1L);
    }

    private void initQuantity() {
        this.setItemRange(QUANTITY, 1L, Long.MAX_VALUE);
        this.setQuantity(1L);
    }

    private void setPositionRange() {
        long dimLen = this.currDimLen();
        this.setItemRange(POSITION, 1L, dimLen + 1L);
    }

    private void setQuantityRange() {
        long max = Long.MAX_VALUE - this.getPosition() + 1L;
        this.setItemRange(QUANTITY, 1L, max);
    }

    private void clampPosition() {
        long max = this.currDimLen() + 1L;
        long pos = this.getPosition();
        if (pos < 1L) {
            this.setPosition(1L);
        } else if (pos > max) {
            this.setPosition(max);
        }
    }

    private void clampQuantity() {
        long max = Long.MAX_VALUE - this.getPosition() + 1L;
        long total = this.getQuantity();
        if (total < 1L) {
            this.setQuantity(1L);
        } else if (total > max) {
            this.setQuantity(max);
        }
    }

    private long currDimLen() {
        AxisType axis = this.getAxis();
        int axisIndex = this.getDataset().dimensionIndex(axis);
        return this.getDataset().getImgPlus().dimension(axisIndex);
    }

    private void setItemRange(String fieldName, long min, long max) {
        MutableModuleItem item = this.getInfo().getMutableInput(fieldName, Long.class);
        item.setMinimumValue((Object)min);
    }

    private class RemapAlgorithm
    implements ColorTableRemapper.RemapAlgorithm {
        private RemapAlgorithm() {
        }

        @Override
        public boolean isValidSourcePlane(long i) {
            return true;
        }

        @Override
        public void remapPlanePosition(long[] origPlaneDims, long[] origPlanePos, long[] newPlanePos) {
            AxisType axis = Axes.get((String)AddData.this.axisName);
            int axisIndex = AddData.this.dataset.dimensionIndex(axis);
            for (int i = 0; i < origPlanePos.length; ++i) {
                newPlanePos[i] = i != axisIndex - 2 ? origPlanePos[i] : (origPlanePos[i] < AddData.this.position - 1L ? origPlanePos[i] : origPlanePos[i] + AddData.this.quantity);
            }
        }
    }
}

