/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.rotate;

import net.imagej.Dataset;
import net.imagej.Extents;
import net.imagej.Position;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imglib2.RandomAccess;
import net.imglib2.meta.Axes;
import net.imglib2.meta.ImgPlus;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.RealRect;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Transform", mnemonic=116), @Menu(label="Flip Horizontally", weight=1.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class FlipHorizontally
extends ContextCommand {
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private OverlayService overlayService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;

    public void run() {
        Dataset input = this.imageDisplayService.getActiveDataset(this.display);
        RealRect selection = this.overlayService.getSelectionBounds(this.display);
        this.flipPixels(input, selection);
    }

    public void setDisplay(ImageDisplay disp) {
        this.display = disp;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    private void flipPixels(Dataset input, RealRect selection) {
        int xAxis = input.dimensionIndex(Axes.X);
        int yAxis = input.dimensionIndex(Axes.Y);
        if (xAxis < 0 || yAxis < 0) {
            throw new IllegalArgumentException("cannot flip image that does not have XY planes");
        }
        long oX = 0L;
        long oY = 0L;
        long width = input.dimension(xAxis);
        long height = input.dimension(yAxis);
        if (selection.width >= 1.0 && selection.height >= 1.0) {
            oX = (long)selection.x;
            oY = (long)selection.y;
            width = (long)selection.width;
            height = (long)selection.height;
        }
        long[] planeDims = new long[input.numDimensions() - 2];
        int d = 0;
        for (int i = 0; i < input.numDimensions(); ++i) {
            if (i == xAxis || i == yAxis) continue;
            planeDims[d++] = input.dimension(i);
        }
        Position planePos = new Extents(planeDims).createPosition();
        if (input.numDimensions() == 2) {
            this.flipPlane(input, xAxis, yAxis, new long[0], oX, oY, width, height);
        } else {
            long[] planeIndex = new long[planeDims.length];
            while (planePos.hasNext()) {
                planePos.fwd();
                planePos.localize(planeIndex);
                this.flipPlane(input, xAxis, yAxis, planeIndex, oX, oY, width, height);
            }
        }
        input.update();
    }

    private void flipPlane(Dataset input, int xAxis, int yAxis, long[] planeIndex, long oX, long oY, long width, long height) {
        long col1;
        long col2;
        if (height == 1L) {
            return;
        }
        ImgPlus imgPlus = input.getImgPlus();
        RandomAccess acc1 = imgPlus.randomAccess();
        RandomAccess acc2 = imgPlus.randomAccess();
        long[] pos1 = new long[planeIndex.length + 2];
        long[] pos2 = new long[planeIndex.length + 2];
        int d = 0;
        for (int i = 0; i < pos1.length; ++i) {
            if (i == xAxis || i == yAxis) continue;
            pos1[i] = planeIndex[d];
            pos2[i] = planeIndex[d];
            ++d;
        }
        if ((width & 1L) == 0L) {
            col2 = width / 2L;
            col1 = col2 - 1L;
        } else {
            col2 = width / 2L + 1L;
            col1 = col2 - 2L;
        }
        while (col1 >= 0L) {
            pos1[xAxis] = oX + col1;
            pos2[xAxis] = oX + col2;
            long y = oY;
            while (y < oY + height) {
                pos1[yAxis] = y;
                pos2[yAxis] = y++;
                acc1.setPosition(pos1);
                acc2.setPosition(pos2);
                double value1 = ((RealType)acc1.get()).getRealDouble();
                double value2 = ((RealType)acc2.get()).getRealDouble();
                ((RealType)acc1.get()).setReal(value2);
                ((RealType)acc2.get()).setReal(value1);
            }
            --col1;
            ++col2;
        }
    }
}

