/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.rotate;

import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.plugins.commands.imglib.ImgLibDataTransform;
import net.imagej.plugins.commands.rotate.XYFlipper;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.RealRect;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Transform", mnemonic=116), @Menu(label="Rotate 90 Degrees Left", weight=5.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class Rotate90DegreesLeft
extends ContextCommand {
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private OverlayService overlayService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;

    public void run() {
        Dataset input = this.imageDisplayService.getActiveDataset(this.display);
        RealRect bounds = this.overlayService.getSelectionBounds(this.display);
        NinetyLeftTransformer flipTransformer = new NinetyLeftTransformer();
        XYFlipper flipper = new XYFlipper(input, bounds, flipTransformer);
        ImgLibDataTransform runner = new ImgLibDataTransform(input, flipper);
        runner.run();
    }

    public void setDisplay(ImageDisplay disp) {
        this.display = disp;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    private class NinetyLeftTransformer
    implements XYFlipper.FlipCoordinateTransformer {
        @Override
        public void calcOutputPosition(long[] inputDimensions, long[] inputPosition, long[] outputPosition) {
            outputPosition[1] = inputDimensions[0] - inputPosition[0] - 1L;
            outputPosition[0] = inputPosition[1];
            for (int i = 2; i < inputDimensions.length; ++i) {
                outputPosition[i] = inputPosition[i];
            }
        }

        @Override
        public long[] calcOutputDimensions(long[] inputDimensions) {
            long[] outputDims = (long[])inputDimensions.clone();
            outputDims[0] = inputDimensions[1];
            outputDims[1] = inputDimensions[0];
            return outputDims;
        }

        @Override
        public boolean isShapePreserving() {
            return false;
        }
    }
}

