/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign.noisereduce;

import java.util.HashMap;
import java.util.concurrent.Future;
import net.imagej.Dataset;
import net.imagej.plugins.commands.assign.noisereduce.Neighborhood;
import net.imagej.plugins.commands.assign.noisereduce.RadialNeighborhoodSpecifier;
import net.imagej.plugins.commands.assign.noisereduce.RectangularNeighborhoodSpecifier;
import net.imagej.plugins.commands.assign.noisereduce.Reducer;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.meta.ImgPlus;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.function.real.RealImageFunction;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ItemIO;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Parameter;

public abstract class AbstractNoiseReducerPlugin<U extends RealType<U>>
extends ContextCommand {
    private static final String RADIAL_STRING = "Radial (n dimensional)";
    private static final String RECTANGULAR_STRING = "Rectangular (2 dimensional)";
    @Parameter
    protected CommandService commandService;
    @Parameter
    protected Dataset input;
    @Parameter(label="Neighborhood type", choices={"Radial (n dimensional)", "Rectangular (2 dimensional)"})
    protected String neighTypeString = "Radial (n dimensional)";
    @Parameter(type=ItemIO.OUTPUT)
    protected Dataset output;
    private NeighborhoodType neighType;
    private String cancelReason;
    private Neighborhood userProvidedNeighborhood = null;

    public abstract Function<PointSet, DoubleType> getFunction(Function<long[], DoubleType> var1);

    public void run() {
        Neighborhood neighborhood = this.determineNeighborhood(this.input.numDimensions());
        if (neighborhood == null) {
            return;
        }
        ImgPlus inputImg = this.input.getImgPlus();
        OutOfBoundsMirrorFactory oobFactory = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.DOUBLE);
        RealImageFunction otherFunc = new RealImageFunction((RandomAccessibleInterval)inputImg, (OutOfBoundsFactory)oobFactory, (RealType)new DoubleType());
        PointSet ps = neighborhood.getPoints();
        Reducer reducer = new Reducer(this.getContext(), inputImg, this.getFunction((Function<long[], DoubleType>)otherFunc), ps);
        this.output = reducer.reduceNoise(neighborhood.getDescription());
    }

    public void setInput(Dataset ds) {
        this.input = ds;
    }

    public Dataset getInput() {
        return this.input;
    }

    public Dataset getOutput() {
        return this.output;
    }

    public void setNeighborhood(Neighborhood n) {
        this.userProvidedNeighborhood = n;
    }

    public NeighborhoodType getNeighborhoodType() {
        return this.neighType;
    }

    public void setNeighborhoodType(NeighborhoodType type) {
        this.neighType = type;
        this.setNeighString();
    }

    public boolean isCanceled() {
        return this.cancelReason != null;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    private Neighborhood determineNeighborhood(int numDims) {
        if (this.userProvidedNeighborhood != null) {
            return this.userProvidedNeighborhood;
        }
        this.setNeighType();
        CommandModule module = null;
        try {
            HashMap<String, Integer> inputs = new HashMap<String, Integer>();
            inputs.put("numDims", numDims);
            if (this.neighType == NeighborhoodType.RADIAL) {
                Future futureModule = this.commandService.run(RadialNeighborhoodSpecifier.class, true, inputs);
                module = (CommandModule)futureModule.get();
            } else {
                Future futureModule = this.commandService.run(RectangularNeighborhoodSpecifier.class, true, inputs);
                module = (CommandModule)futureModule.get();
            }
        }
        catch (Exception e) {
            this.cancelReason = e.getMessage();
            return null;
        }
        if (module.isCanceled()) {
            this.cancelReason = "Neighborhood specification cancelled by user";
            return null;
        }
        return (Neighborhood)module.getOutputs().get("neighborhood");
    }

    private void setNeighString() {
        this.neighTypeString = this.neighType == NeighborhoodType.RADIAL ? RADIAL_STRING : RECTANGULAR_STRING;
    }

    private void setNeighType() {
        this.neighType = this.neighTypeString.equals(RADIAL_STRING) ? NeighborhoodType.RADIAL : NeighborhoodType.RECTANGULAR;
    }

    public static enum NeighborhoodType {
        RADIAL,
        RECTANGULAR;

    }
}

