/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign.noisereduce;

import net.imagej.Dataset;
import net.imagej.DefaultDataset;
import net.imglib2.RandomAccessible;
import net.imglib2.meta.ImgPlus;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.img.SerialImageAssignment;
import net.imglib2.ops.input.InputIterator;
import net.imglib2.ops.input.PointSetInputIterator;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.type.numeric.RealType;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.plugin.Parameter;

public class Reducer<U extends RealType<U>, V extends RealType<V>> {
    private final Context context;
    private final Function<PointSet, V> inputFunction;
    private final PointSet neighborhood;
    private final ImgPlus<U> input;
    @Parameter(required=false)
    private StatusService statusService;

    public Reducer(Context context, ImgPlus<U> input, Function<PointSet, V> func, PointSet neighborhood) {
        this.context = context;
        context.inject((Object)this);
        this.input = input;
        this.inputFunction = func;
        this.neighborhood = neighborhood;
    }

    public Dataset reduceNoise(String neighDescrip) {
        this.notifyUserAtStart(neighDescrip);
        ImgPlus newImg = this.input.copy();
        long[] dims = new long[newImg.numDimensions()];
        newImg.dimensions(dims);
        HyperVolumePointSet space = new HyperVolumePointSet(dims);
        PointSetInputIterator inputIterator = new PointSetInputIterator((PointSet)space, this.neighborhood);
        long[] outputOrigin = new long[this.input.numDimensions()];
        long[] outputSpan = (long[])outputOrigin.clone();
        this.input.dimensions(outputSpan);
        SerialImageAssignment assigner = new SerialImageAssignment((RandomAccessible)newImg, this.inputFunction, (InputIterator)inputIterator, null);
        assigner.assign();
        this.notifyUserAtEnd(neighDescrip);
        return new DefaultDataset(this.context, newImg);
    }

    private void notifyUserAtStart(String neighDescrip) {
        if (this.statusService != null) {
            this.statusService.showStatus(neighDescrip + " ... beginning processing");
        }
    }

    private void notifyUserAtEnd(String neighDescrip) {
        if (this.statusService != null) {
            this.statusService.showStatus(neighDescrip + " ... completed processing");
        }
    }
}

