/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.correlate;

import net.imagej.Dataset;
import net.imagej.plugins.commands.neigh.Neighborhood3x3Operation;
import net.imagej.plugins.commands.neigh.Neighborhood3x3Watcher;
import org.scijava.util.RealRect;

public class Correlation3x3Operation {
    private final double[] kernel;
    private final Neighborhood3x3Operation neighOperation;

    public Correlation3x3Operation(Dataset input, RealRect selection, double[] kernel) {
        this.kernel = kernel;
        this.neighOperation = new Neighborhood3x3Operation(input, selection, new CorrelateWatcher(input));
        if (kernel.length != 9) {
            throw new IllegalArgumentException("kernel must contain nine elements (shaped 3x3)");
        }
    }

    public void run() {
        this.neighOperation.run();
    }

    private class CorrelateWatcher
    implements Neighborhood3x3Watcher {
        private double scale;
        private double sum;
        private final boolean integerDataset;
        private final double typeMinValue;
        private final double typeMaxValue;

        public CorrelateWatcher(Dataset ds) {
            this.integerDataset = ds.isInteger();
            this.typeMinValue = ds.getType().getMinValue();
            this.typeMaxValue = ds.getType().getMaxValue();
        }

        @Override
        public void setup() {
            this.scale = 0.0;
            for (int i = 0; i < Correlation3x3Operation.this.kernel.length; ++i) {
                this.scale += Correlation3x3Operation.this.kernel[i];
            }
            if (this.scale == 0.0) {
                this.scale = 1.0;
            }
        }

        @Override
        public void initializeNeighborhood(long[] position) {
            this.sum = 0.0;
        }

        @Override
        public void visitLocation(int dx, int dy, double value) {
            int index = (dy + 1) * 3 + (dx + 1);
            this.sum += value * Correlation3x3Operation.this.kernel[index];
        }

        @Override
        public double calcOutputValue() {
            double value;
            if (this.integerDataset) {
                value = (this.sum + this.scale / 2.0) / this.scale;
                if (value < this.typeMinValue) {
                    value = this.typeMinValue;
                }
                if (value > this.typeMaxValue) {
                    value = this.typeMaxValue;
                }
            } else {
                value = this.sum / this.scale;
            }
            return value;
        }
    }
}

