/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.io;

import io.scif.config.SCIFIOConfig;
import io.scif.img.ImageRegion;
import io.scif.img.Range;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.log.LogService;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, menu={@Menu(label="File", weight=0.0), @Menu(label="Import"), @Menu(label="Image... ")})
public class OpenDataset
extends ContextCommand {
    private static final int MAX_HEADER = 55;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private LogService logService;
    @Parameter
    private UIService uiService;
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false, required=false, initializer="setHeader")
    private String header;
    @Parameter(label="File to open")
    private File source;
    @Parameter(required=false)
    private Boolean crop;
    @Parameter(required=false, min="0")
    private Integer x = 0;
    @Parameter(required=false, min="0")
    private Integer y = 0;
    @Parameter(required=false, min="0")
    private Integer w = 0;
    @Parameter(required=false, min="0")
    private Integer h = 0;
    @Parameter(required=false, label="Image indices")
    private String range;
    @Parameter(required=false, label="Group similar files")
    private Boolean groupFiles;
    @Parameter(type=ItemIO.OUTPUT)
    private Dataset dataset;

    public void run() {
        SCIFIOConfig config = new SCIFIOConfig();
        if (this.range != null && !this.range.isEmpty()) {
            try {
                config.imgOpenerSetRange(this.range);
            }
            catch (IllegalArgumentException e) {
                this.logService.warn((Object)("Ignoring bad range: " + this.range));
            }
        }
        if (this.crop != null && this.crop.booleanValue()) {
            if (this.validRange(this.x, this.y, this.w, this.h)) {
                HashMap<AxisType, Range> region = new HashMap<AxisType, Range>();
                region.put(Axes.X, new Range(new Long(this.x.intValue()), new Long(this.w.intValue())));
                region.put(Axes.Y, new Range(new Long(this.y.intValue()), new Long(this.h.intValue())));
                config.imgOpenerSetRegion(new ImageRegion(region));
            } else {
                this.logService.warn((Object)("ignoring bad crop region: " + this.x + ", " + this.y + ", " + this.w + ", " + this.h));
            }
        }
        if (this.groupFiles != null) {
            config.groupableSetGroupFiles(this.groupFiles.booleanValue());
        }
        try {
            this.dataset = this.datasetService.open(this.source.getAbsolutePath(), (Object)config);
        }
        catch (IOException e) {
            this.logService.error((Throwable)e);
            this.error(e.getMessage());
        }
    }

    private boolean validRange(Integer x, Integer y, Integer w, Integer h) {
        return x != null && y != null && w != null && h != null && x >= 0 && y >= 0 && w >= 0 && h >= 0;
    }

    private void setHeader() {
        if (this.source != null) {
            String id = this.source.getAbsolutePath();
            this.header = this.source.length() > 55L ? "..." + id.substring(id.length() - 52) : id;
        }
    }

    private void error(String message) {
        this.uiService.showDialog(message, DialogPrompt.MessageType.ERROR_MESSAGE);
    }
}

