/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.restructure;

import java.util.ArrayList;
import net.imagej.Dataset;
import net.imagej.plugins.commands.restructure.ColorTableRemapper;
import net.imagej.plugins.commands.restructure.RestructureUtils;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.meta.ImgPlus;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Axes", mnemonic=97), @Menu(label="Add Axis...")}, headless=true, initializer="initAll", attrs={@Attr(name="no-legacy")})
public class AddAxis
extends DynamicCommand {
    private static final String AXIS_NAME = "axisName";
    private static final String AXIS_SIZE = "axisSize";
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    @Parameter(label="Axis to add", persist=false)
    private String axisName;
    @Parameter(label="Axis size", persist=false)
    private long axisSize = 2L;

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public AxisType getAxis() {
        return Axes.get((String)this.axisName);
    }

    public void setAxis(AxisType axis) {
        this.axisName = axis.toString();
    }

    public long getAxisSize() {
        return this.axisSize;
    }

    public void setAxisSize(long axisSize) {
        this.axisSize = axisSize;
    }

    public void run() {
        AxisType axis = Axes.get((String)this.axisName);
        if (this.inputBad(axis)) {
            return;
        }
        AxisType[] newAxes = this.getNewAxes(this.dataset, axis);
        long[] newDimensions = this.getNewDimensions(this.dataset, this.axisSize);
        ImgPlus<? extends RealType<?>> dstImgPlus = RestructureUtils.createNewImgPlus(this.dataset, newDimensions, newAxes);
        this.fillNewImgPlus(this.dataset.getImgPlus(), dstImgPlus);
        dstImgPlus.setCompositeChannelCount(this.dataset.getCompositeChannelCount());
        RestructureUtils.allocateColorTables(dstImgPlus);
        ColorTableRemapper remapper = new ColorTableRemapper(new RemapAlgorithm());
        remapper.remapColorTables(this.dataset.getImgPlus(), dstImgPlus);
        this.dataset.setImgPlus(dstImgPlus);
    }

    protected void initAll() {
        this.initAxisName();
        this.initAxisSize();
    }

    private boolean inputBad(AxisType axis) {
        if (axis == null) {
            this.cancel("Axis must not be null.");
            return true;
        }
        int axisIndex = this.dataset.dimensionIndex(axis);
        if (axisIndex >= 0) {
            this.cancel("Axis " + axis.getLabel() + " already present in dataset.");
            return true;
        }
        if (this.axisSize <= 0L) {
            this.cancel("Axis size invalid: " + this.axisSize);
            return true;
        }
        return false;
    }

    private AxisType[] getNewAxes(Dataset ds, AxisType axis) {
        AxisType[] newAxes = new AxisType[ds.numDimensions() + 1];
        for (int i = 0; i < ds.numDimensions(); ++i) {
            newAxes[i] = ((CalibratedAxis)ds.axis(i)).type();
        }
        newAxes[newAxes.length - 1] = axis;
        return newAxes;
    }

    private long[] getNewDimensions(Dataset ds, long lastDimensionSize) {
        long[] newDims = new long[ds.numDimensions() + 1];
        for (int d = 0; d < ds.numDimensions(); ++d) {
            newDims[d] = ds.dimension(d);
        }
        newDims[newDims.length - 1] = lastDimensionSize;
        return newDims;
    }

    private void fillNewImgPlus(ImgPlus<? extends RealType<?>> srcImgPlus, ImgPlus<? extends RealType<?>> dstImgPlus) {
        long[] srcOrigin = new long[srcImgPlus.numDimensions()];
        long[] dstOrigin = new long[dstImgPlus.numDimensions()];
        long[] srcSpan = new long[srcOrigin.length];
        long[] dstSpan = new long[dstOrigin.length];
        srcImgPlus.dimensions(srcSpan);
        dstImgPlus.dimensions(dstSpan);
        dstSpan[dstSpan.length - 1] = 1L;
        RestructureUtils.copyHyperVolume(srcImgPlus, srcOrigin, srcSpan, dstImgPlus, dstOrigin, dstSpan);
    }

    private void initAxisName() {
        MutableModuleItem axisNameItem = this.getInfo().getMutableInput(AXIS_NAME, String.class);
        ArrayList<String> choices = new ArrayList<String>();
        for (AxisType axis : Axes.knownTypes()) {
            if (axis.isXY() || this.getDataset().dimensionIndex(axis) >= 0) continue;
            choices.add(axis.getLabel());
        }
        axisNameItem.setChoices(choices);
    }

    private void initAxisSize() {
        MutableModuleItem axisSizeModuleItem = this.getInfo().getMutableInput(AXIS_SIZE, Long.class);
        axisSizeModuleItem.setMinimumValue((Object)2L);
    }

    private class RemapAlgorithm
    implements ColorTableRemapper.RemapAlgorithm {
        private RemapAlgorithm() {
        }

        @Override
        public boolean isValidSourcePlane(long i) {
            return true;
        }

        @Override
        public void remapPlanePosition(long[] origPlaneDims, long[] origPlanePos, long[] newPlanePos) {
            for (int i = 0; i < origPlaneDims.length; ++i) {
                newPlanePos[i] = origPlanePos[i];
            }
            newPlanePos[newPlanePos.length - 1] = 0L;
        }
    }
}

