/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.restructure;

import java.util.ArrayList;
import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import net.imagej.plugins.commands.restructure.ColorTableRemapper;
import net.imagej.plugins.commands.restructure.RestructureUtils;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedAxis;
import net.imglib2.meta.ImgPlus;
import net.imglib2.meta.SpaceUtils;
import net.imglib2.meta.TypedSpace;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Axes", mnemonic=97), @Menu(label="Delete Axis...")}, headless=true, initializer="initAll", attrs={@Attr(name="no-legacy")})
public class DeleteAxis
extends DynamicCommand {
    private static final String AXIS_NAME = "axisName";
    private static final String POSITION = "position";
    @Parameter
    private ImageDisplay display;
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    @Parameter(label="Axis to delete", persist=false, callback="axisChanged")
    private String axisName;
    @Parameter(label="Index of hyperplane to keep", persist=false, callback="positionChanged")
    private long position;
    private int axisIndex;

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public AxisType getAxis() {
        return Axes.get((String)this.axisName);
    }

    public void setAxis(AxisType axis) {
        this.axisName = axis.toString();
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public void run() {
        AxisType axis = this.getAxis();
        if (this.inputBad(axis)) {
            return;
        }
        AxisType[] newAxes = this.getNewAxes(this.dataset, axis);
        long[] newDimensions = this.getNewDimensions(this.dataset, axis);
        ImgPlus<? extends RealType<?>> dstImgPlus = RestructureUtils.createNewImgPlus(this.dataset, newDimensions, newAxes);
        int compositeCount = this.compositeStatus(this.dataset.getCompositeChannelCount(), dstImgPlus);
        this.fillNewImgPlus(this.dataset.getImgPlus(), dstImgPlus);
        dstImgPlus.setCompositeChannelCount(compositeCount);
        RestructureUtils.allocateColorTables(dstImgPlus);
        if (axis.isXY()) {
            RestructureUtils.copyColorTables(this.dataset.getImgPlus(), dstImgPlus);
        } else {
            long[] origPlaneDims = new long[this.dataset.numDimensions() - 2];
            for (int d = 0; d < origPlaneDims.length; ++d) {
                origPlaneDims[d] = this.dataset.dimension(d + 2);
            }
            ColorTableRemapper remapper = new ColorTableRemapper(new RemapAlgorithm(origPlaneDims));
            remapper.remapColorTables(this.dataset.getImgPlus(), dstImgPlus);
        }
        this.dataset.setImgPlus(dstImgPlus);
    }

    protected void initAll() {
        this.initAxisName();
        this.initPosition();
    }

    protected void axisChanged() {
        AxisType axis = Axes.get((String)this.axisName);
        long value = this.display.getLongPosition(axis) + 1L;
        long max = this.currDimLen();
        this.initPositionRange(1L, max);
        this.setPosition(value);
        this.clampPosition();
    }

    protected void positionChanged() {
        this.clampPosition();
    }

    private boolean inputBad(AxisType axis) {
        if (axis == null) {
            this.cancel("Axis must not be null.");
            return true;
        }
        this.axisIndex = this.dataset.dimensionIndex(axis);
        if (this.axisIndex < 0) {
            this.cancel("Axis " + axis.getLabel() + " is not present in input dataset.");
            return true;
        }
        long axisSize = this.dataset.getImgPlus().dimension(this.axisIndex);
        if (this.position < 1L || this.position > axisSize) {
            this.cancel("Position of plane to keep is out of bounds.");
            return true;
        }
        return false;
    }

    private AxisType[] getNewAxes(Dataset ds, AxisType axis) {
        AxisType[] origAxes = SpaceUtils.getAxisTypes((TypedSpace)ds);
        if (axis.isXY()) {
            return origAxes;
        }
        AxisType[] newAxes = new AxisType[origAxes.length - 1];
        int index = 0;
        for (AxisType a : origAxes) {
            if (a == axis) continue;
            newAxes[index++] = a;
        }
        return newAxes;
    }

    private long[] getNewDimensions(Dataset ds, AxisType axis) {
        if (axis.isXY()) {
            long[] newDims = new long[ds.numDimensions()];
            int dimIndex = ds.dimensionIndex(axis);
            for (int d = 0; d < newDims.length; ++d) {
                newDims[d] = d == dimIndex ? 1L : ds.dimension(d);
            }
            return newDims;
        }
        long[] newDims = new long[ds.numDimensions() - 1];
        int index = 0;
        for (int d = 0; d < ds.numDimensions(); ++d) {
            AxisType a = ((CalibratedAxis)ds.axis(d)).type();
            if (a == axis) continue;
            newDims[index++] = ds.dimension(d);
        }
        return newDims;
    }

    private void fillNewImgPlus(ImgPlus<? extends RealType<?>> srcImgPlus, ImgPlus<? extends RealType<?>> dstImgPlus) {
        long[] srcOrigin = new long[srcImgPlus.numDimensions()];
        long[] dstOrigin = new long[dstImgPlus.numDimensions()];
        long[] srcSpan = new long[srcOrigin.length];
        long[] dstSpan = new long[dstOrigin.length];
        srcImgPlus.dimensions(srcSpan);
        dstImgPlus.dimensions(dstSpan);
        srcOrigin[this.axisIndex] = this.position - 1L;
        srcSpan[this.axisIndex] = 1L;
        RestructureUtils.copyHyperVolume(srcImgPlus, srcOrigin, srcSpan, dstImgPlus, dstOrigin, dstSpan);
    }

    private int compositeStatus(int compositeCount, ImgPlus<?> output) {
        if (output.dimensionIndex(Axes.CHANNEL) < 0) {
            return 1;
        }
        return compositeCount;
    }

    private void initAxisName() {
        MutableModuleItem axisNameItem = this.getInfo().getMutableInput(AXIS_NAME, String.class);
        Dataset ds = this.getDataset();
        ArrayList<String> choices = new ArrayList<String>();
        for (int i = 0; i < ds.numDimensions(); ++i) {
            AxisType axisType = ((CalibratedAxis)ds.axis(i)).type();
            choices.add(axisType.getLabel());
        }
        axisNameItem.setChoices(choices);
    }

    private void initPosition() {
        long max = this.getDataset().dimension(0);
        AxisType axis = ((CalibratedAxis)this.getDataset().axis(0)).type();
        long value = this.display.getLongPosition(axis) + 1L;
        this.initPositionRange(1L, max);
        this.setPosition(value);
    }

    private void initPositionRange(long min, long max) {
        MutableModuleItem positionItem = this.getInfo().getMutableInput(POSITION, Long.class);
        positionItem.setMinimumValue((Object)min);
    }

    private void clampPosition() {
        long max = this.currDimLen();
        long pos = this.getPosition();
        if (pos < 1L) {
            this.setPosition(1L);
        } else if (pos > max) {
            this.setPosition(max);
        }
    }

    private long currDimLen() {
        AxisType axis = this.getAxis();
        int index = this.getDataset().dimensionIndex(axis);
        return this.getDataset().getImgPlus().dimension(index);
    }

    private class RemapAlgorithm
    implements ColorTableRemapper.RemapAlgorithm {
        private final long[] origPlaneDims;
        private final long[] srcPlanePos;

        public RemapAlgorithm(long[] origPlaneDims) {
            this.origPlaneDims = origPlaneDims;
            this.srcPlanePos = new long[origPlaneDims.length];
        }

        @Override
        public boolean isValidSourcePlane(long i) {
            ColorTableRemapper.toND(this.origPlaneDims, i, this.srcPlanePos);
            return this.srcPlanePos[DeleteAxis.this.axisIndex - 2] == DeleteAxis.this.position - 1L;
        }

        @Override
        public void remapPlanePosition(long[] planeDims, long[] origPlanePos, long[] newPlanePos) {
            int curr = 0;
            for (int i = 0; i < planeDims.length; ++i) {
                if (i == DeleteAxis.this.axisIndex - 2) continue;
                newPlanePos[curr++] = origPlanePos[i];
            }
        }
    }
}

