/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.io;

import io.scif.services.DatasetIOService;
import java.util.ArrayList;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.types.DataType;
import net.imagej.types.DataTypeService;
import net.imglib2.Cursor;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.DefaultMutableModuleItem;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, label="New Image...", iconPath="/icons/commands/picture.png", initializer="init", menu={@Menu(label="File", weight=0.0, mnemonic=102), @Menu(label="New", mnemonic=110), @Menu(label="Image...", weight=0.0, mnemonic=105, accelerator="^N")}, attrs={@Attr(name="no-legacy")})
public class NewImage<U extends RealType<U> & NativeType<U>>
extends DynamicCommand {
    private static final AxisType[] defaultAxes = new AxisType[]{Axes.X, Axes.Y, Axes.CHANNEL, Axes.Z, Axes.TIME};
    public static final String MAX = "Max";
    public static final String MIN = "Min";
    public static final String ZERO = "Zero";
    public static final String RAMP = "Ramp";
    private static final String DEFAULT_NAME = "Untitled";
    @Parameter
    private DatasetIOService datasetIOService;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private DataTypeService dataTypeService;
    @Parameter
    private String name = "Untitled";
    @Parameter(label="Type", initializer="initType")
    private String typeName;
    @Parameter(label="Fill With", choices={"Max", "Min", "Zero", "Ramp"})
    private String fillType = "Max";
    @Parameter(type=ItemIO.OUTPUT)
    private Dataset dataset;
    private long[] dimensions = new long[defaultAxes.length];

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFillType() {
        return this.fillType;
    }

    public void setDataType(DataType<?> dataType) {
        String tname = dataType.longName();
        if (this.dataTypeService.getTypeByName(tname) == null) {
            throw new IllegalArgumentException("unknown data type [" + tname + "]");
        }
        this.typeName = tname;
    }

    public DataType<?> getDataType() {
        return this.dataTypeService.getTypeByName(this.typeName);
    }

    public void setFillType(String fillType) {
        if (MIN.toString().equalsIgnoreCase(fillType)) {
            this.fillType = MIN;
        } else if (MAX.toString().equalsIgnoreCase(fillType)) {
            this.fillType = MAX;
        } else if (RAMP.toString().equalsIgnoreCase(fillType)) {
            this.fillType = RAMP;
        } else if (ZERO.toString().equalsIgnoreCase(fillType)) {
            this.fillType = ZERO;
        } else {
            throw new IllegalArgumentException("please specify fill type as one of Min, Max, Ramp, or Zero");
        }
    }

    public long getDimension(AxisType axisType) {
        for (int i = 0; i < defaultAxes.length; ++i) {
            if (!defaultAxes[i].equals(axisType)) continue;
            return this.dimensions[i];
        }
        return 0L;
    }

    public void setDimension(AxisType axisType, long size) {
        long min = axisType.isXY() ? 1L : 0L;
        if (size < min) {
            throw new IllegalArgumentException("axis " + axisType + " dimension must be >= " + min);
        }
        for (int i = 0; i < defaultAxes.length; ++i) {
            if (!defaultAxes[i].equals(axisType)) continue;
            this.dimensions[i] = size;
        }
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void run() {
        AxisType[] axes;
        long[] dims;
        this.fillProvidedDimensions();
        if (this.name == null || this.name.trim().length() == 0) {
            this.name = DEFAULT_NAME;
        }
        if (this.badSpecification(dims = this.getActualDims(), axes = this.getActualAxes())) {
            this.dataset = null;
            return;
        }
        DataType<?> dataType = this.getDataType();
        RealType variable = (RealType)dataType.createVariable();
        this.dataset = this.datasetService.create(variable, dims, this.name, axes);
        long[] pos = new long[2];
        Cursor cursor = this.dataset.getImgPlus().localizingCursor();
        boolean isMax = this.fillType.equals(MAX) && dataType.isBounded();
        boolean isMin = this.fillType.equals(MIN) && dataType.isBounded();
        boolean isZero = this.fillType.equals(ZERO);
        boolean isRamp = this.fillType.equals(RAMP);
        if (!(isMax || isMin || isZero || isRamp)) {
            isZero = true;
        }
        RealType val = (RealType)dataType.createVariable();
        RealType min = (RealType)dataType.createVariable();
        RealType max = (RealType)dataType.createVariable();
        if (!dataType.isBounded()) {
            isRamp = false;
            val.setZero();
        } else if (isMax) {
            dataType.upperBound((NumericType)max);
            val.set((Type)max);
        } else if (isMin) {
            dataType.lowerBound((NumericType)min);
            val.set((Type)min);
        } else if (isZero) {
            val.setZero();
        } else {
            dataType.upperBound((NumericType)max);
            dataType.lowerBound((NumericType)min);
        }
        ComplexDoubleType tmp = new ComplexDoubleType();
        while (cursor.hasNext()) {
            cursor.fwd();
            if (!isRamp) {
                ((RealType)cursor.get()).set((Type)val);
                continue;
            }
            pos[0] = cursor.getLongPosition(0);
            pos[1] = cursor.getLongPosition(1);
            this.rampedValue(pos, dims, dataType, min, max, tmp);
            ((RealType)cursor.get()).setComplexNumber(tmp.getRealDouble(), tmp.getImaginaryDouble());
        }
    }

    protected void init() {
        for (AxisType axisType : defaultAxes) {
            DefaultMutableModuleItem axisItem = new DefaultMutableModuleItem((Module)this, axisType.getLabel(), Long.class);
            long min = axisType.isXY() ? 1L : 0L;
            axisItem.setValue((Module)this, (Object)min);
            axisItem.setMinimumValue((Object)min);
            this.addInput((ModuleItem)axisItem);
        }
    }

    protected void initType() {
        MutableModuleItem input = this.getInfo().getMutableInput("typeName", String.class);
        ArrayList<String> choices = new ArrayList<String>();
        for (DataType dataType : this.dataTypeService.getInstances()) {
            choices.add(dataType.longName());
        }
        input.setChoices(choices);
        input.setValue((Module)this, choices.get(0));
    }

    private void rampedValue(long[] pos, long[] dims, DataType<U> type, U min, U max, ComplexDoubleType outValue) {
        double origin = min.getRealDouble();
        double range = max.getRealDouble() - min.getRealDouble();
        if (type.isFloat()) {
            origin = 0.0;
            range = 1.0;
        }
        double numerator = 0.0;
        double denominator = 0.0;
        for (int i = 0; i < pos.length; ++i) {
            numerator += (double)pos[i];
            denominator += (double)(dims[i] - 1L);
        }
        if (denominator == 0.0) {
            outValue.setReal(origin);
            outValue.setImaginary(origin);
            return;
        }
        double percent = numerator / denominator;
        double val = origin + percent * range;
        outValue.setReal(val);
        outValue.setImaginary(val);
    }

    private long[] getActualDims() {
        int numSpecified = 0;
        for (int i = 0; i < this.dimensions.length; ++i) {
            long dim = this.dimensions[i];
            if (dim <= 1L && (dim != 1L || !defaultAxes[i].isXY())) continue;
            ++numSpecified;
        }
        long[] dims = new long[numSpecified];
        int d = 0;
        for (int i = 0; i < this.dimensions.length; ++i) {
            long dim = this.dimensions[i];
            if (dim <= 1L && (dim != 1L || !defaultAxes[i].isXY())) continue;
            dims[d++] = dim;
        }
        return dims;
    }

    private AxisType[] getActualAxes() {
        int numSpecified = 0;
        for (int i = 0; i < this.dimensions.length; ++i) {
            long dim = this.dimensions[i];
            if (dim <= 1L && (dim != 1L || !defaultAxes[i].isXY())) continue;
            ++numSpecified;
        }
        AxisType[] axes = new AxisType[numSpecified];
        int d = 0;
        for (int i = 0; i < this.dimensions.length; ++i) {
            long dim = this.dimensions[i];
            if (dim <= 1L && (dim != 1L || !defaultAxes[i].isXY())) continue;
            axes[d++] = defaultAxes[i];
        }
        return axes;
    }

    private boolean badSpecification(long[] dims, AxisType[] axes) {
        boolean hasX = false;
        boolean hasY = false;
        for (int i = 0; i < dims.length; ++i) {
            int smallestAllowed;
            AxisType axisType = axes[i];
            hasX |= axisType.equals(Axes.X);
            hasY |= axisType.equals(Axes.Y);
            int n = smallestAllowed = axisType.isXY() ? 1 : 2;
            if (dims[i] >= (long)smallestAllowed) continue;
            this.cancel("New image: dimension size must be >= " + smallestAllowed + " for axis " + axisType);
            return true;
        }
        if (!hasX || !hasY) {
            this.cancel("New image: images require both X and Y axes to be present.");
            return true;
        }
        return false;
    }

    private void fillProvidedDimensions() {
        for (int i = 0; i < defaultAxes.length; ++i) {
            long size;
            AxisType axisType = defaultAxes[i];
            Object input = this.getInput(axisType.getLabel());
            if (input == null) continue;
            this.dimensions[i] = size = ((Long)input).longValue();
        }
    }
}

