/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.restructure;

import java.util.ArrayList;
import net.imagej.Dataset;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.display.ColorTable;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.DefaultMutableModuleItem;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, initializer="initAxes", menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Transform", mnemonic=116), @Menu(label="Flip Axis", weight=3.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class FlipAxis
extends DynamicCommand {
    private static final String AXIS = "axis";
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    private AxisType axisType = null;
    private int d;

    public void run() {
        String err = this.checkInput();
        if (err != null) {
            this.cancel(err);
        } else {
            this.swapData();
        }
    }

    public void setDataset(Dataset ds) {
        this.dataset = ds;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setAxis(AxisType axisType) {
        this.axisType = axisType;
    }

    public AxisType getAxis() {
        if (this.axisType != null) {
            return this.axisType;
        }
        String name = (String)this.getInput(AXIS);
        for (int i = 0; i < this.dataset.numDimensions(); ++i) {
            AxisType type = ((CalibratedAxis)this.dataset.axis(i)).type();
            if (!type.getLabel().equals(name)) continue;
            return type;
        }
        return null;
    }

    protected void initAxes() {
        ArrayList<String> choices = new ArrayList<String>();
        for (int i = 0; i < this.dataset.numDimensions(); ++i) {
            AxisType type = ((CalibratedAxis)this.dataset.axis(i)).type();
            choices.add(type.getLabel());
        }
        DefaultMutableModuleItem axisItem = new DefaultMutableModuleItem((Module)this, AXIS, String.class);
        axisItem.setChoices(choices);
        axisItem.setPersisted(false);
        axisItem.setValue((Module)this, (Object)((CalibratedAxis)this.dataset.axis(0)).type().getLabel());
        this.addInput((ModuleItem)axisItem);
    }

    private String checkInput() {
        if (this.dataset == null) {
            return "Dataset is null.";
        }
        this.axisType = this.getAxis();
        if (this.axisType == null) {
            return "Axis is null.";
        }
        this.d = this.dataset.dimensionIndex(this.axisType);
        if (this.d < 0) {
            return this.axisType + " axis is not present in dataset.";
        }
        if (this.dataset.dimension(this.d) == 1L) {
            return this.axisType + " axis is a single plane.";
        }
        return null;
    }

    private void newSwapDataBroken() {
        long[] min = new long[this.dataset.numDimensions()];
        long[] max = new long[this.dataset.numDimensions()];
        for (int i = 0; i < max.length; ++i) {
            max[i] = this.dataset.dimension(i) - 1L;
        }
        max[this.d] = this.dataset.dimension(this.d) / 2L - 1L;
        IntervalView halfForw = Views.interval((RandomAccessible)this.dataset.getImgPlus(), (long[])min, (long[])max);
        IntervalView invertedView = Views.invertAxis((RandomAccessibleInterval)this.dataset.getImgPlus(), (int)this.d);
        IntervalView halfBack = Views.interval((RandomAccessible)invertedView, (long[])((long[])min.clone()), (long[])((long[])max.clone()));
        IterableInterval dataForw = Views.iterable((RandomAccessibleInterval)halfForw);
        Cursor forw = dataForw.cursor();
        RandomAccess back = halfBack.randomAccess();
        while (forw.hasNext()) {
            forw.fwd();
            back.setPosition((Localizable)forw);
            double orig = ((RealType)forw.get()).getRealDouble();
            ((RealType)forw.get()).setReal(((RealType)back.get()).getRealDouble());
            ((RealType)back.get()).setReal(orig);
        }
    }

    private void swapData() {
        long lo = 0L;
        for (long hi = this.dataset.dimension(this.d) - 1L; lo < hi; ++lo, --hi) {
            this.swapChunk(lo, hi);
        }
        this.swapColorTables();
    }

    private void swapChunk(long pos1, long pos2) {
        long[] min = new long[this.dataset.numDimensions()];
        long[] max = new long[this.dataset.numDimensions()];
        for (int i = 0; i < max.length; ++i) {
            max[i] = this.dataset.dimension(i) - 1L;
        }
        min[this.d] = pos1;
        max[this.d] = pos1;
        ImgPlus img = this.dataset.getImgPlus();
        IntervalView view = Views.interval((RandomAccessible)img, (long[])min, (long[])max);
        IterableInterval data = Views.iterable((RandomAccessibleInterval)view);
        Cursor cursor = data.cursor();
        RandomAccess accessor = img.randomAccess();
        while (cursor.hasNext()) {
            cursor.fwd();
            double orig = ((RealType)cursor.get()).getRealDouble();
            accessor.setPosition((Localizable)cursor);
            accessor.setPosition(pos2, this.d);
            ((RealType)cursor.get()).setReal(((RealType)accessor.get()).getRealDouble());
            ((RealType)accessor.get()).setReal(orig);
        }
    }

    private void swapColorTables() {
        if (this.axisType == Axes.X || this.axisType == Axes.Y) {
            return;
        }
        long numPlanes = this.numPlanes(this.dataset);
        if ((long)this.dataset.getColorTableCount() != numPlanes) {
            return;
        }
        int i = 0;
        while ((long)i < numPlanes / 2L - 1L) {
            int partner = this.findPartner(i);
            if (partner != i) {
                ColorTable table = this.dataset.getColorTable(i);
                this.dataset.setColorTable(this.dataset.getColorTable(partner), i);
                this.dataset.setColorTable(table, partner);
            }
            ++i;
        }
    }

    private long numPlanes(Dataset ds) {
        long tot = 1L;
        for (int i = 0; i < ds.numDimensions(); ++i) {
            if (((CalibratedAxis)ds.axis(i)).type().isXY()) continue;
            tot *= ds.dimension(i);
        }
        return tot;
    }

    private int findPartner(int i) {
        return i;
    }
}

