/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.app;

import java.util.List;
import net.imagej.table.DefaultGenericTable;
import net.imagej.table.GenericTable;
import org.scijava.ItemIO;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.input.Accelerator;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Plugins", weight=5.0, mnemonic=117), @Menu(label="Shortcuts"), @Menu(label="List Shortcuts...", weight=1.0)}, attrs={@Attr(name="no-legacy")})
public class ListShortcuts
extends ContextCommand {
    @Parameter
    private ModuleService moduleService;
    @Parameter(label="Keyboard Shortcuts", type=ItemIO.OUTPUT)
    private GenericTable shortcuts;

    public void run() {
        List modules = this.moduleService.getModules();
        String hotKeyHeader = "Hot Key";
        String commandHeader = "Command";
        this.shortcuts = new DefaultGenericTable();
        this.shortcuts.appendColumn("Hot Key");
        this.shortcuts.appendColumn("Command");
        int row = 0;
        for (ModuleInfo info : modules) {
            Accelerator shortcut = this.getAccelerator(info);
            if (shortcut == null) continue;
            this.shortcuts.appendRow();
            this.shortcuts.set("Hot Key", row, (Object)shortcut.toString());
            this.shortcuts.set("Command", row, (Object)info.getTitle());
            ++row;
        }
    }

    private Accelerator getAccelerator(ModuleInfo info) {
        MenuPath menuPath = info.getMenuPath();
        if (menuPath == null) {
            return null;
        }
        MenuEntry leaf = menuPath.getLeaf();
        if (leaf == null) {
            return null;
        }
        return leaf.getAccelerator();
    }
}

