/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.display;

import net.imagej.Dataset;
import net.imagej.axis.Axes;
import net.imagej.display.DatasetView;
import net.imglib2.Cursor;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Adjust"), @Menu(label="Auto-Contrast", accelerator="shift alt ^L", weight=0.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class AutoContrast
extends ContextCommand {
    private static final int BINS = 256;
    private static final int AUTO_THRESHOLD = 5000;
    private static int autoThreshold;
    @Parameter(type=ItemIO.BOTH)
    private DatasetView view;

    public void run() {
        double max;
        double min;
        int count;
        Dataset dataset = this.view.getData();
        int[] histogram = this.computeHistogram(dataset);
        int pixelCount = this.countPixels(histogram);
        autoThreshold = autoThreshold < 10 ? 5000 : (autoThreshold /= 2);
        int threshold = pixelCount / autoThreshold;
        int limit = pixelCount / 10;
        int i = -1;
        boolean found = false;
        do {
            if ((count = histogram[++i]) > limit) {
                count = 0;
            }
            boolean bl = found = count > threshold;
        } while (!found && i < 255);
        int hmin = i;
        i = 256;
        do {
            if ((count = histogram[--i]) > limit) {
                count = 0;
            }
            boolean bl = found = count > threshold;
        } while (!found && i > 0);
        int hmax = i;
        double histMin = dataset.getType().getMinValue();
        double histMax = dataset.getType().getMaxValue();
        double binSize = (histMax - histMin) / 255.0;
        if (hmax >= hmin) {
            min = histMin + (double)hmin * binSize;
            max = histMin + (double)hmax * binSize;
        } else {
            double mn = Double.MAX_VALUE;
            double mx = Double.MIN_VALUE;
            for (long ch = 0L; ch < this.getNumChannels(dataset); ++ch) {
                if ((double)ch < mn) {
                    mn = ch;
                }
                if (!((double)ch > mx)) continue;
                mx = ch;
            }
            max = mx;
            min = mn;
            autoThreshold = 5000;
        }
        this.setMinMax(min, max);
    }

    public void setDatasetView(DatasetView view) {
        this.view = view;
    }

    public DatasetView getDatasetView() {
        return this.view;
    }

    private int[] computeHistogram(Dataset dataset) {
        double histMin = dataset.getType().getMinValue();
        double histMax = dataset.getType().getMaxValue();
        Cursor c = dataset.getImgPlus().cursor();
        int[] histogram = new int[256];
        while (c.hasNext()) {
            int bin;
            double value = ((RealType)c.next()).getRealDouble();
            int n = bin = this.computeBin(value, histMin, histMax);
            histogram[n] = histogram[n] + 1;
        }
        return histogram;
    }

    private int computeBin(double value, double histMin, double histMax) {
        double v = value;
        if (v < histMin) {
            v = histMin;
        }
        if (v > histMax) {
            v = histMax;
        }
        int bin = (int)(255.0 * (v - histMin) / (histMax - histMin));
        return bin;
    }

    private int countPixels(int[] histogram) {
        int sum = 0;
        for (int v : histogram) {
            sum += v;
        }
        return sum;
    }

    private void setMinMax(double min, double max) {
        this.view.setChannelRanges(min, max);
        this.view.getProjector().map();
        this.view.update();
    }

    private long getNumChannels(Dataset dataset) {
        int chIdx = dataset.dimensionIndex(Axes.CHANNEL);
        if (chIdx == -1) {
            return 1L;
        }
        return dataset.dimension(chIdx);
    }
}

