/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.neigh;

import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.plugins.commands.neigh.Neighborhood3x3Operation;
import net.imagej.plugins.commands.neigh.Neighborhood3x3Watcher;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.RealRect;

@Plugin(type=Command.class, menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Find Edges", weight=3.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class FindEdges
extends ContextCommand {
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private OverlayService overlayService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;

    public void run() {
        Dataset input = this.imageDisplayService.getActiveDataset(this.display);
        RealRect selection = this.overlayService.getSelectionBounds(this.display);
        Neighborhood3x3Operation operation = new Neighborhood3x3Operation(input, selection, new FindEdgesWatcher(input));
        operation.run();
    }

    public void setDisplay(ImageDisplay disp) {
        this.display = disp;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    private class FindEdgesWatcher
    implements Neighborhood3x3Watcher {
        private double[] n;
        private final boolean integerDataset;
        private final double typeMinValue;
        private final double typeMaxValue;

        public FindEdgesWatcher(Dataset input) {
            this.integerDataset = input.isInteger();
            this.typeMinValue = input.getType().getMinValue();
            this.typeMaxValue = input.getType().getMaxValue();
        }

        @Override
        public void setup() {
            this.n = new double[9];
        }

        @Override
        public void initializeNeighborhood(long[] position) {
        }

        @Override
        public void visitLocation(int dx, int dy, double value) {
            int index = (dy + 1) * 3 + (dx + 1);
            this.n[index] = value;
        }

        @Override
        public double calcOutputValue() {
            double sum1 = this.n[0] + 2.0 * this.n[1] + this.n[2] - this.n[6] - 2.0 * this.n[7] - this.n[8];
            double sum2 = this.n[0] + 2.0 * this.n[3] + this.n[6] - this.n[2] - 2.0 * this.n[5] - this.n[8];
            double value = Math.sqrt(sum1 * sum1 + sum2 * sum2);
            if (this.integerDataset) {
                if (value < this.typeMinValue) {
                    value = this.typeMinValue;
                }
                if (value > this.typeMaxValue) {
                    value = this.typeMaxValue;
                }
            }
            return value;
        }
    }
}

