/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.debug;

import java.util.ArrayList;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayService;
import net.imagej.measure.BasicStats;
import net.imagej.measure.BasicStatsFunction;
import net.imagej.measure.MeasurementService;
import net.imagej.overlay.Overlay;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.function.real.RealAdaptiveMedianFunction;
import net.imglib2.ops.function.real.RealArithmeticMeanFunction;
import net.imglib2.ops.function.real.RealImageFunction;
import net.imglib2.ops.function.real.RealMaxFunction;
import net.imglib2.ops.function.real.RealMedianFunction;
import net.imglib2.ops.function.real.RealMinFunction;
import net.imglib2.ops.function.real.RealPointCountFunction;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.RoiPointSet;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.widget.Button;

@Plugin(type=Command.class, menuPath="Plugins>Sandbox>Measurement Demo", attrs={@Attr(name="no-legacy")})
public class MeasurementDemo
implements Command {
    @Parameter
    private DatasetService dsSrv;
    @Parameter
    private MeasurementService mSrv;
    @Parameter
    private OverlayService oSrv;
    @Parameter
    private StatusService sSrv;
    @Parameter
    private ImageDisplay display;
    @Parameter
    private Dataset dataset;
    @Parameter(label="Measure mean", callback="mean")
    private Button mean;
    @Parameter(label="Measure min", callback="min")
    private Button min;
    @Parameter(label="Measure max", callback="max")
    private Button max;
    @Parameter(label="Measure median", callback="median")
    private Button median;
    @Parameter(label="Measure region size", callback="regionSize")
    private Button regionSize;
    private Function<PointSet, DoubleType> function;
    private String funcName;

    public void run() {
    }

    protected void mean() {
        RealImageFunction imgFunc = this.mSrv.imgFunction(this.dataset, (RealType)new DoubleType());
        this.function = new RealArithmeticMeanFunction((Function)imgFunc);
        this.funcName = "Mean";
        this.calc();
    }

    protected void min() {
        RealImageFunction imgFunc = this.mSrv.imgFunction(this.dataset, (RealType)new DoubleType());
        this.function = new RealMinFunction((Function)imgFunc);
        this.funcName = "Min";
        this.calc();
    }

    protected void max() {
        RealImageFunction imgFunc = this.mSrv.imgFunction(this.dataset, (RealType)new DoubleType());
        this.function = new RealMaxFunction((Function)imgFunc);
        this.funcName = "Max";
        this.calc();
    }

    protected void median() {
        RealImageFunction imgFunc = this.mSrv.imgFunction(this.dataset, (RealType)new DoubleType());
        this.function = new RealMedianFunction((Function)imgFunc);
        this.funcName = "Median";
        this.calc();
    }

    protected void regionSize() {
        this.function = new RealPointCountFunction((RealType)new DoubleType());
        this.funcName = "Region size";
        this.calc();
    }

    private void calc() {
        RoiPointSet points;
        Overlay overlay = this.oSrv.getActiveOverlay(this.display);
        if (overlay != null) {
            points = new RoiPointSet(overlay.getRegionOfInterest());
        } else {
            long[] dims = Intervals.dimensionsAsLongArray((Dimensions)this.display);
            for (int i = 2; i < dims.length; ++i) {
                dims[i] = 1L;
            }
            points = new HyperVolumePointSet(dims);
        }
        DoubleType output = new DoubleType();
        this.mSrv.measure(this.function, (PointSet)points, (Object)output);
        this.sSrv.showStatus(this.funcName + " of selected region is " + output.getRealDouble());
    }

    private <T extends RealType<T>> OutOfBoundsFactory<T, RandomAccessibleInterval<T>> getOobFactory() {
        return new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.DOUBLE);
    }

    private Dataset getTestData() {
        Dataset ds = this.dsSrv.create(new long[]{7L, 7L}, "tmp", new AxisType[]{Axes.X, Axes.Y}, 8, false, false);
        Cursor cursor = ds.getImgPlus().cursor();
        int i = 0;
        while (cursor.hasNext()) {
            ((RealType)cursor.next()).setReal((float)i++);
        }
        return ds;
    }

    private List<PointSet> getNestedNeighborhoods(long delta) {
        long[] zeroOrigin = new long[2];
        long[] tmpNeg = new long[]{delta, delta};
        long[] tmpPos = new long[]{delta, delta};
        ArrayList<PointSet> regions = new ArrayList<PointSet>();
        for (int i = 0; i < 5; ++i) {
            HyperVolumePointSet ps = new HyperVolumePointSet(zeroOrigin, tmpNeg, tmpPos);
            regions.add((PointSet)ps);
            tmpNeg = (long[])tmpNeg.clone();
            tmpPos = (long[])tmpPos.clone();
            tmpNeg[0] = tmpNeg[0] + 1L;
            tmpNeg[1] = tmpNeg[1] + 1L;
            tmpPos[0] = tmpPos[0] + 1L;
            tmpPos[1] = tmpPos[1] + 1L;
        }
        return regions;
    }

    private void example1() {
        Dataset ds = this.getTestData();
        DoubleType output = new DoubleType();
        RealImageFunction imgFunc = this.mSrv.imgFunction(ds, (RealType)output);
        RealArithmeticMeanFunction meanFunc = new RealArithmeticMeanFunction((Function)imgFunc);
        HyperVolumePointSet region = new HyperVolumePointSet(Intervals.dimensionsAsLongArray((Dimensions)ds));
        this.mSrv.measure((Function)meanFunc, (PointSet)region, (Object)output);
        System.out.println("arithmetic mean is " + output.getRealDouble());
    }

    private void example2() {
        Dataset ds = this.getTestData();
        DoubleType output = new DoubleType();
        OutOfBoundsFactory oobFactory = this.getOobFactory();
        RealImageFunction imgFuncWithOOB = new RealImageFunction((RandomAccessibleInterval)ds.getImgPlus(), oobFactory, (RealType)output);
        RealMaxFunction maxFunc = new RealMaxFunction((Function)imgFuncWithOOB);
        HyperVolumePointSet region = new HyperVolumePointSet(Intervals.dimensionsAsLongArray((Dimensions)ds));
        this.mSrv.measure((Function)maxFunc, (PointSet)region, (Object)output);
        System.out.println("max is " + output.getRealDouble());
    }

    private void example3() {
        Dataset ds = this.getTestData();
        DoubleType output = new DoubleType();
        OutOfBoundsFactory oobFactory = this.getOobFactory();
        RealImageFunction imgFuncWithOOB = new RealImageFunction((RandomAccessibleInterval)ds.getImgPlus(), oobFactory, (RealType)output);
        long ctrX = 0L;
        long ctrY = 0L;
        long[] posDeltas = new long[]{3L, 3L};
        long[] negDeltas = new long[]{3L, 3L};
        List<PointSet> pointSets = this.getNestedNeighborhoods(3L);
        RealAdaptiveMedianFunction adapMedFunc = new RealAdaptiveMedianFunction((Function)imgFuncWithOOB, pointSets);
        HyperVolumePointSet region = new HyperVolumePointSet(new long[]{ctrX, ctrY}, negDeltas, posDeltas);
        this.mSrv.measure((Function)adapMedFunc, (PointSet)region, (Object)output);
        System.out.println("adaptive median is " + output.getRealDouble());
    }

    private void example4() {
        Dataset ds = this.getTestData();
        DoubleType output = new DoubleType();
        RealImageFunction imgFunc = this.mSrv.imgFunction(ds, (RealType)output);
        RealArithmeticMeanFunction meanFunc = new RealArithmeticMeanFunction((Function)imgFunc);
        RealMinFunction minFunc = new RealMinFunction((Function)imgFunc);
        RealMaxFunction maxFunc = new RealMaxFunction((Function)imgFunc);
        ArrayList<Object> funcList = new ArrayList<Object>();
        ArrayList<DoubleType> outputList = new ArrayList<DoubleType>();
        funcList.add(meanFunc);
        funcList.add(minFunc);
        funcList.add(maxFunc);
        outputList.add(new DoubleType());
        outputList.add(new DoubleType());
        outputList.add(new DoubleType());
        HyperVolumePointSet region = new HyperVolumePointSet(Intervals.dimensionsAsLongArray((Dimensions)ds));
        this.mSrv.measure(funcList, (PointSet)region, outputList);
        System.out.println("mean = " + ((DoubleType)outputList.get(0)).getRealDouble());
        System.out.println("min = " + ((DoubleType)outputList.get(1)).getRealDouble());
        System.out.println("max = " + ((DoubleType)outputList.get(2)).getRealDouble());
    }

    private void example5() {
        Dataset ds = this.getTestData();
        DoubleType output = new DoubleType();
        RealImageFunction imgFunc = this.mSrv.imgFunction(ds, (RealType)output);
        BasicStatsFunction statFunc = new BasicStatsFunction((Function)imgFunc, (RealType)new DoubleType());
        HyperVolumePointSet region = new HyperVolumePointSet(Intervals.dimensionsAsLongArray((Dimensions)ds));
        BasicStats stats = new BasicStats();
        this.mSrv.measure((Function)statFunc, (PointSet)region, (Object)stats);
        System.out.println("mean = " + stats.getXBar());
        System.out.println("var = " + stats.getS2n1());
    }

    private void example6() {
        Dataset ds = this.getTestData();
        IntType output = new IntType();
        RealImageFunction imgFunc = this.mSrv.imgFunction(ds, (RealType)output);
        CustomFunction func = new CustomFunction((Function<long[], IntType>)imgFunc);
        HyperVolumePointSet region = new HyperVolumePointSet(Intervals.dimensionsAsLongArray((Dimensions)ds));
        this.mSrv.measure((Function)func, (PointSet)region, (Object)output);
        System.out.println("total 7's = " + output.get());
    }

    private class CustomFunction
    implements Function<PointSet, IntType> {
        private Function<long[], IntType> data;
        private IntType tmp;

        public CustomFunction(Function<long[], IntType> data) {
            this.data = data;
            this.tmp = new IntType();
        }

        public void compute(PointSet input, IntType output) {
            int numSevens = 0;
            for (long[] coord : input) {
                this.data.compute((Object)coord, (Object)this.tmp);
                if (this.tmp.get() != 7) continue;
                ++numSevens;
            }
            output.set(numSevens);
        }

        public IntType createOutput() {
            return new IntType();
        }

        public Function<PointSet, IntType> copy() {
            return new CustomFunction((Function<long[], IntType>)this.data.copy());
        }
    }
}

