/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.display;

import java.util.List;
import net.imagej.Position;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.table.DefaultResultsTable;
import net.imagej.table.ResultsTable;
import net.imglib2.display.ColorTable;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Color"), @Menu(label="Show LUT As Table", weight=13.0)}, attrs={@Attr(name="no-legacy")})
public class ShowLUTAsTable
extends ContextCommand {
    @Parameter
    private ImageDisplayService imgDispService;
    @Parameter
    private ImageDisplay display;
    @Parameter(type=ItemIO.OUTPUT, label="Look-Up Table")
    private ResultsTable table;

    public void run() {
        DatasetView view = this.imgDispService.getActiveDatasetView(this.display);
        List colorTables = view.getColorTables();
        Position planePos = view.getPlanePosition();
        long pos = planePos.getIndex();
        if (pos < 0L || pos >= (long)colorTables.size()) {
            pos = 0L;
        }
        ColorTable colorTable = (ColorTable)colorTables.get((int)pos);
        int rowCount = colorTable.getLength();
        int componentCount = colorTable.getComponentCount();
        int colCount = componentCount + 1;
        this.table = new DefaultResultsTable(colCount, rowCount);
        this.table.setColumnHeader(0, "Index");
        for (int x = 0; x < componentCount; ++x) {
            this.table.setColumnHeader(x + 1, "CH" + x);
        }
        for (int y = 0; y < rowCount; ++y) {
            this.table.setValue(0, y, (double)y);
            for (int x = 0; x < componentCount; ++x) {
                double value = colorTable.get(x, y);
                this.table.setValue(x + 1, y, value);
            }
        }
    }
}

